(function () {
    'use strict';

    angular.module('sys.utils.libraries')
        .factory('notifyAlert', notifyAlert);

    notifyAlert.$inject = ['notify'];


    function notifyAlert(notify) {

        var messageTemplate = '<span></span>';
        var position = 'center';
        var duration = 2500;


        var notifyAlert = {
            warning: warning,
            info: info,
            error: error,
            success: success
        };
        return notifyAlert;

        function info(message) {
            notify({
                messageTemplate: '<span>'+message+'</span>',
                duration: duration,
                position: position,
            });
        }

        function error(message) {
            notify({
                messageTemplate: '<span>'+message+'</span>',
                duration: duration,
                position: position,
                classes: 'alert-danger',
            });
        }

        function warning(message) {
            notify({
                messageTemplate: '<span>'+message+'</span>',
                duration: duration,
                position: position,
                classes: 'alert-warning',
            });
        }

        function success(message) {
            notify({
                messageTemplate: '<span>'+message+'</span>',
                duration: duration,
                position: position,
                classes: 'alert-success',
            });
        }
    }
})();
