(function () {
    'use strict';
    angular.module('sys.utils.libraries')
        .factory('serviceApi', serviceApi);

    serviceApi.$inject = ['RESTService', 'notifyAlert'];

    function serviceApi(RESTService, notifyAlert) {

        var dniDocument = function(document) {
            RESTService.get('services/dni', document, function (response) {
                return response;
            }, function (error) {
                return false;
            });
        };

        var rucDocument = function(document) {
            RESTService.get('services/ruc', document, function (response) {
                if(response.success == true){
                    notifyAlert.success("Datos recuperados correctamente!!");
                    return response;
                }else{
                    notifyAlert.warning(response.message);
                    // response.data = false;
                    // return response;
                }
            }, function (error) {
                return false;
            });

        };

        return {
            dniDocument: dniDocument,
            rucDocument: rucDocument
        };
    }


})();