(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ModalBillingCtrl', ModalBillingCtrl);

    ModalBillingCtrl.$inject = ['$scope', 'RESTService', '$uibModalInstance', '_', 'RESERVE',
        'EventsFactory', 'TAXES', 'Notify', 'AlertFactory', '$timeout', 'Printer', '$q', 'TYPE_DOCUMENT_SUNAT_IDS',
        'TYPE_DOCUMENT_ID'];

    function ModalBillingCtrl($scope, RESTService, $uibModalInstance, _, RESERVE, EventsFactory, TAXES,
                              Notify, AlertFactory, $timeout, Printer, $q, TYPE_DOCUMENT_SUNAT_IDS,
                              TYPE_DOCUMENT_ID) {

        //console.log(RESERVE);
        var store_id = null;
        if ('store' in RESERVE) {
            store_id = RESERVE['store'];
        }

        $scope.data_pay = {
            vouchers: [],
            concepts: [],
            type_documents: [],
            payment_methods: [],
            correlative: '',
            voucher_name: '',
            methods: [],
            price_sale: 0,
            detail_sale: 'Por consumo',
            check_custom: false,
            is_pay_all: true,
            total: 0,
            foreign_amount: 0
        };
        $scope.client_pay = {};
        $scope.is_search_client = true;
        $scope.items = [];
        $scope.is_disable_document = false;
        $scope.is_voucher_export = false;
        $scope.items_original = [];//Guarda los montos originales para que al cambiar de moneda y volver al inicio, se pueda hacer
        var is_item_array = false;
        var room = 0;
        $scope.aux_subtotal = 0;

        promiseData()
            .then(function (data) {
                if ('room' in RESERVE) {
                    room = RESERVE['room'];
                }
                if (RESERVE['flag'] === 1 && _.isNull(RESERVE['products'])) {//1
                    var first_item = {
                        'description': 'Alojamiento habitación ' + room + ' de ',
                        'price': RESERVE['response'].difference,
                        'quantity': 1,
                        id: -1,
                        'subtotal': Number(RESERVE['response'].difference)
                    };
                } else if (RESERVE['flag'] === 2 && _.isNull(RESERVE['products'])) {//2
                    var first_item = {
                        'description': 'Evento',
                        'price': RESERVE['response'].difference,
                        'quantity': 1,
                        id: -2,
                        'subtotal': Number(RESERVE['response'].difference)
                    };
                } else if (RESERVE['flag'] === 3 || RESERVE['flag'] === 1 || RESERVE['flag'] === 2) {//Ventas

                    var first_item = [];
                    is_item_array = true;
                    var is_billed = false;
                    var is_build_description = false;
                    var diff = 0;
                    if ('amount_billing' in RESERVE) {//Cuando se factura una parte, y se asigna nuevos montos a los productos
                        if (Number(RESERVE['amount_billing'].total_amount_charged) > 0) {
                            is_billed = true;
                            diff = Number(RESERVE['amount_billing'].difference);
                        }
                    }

                    if ('build_description' in RESERVE) {//Para redefinir la descripcion del producto
                        is_build_description = true;
                    }

                    for (var i in RESERVE['products']) {
                        var total = Number(RESERVE['products'][i].price) * Number(RESERVE['products'][i].quantity);
                        var price = Number(RESERVE['products'][i].price);
                        if (is_billed) {
                            if (price > diff) {
                                price = diff;
                            } else {
                                diff = diff - price;
                            }
                        }

                        var str_description;
                        if (is_build_description) {
                            //str_description = Number(RESERVE['products'][i].quantity) + 'x' + price + ' ' + RESERVE['products'][i].description;
                            str_description = RESERVE['products'][i].description;
                        } else {
                            str_description = RESERVE['products'][i].description;
                        }

                        var obj = {
                            'description': str_description,
                            'price': price,
                            'quantity': Number(RESERVE['products'][i].quantity),
                            'id': RESERVE['products'][i].id,
                            'store_id': RESERVE['products'][i].store_id,
                            'subtotal': Number(RESERVE['products'][i].quantity) * price
                        };
                        first_item.push(obj);
                        if (!_.isUndefined(RESERVE['products'][i].subtotal)) {
                            $scope.aux_subtotal += Number(RESERVE['products'][i].subtotal);
                        } else {
                            $scope.aux_subtotal += Number(RESERVE['products'][i].quantity) * price
                        }

                    }
                } else if (RESERVE['flag'] === 4) {//Cuando se envia varios id de chargetimes, todavia en desarrollo
                    var first_item = {
                        'description': 'Consumo',
                        'price': RESERVE['response'].difference,
                        'quantity': 1,
                        'id': -4,
                        'subtotal': RESERVE['response'].difference
                    };
                }
                if (is_item_array) {
                    $scope.items = first_item;
                    $scope.items_original = angular.copy($scope.items);//Contiene los montos originales, y sirve para cuando se cambia entre divisas y calcular subtotales
                } else {
                    $scope.items.push(first_item);
                    $scope.items_original = angular.copy($scope.items);
                }

                $scope.tax = 0;
                /*if (Number($scope.aux_subtotal) > 0){
                 $scope.subtotal = $scope.aux_subtotal;
                 }else{
                 $scope.subtotal = RESERVE['response'].difference;
                 }*/
                $scope.subtotal = RESERVE['response'].difference;
                $scope.total_to_bill = Number($scope.subtotal) + $scope.tax;
            });


        function promiseData() {
            var defered = $q.defer();
            var promise = defered.promise;

            RESTService.all('data_payment_for_bill', null, function (response) {
                defered.resolve(response);
                if (!_.isUndefined(response.status)) {
                    $scope.show_message_ruc = false;
                    $scope.data_pay.vouchers = response.vouchers;
                    $scope.data_pay.type_products = response.type_products;
                    $scope.data_pay.voucher_id = response.vouchers[0];
                    $scope.data_pay.concepts = response.concepts;
                    $scope.data_pay.concept_id = response.concepts[6];
                    $scope.data_pay.payment_methods = response.payment_methods;
                    $scope.data_pay.payment = response.payment_methods[0];
                    $scope.data_pay.method_id = response.payment_methods[0];
                    $scope.data_pay.currency = response.currency;
                    $scope.data_pay.currency_id = response.currency[0];
                    $scope.exchange_rate = Number(response.currency[0].exchange_rate);
                    $scope.data_pay.type_documents = response.type_documents;
                    //$scope.data_pay.type_document_id = response.type_documents[0];
                    $scope.data_pay.stores = response.stores;

                    if (!_.isNull(store_id)) {
                        // for (var a in response.stores){
                        //     var it_ = response.stores[a];
                        //     if (it_.id === store_id){
                        //         $scope.selected_store = it_;
                        //         break;
                        //     }
                        // }
                    }
                    if ('client' in RESERVE) {
                        if (_.isUndefined(RESERVE['client']) || _.isNull(RESERVE['client']) || RESERVE['client'].id === 1) {
                            $scope.$broadcast('angucomplete-alt:changeInput', 'document_pay', '');
                        } else {
                            $timeout(function () {
                                $scope.client_pay = RESERVE['client'];
                                $scope.$broadcast('angucomplete-alt:changeInput', 'document_pay', RESERVE['client'].document);
                            }, 300);
                        }
                    } else {
                        $scope.$broadcast('angucomplete-alt:changeInput', 'document_pay', '');
                    }
                    $scope.changeTypeDocument();
                    $scope.data_pay.total = RESERVE['response'].difference;
                }
            });

            return promise;
        }

        $scope.extract_ruc = function (ruc) {
            $scope.loading_message = "Extrayendo datos";
            $("#loadingSunat").css("display", "block");
            var option = 'ruc=' + ruc;
            RESTService.all('get_ruc', option, function (response) {
                    $scope.show_message_ruc = response.success;
                    $scope.status_extract = true;
                    $scope.is_search_client = $scope.status_extract;
                    $scope.client_pay.alert = response.result.alert;
                    $scope.client_pay.document = response.result.ruc;
                    $scope.client_pay.address = response.result.fiscal_address;
                    $scope.client_pay.status_sunat = response.result.status;
                    $scope.client_pay.condition_sunat = response.result.condition;
                    $scope.$broadcast('angucomplete-alt:changeInput', 'document_pay', response.result.ruc);
                    $scope.client_pay.label = response.result.social_reason;
                    $("#loadingSunat").css("display", "none");
                },
                function (error) {
                    $("#loadingSunat").css("display", "none");
                }
            );
        };

        $scope.changeTypeDocumentClient = function (type_document) {

        };

        $scope.change_export = function () {
            if ($scope.is_voucher_export) {
                $scope.data_pay.type_document_id = getVoucherObject(TYPE_DOCUMENT_ID.NO_DOMICILED);
                $scope.is_disable_document = true;
            } else {
                if ($scope.data_pay.voucher_id.sunat_id === TYPE_DOCUMENT_SUNAT_IDS.FACTURA) {
                    $scope.data_pay.type_document_id = getVoucherObject(TYPE_DOCUMENT_ID.RUC);
                    $scope.is_disable_document = true;
                }
                if ($scope.data_pay.voucher_id.sunat_id === TYPE_DOCUMENT_SUNAT_IDS.BOLETA) {
                    $scope.data_pay.type_document_id = getVoucherObject(TYPE_DOCUMENT_ID.DNI);
                    $scope.is_disable_document = false;
                }
            }
        };

        $scope.changeTypeDocument = function () {
            $scope.status_extract = false;
            $scope.show_message_ruc = false;
            $scope.client_pay = {};

            var voucher_;
            if (_.isUndefined($scope.data_pay.voucher_id)) {
                voucher_ = $scope.data_pay.vouchers[0].id;
                $scope.data_pay.voucher_id = $scope.data_pay.vouchers[0];
            } else {
                voucher_ = $scope.data_pay.voucher_id.id;
            }
            if (_.isNull(store_id)) {
                RESTService.get('serie', voucher_, function (response) {
                    if (!_.isUndefined(response.status)) {
                        $scope.data_pay.correlative = response.correlative;
                    }
                });
            } else {
                var data = 'voucher=' + $scope.data_pay.voucher_id.id + '&store=' + store_id;
                RESTService.all('serie_by_store', data, function (response) {
                    if (!_.isUndefined(response.status)) {
                        $scope.data_pay.correlative = response.correlative;
                        var sunat_id = response.voucher.sunat_id;
                        if (sunat_id === TYPE_DOCUMENT_SUNAT_IDS.FACTURA) {
                            $scope.data_pay.type_document_id = getVoucherObject(TYPE_DOCUMENT_ID.RUC);
                            $scope.is_disable_document = true;
                        } else {
                            $scope.data_pay.type_document_id = getVoucherObject(TYPE_DOCUMENT_ID.DNI);
                            $scope.is_disable_document = false;
                        }
                    }
                });
            }

            $scope.$broadcast('angucomplete-alt:changeInput', 'document_pay', null);
            $scope.is_search_client = $scope.data_pay.voucher_id.id === 0;
        };

        $scope.inputChanged = function (str) {
            $scope.client_pay.document = str;
        };

        $scope.clientSelectedPay = function (response) {
            if (!_.isUndefined(response)) {
                var client = response.originalObject;
                $scope.$broadcast('angucomplete-alt:changeInput', 'document_pay', client.document);
                $scope.client_pay = client;
                $scope.client_pay.is_client = true;
            } else {
                $scope.client_pay = {};
            }
        };

        $scope.addToModal = function () {
            var total = 0;
            if ($scope.items.length === 0) {
                total = Number(RESERVE['response'].difference);
            } else {
                if ($scope.items.length === 20) {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'Sólo es posible agregar 20 items por factura.'
                    });
                    return false;
                }
                total = calculate_remain();
            }
            $scope.items.push({
                description: null,
                price: total,
                quantity: 1,
                subtotal: total
            });

            $scope.items_original.push({
                description: null,
                price: total,
                quantity: 1,
                subtotal: total
            });

            $scope.subtotal = Number($scope.subtotal) + total;
            $scope.total_to_bill = Number($scope.subtotal) + Number($scope.tax);
            if ($scope.items.length > 1) {
                angular.element('#currency_id').attr('disabled', 'disabled');
                angular.element('#exchange_rate').attr('disabled', 'disabled');
            }

        };

        $scope.removeItemModal = function ($index) {//Quitar un elemento
            $scope.items.splice($index, 1);
            /*if ($scope.items.length > 1) {
                $scope.items[$index - 1].subtotal = Number(Number($scope.items[$index - 1].subtotal) + Number($scope.items[$index].subtotal)).toFixed(2);
                $scope.items[$index - 1].subtotal = Number($scope.items[$index - 1].subtotal);
                //$scope.items[$index].price = Number($scope.items[$index].subtotal) / Number($scope.items[$index].quantity);
            }*/
            var subtotal = 0;
            for (var i in $scope.items) {
                subtotal += Number($scope.items[i].subtotal);
            }
            $scope.subtotal = Number(subtotal);
            var aux_total = Number($scope.subtotal) + Number($scope.tax);
            aux_total = aux_total.toFixed(2);
            $scope.total_to_bill = Number(aux_total);
            $scope.items_original.splice($index, 1);
            if ($scope.items.length === 1) {
                angular.element('#currency_id').removeAttr('disabled');
                angular.element('#exchange_rate').removeAttr('disabled');
            }

        };

        // sunat_id del voucher
        function getVoucherObject(sunat_id) {
            return $scope.data_pay.type_documents.filter(function (item, i) {
                //sunat_id del tipo de documento
                return item.sunat_id === sunat_id;
            })[0];
        }

        function calculate_remain() {//Cuando se agrega otro item, calcula su subtotal dependiendo de lo q falta x pagar
            var aux_total = 0;
            var real_amount = RESERVE['response'].difference;
            if ($scope.data_pay.currency_id.id !== 1) {
                real_amount = $scope.data_pay.foreign_amount;
            }
            for (var i in $scope.items) {
                aux_total += Number($scope.items[i].subtotal);
            }
            var total = Number(real_amount) - aux_total;
            return Number(total.toFixed(2));
        }

        $scope.verify_total = function (price, $index) {//Configura el subtotal y precio de cada item
            var total = 0;
            for (var i in $scope.items) {
                if (Number($index) !== Number(i)) {
                    total += Number($scope.items[i].subtotal);
                }
            }
            var subtotal = total + Number(price);
            if (subtotal > Number(RESERVE['response'].difference)) {
                var diff_ = RESERVE['response'].difference - total;
                if (diff_ > 0) {
                    $scope.items[$index].subtotal = RESERVE['response'].difference - total;
                } else {
                    $scope.items[$index].subtotal = 0;
                }
            } else {
                $scope.items[$index].subtotal = Number(price);
            }
            var new_price = Number($scope.items[$index].subtotal) / Number($scope.items[$index].quantity);
            $scope.items[$index].price = Number(new_price);
            var aux_subtotal = total + Number($scope.items[$index].subtotal);
            aux_subtotal = aux_subtotal.toFixed(2);
            $scope.subtotal = Number(aux_subtotal);
            var aux_total = Number($scope.subtotal) + Number($scope.tax);
            aux_total = aux_total.toFixed(2);
            $scope.total_to_bill = Number(aux_total);
        };

        function validateDataAmortizar() {
            for (var key in $scope.items) {
                if (_.isNull($scope.items[key].description) || _.isEmpty($scope.items[key].description)) {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'La descripción del producto/servicio no puede estar vacío.'
                    });
                    return false;
                }

                if (_.isUndefined($scope.items[key].sunat_id) || _.isNull($scope.items[key].description)
                    || _.isEmpty($scope.items[key].description)) {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'Tienes que escoger un tipo de producto'
                    });
                    return false;
                }

            }

            return true;
        }

        function validateData() {
            if ($scope.items.length === 0) {
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'El detalle no puede estar vacio.'
                });
                return false;
            }
            if (!_.isUndefined($scope.data_pay.voucher_id)) {
                if ($scope.data_pay.voucher_id.sunat_id === '03') {
                    if (!_.isEmpty($scope.client_pay)) {

                        if (_.isUndefined($scope.client_pay) || _.isEmpty($scope.client_pay)) {
                            AlertFactory.showWarning({
                                title: 'Alerta',
                                message: 'Debe ingresar un cliente'
                            });
                            angular.element(document.querySelector('#payClient_value')).focus();
                            return false;
                        } else if (!_.isUndefined($scope.client_pay) || !_.isEmpty($scope.client_pay)) {
                            if ($scope.client_pay.sunat_id == 1) {
                                if ($scope.client_pay.document.length < 8 || $scope.client_pay.document.length > 8) {
                                    AlertFactory.showWarning({
                                        title: 'Alerta',
                                        message: 'El número de DNI no debe ser menor o mayor de 8 dígitos'
                                    });
                                    angular.element(document.querySelector('#document_pay')).focus();
                                    return false;
                                }
                            }
                        }
                    }
                }
            }

            if ($scope.data_pay.voucher_id.sunat_id === '01' && !$scope.is_voucher_export) {
                if (!_.isEmpty($scope.client_pay)) {
                    if (!_.isUndefined($scope.client_pay.document)) {
                        if ($scope.client_pay.document.length < 11) {
                            AlertFactory.showWarning({
                                title: 'Alerta',
                                message: 'Debe ingresar un número de RUC válido'
                            });
                            angular.element(document.querySelector('#document_pay')).focus();
                            return false;
                        } else if (_.isEmpty($scope.client_pay.address) || _.isNull($scope.client_pay.address)) {
                            AlertFactory.showWarning({
                                title: 'Alerta',
                                message: 'Debe ingresar la direccion del cliente'
                            });
                            angular.element(document.querySelector('#address_pay')).focus();
                            return false;
                        }
                    } else {
                        AlertFactory.showWarning({
                            title: 'Alerta',
                            message: 'Debe ingresar un número de RUC válido'
                        });
                        angular.element(document.querySelector('#document_pay')).focus();
                        return false;
                    }

                } else {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'Debe llenar todos los datos de un cliente'
                    });
                    return false;
                }

            }else{


            }

            var sum_total = 0;
            for (var key in $scope.items) {
                if (_.isNull($scope.items[key].description) || _.isEmpty($scope.items[key].description)) {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'La descripción del producto/servicio no puede estar vacío.'
                    });
                    return false;
                }

                if (_.isUndefined($scope.items[key].sunat_id) || _.isNull($scope.items[key].description)
                    || _.isEmpty($scope.items[key].description)) {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'Tienes que escoger un tipo de producto'
                    });
                    return false;
                }

                // if (_.isUndefined($scope.items[key].store_id) || _.isNull($scope.items[key].store_id)
                //     || _.isEmpty($scope.items[key].store_id)) {
                //     AlertFactory.showWarning({
                //         title: 'Alerta',
                //         message: 'Tienes que escoger un almacén'
                //     });
                //     return false;
                // } else {
                //     if (_.isNull($scope.items[key].store_id.having_account) ||
                //         _.isEmpty($scope.items[key].store_id.having_account)) {
                //         AlertFactory.showWarning({
                //             title: 'Alerta',
                //             message: 'El almacén ' + $scope.items[key].store_id.description + ' no posee una cuenta contable asignada. ' +
                //                 'Comuníquese con el administrador para que asigne la cuenta de dicho almacén'
                //         });
                //         return false;
                //     }
                // }

                sum_total += Number($scope.items[key].subtotal);

            }

            if (sum_total > 700 && (_.isUndefined($scope.client_pay) || _.isEmpty($scope.client_pay))) {
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'Las deudas mayores a S/ 700.00 deben consignar un cliente'
                });
                return false;
            }

            if ($scope.data_pay.currency_id.id === 1) {
                if (sum_total > Number($scope.data_pay.total)) {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'El monto ' + sum_total + ' en soles de los items no debe ser mayor al monto total a facturar de ' + $scope.data_pay.total + '.'
                    });
                    return false;
                }
            }

            if (!_.isUndefined($scope.is_voucher_export)) {
                if (!$scope.is_voucher_export) {
                    delete $scope.is_voucher_export;
                }
            }

            return true;

        }

        $scope.actionPay = function () {
            var validated;
            var msg = '';
            var id;
            if ($scope.data_pay.voucher_id.id === 0) {
                validated = validateDataAmortizar();
                msg = 'Está por realizar la acción sin generar ningún tipo de comprobante, ¿está seguro que desea continuar?';
            } else {
                validated = validateData();
                msg = '¿Está seguro que desea realizar la facturación?';
            }

            if (validated) {
                var options = {
                    message: msg,
                    confirm: 'Si',
                    cancel: 'No'
                };
                if (RESERVE['flag'] !== 4) {
                    id = RESERVE['id'];
                } else {
                    id = RESERVE['id'][0];
                }
                AlertFactory.confirm(options, function (options) {
                    if (_.isEmpty($scope.client_pay)) {
                        $scope.client_pay.id = 1;
                    }
                    var pay_data = {
                        'correlative': $scope.data_pay.correlative,
                        'subtotal': $scope.subtotal,
                        'tax': $scope.tax,
                        'method_payment': $scope.data_pay.payment,
                        'billing': $scope.total_to_bill,
                        'voucher': $scope.data_pay.voucher_id,
                        'details': $scope.items,
                        'foreign_amount': $scope.data_pay.foreign_amount,
                        'currency': $scope.data_pay.currency_id,
                        'exchange_rate': $scope.exchange_rate,
                        'total_national': $scope.data_pay.total
                    };
                    //Flag exportacion
                    if (!_.isUndefined($scope.is_voucher_export)) {
                        if ($scope.is_voucher_export) {
                            pay_data.is_voucher_export = 1;
                        }
                    }

                    delete $scope.client_pay.alert;

                    var data = {
                        'client': $scope.client_pay,
                        'document': $scope.data_pay.type_document_id,
                        'primary_key': RESERVE['id'],
                        'data_pay': pay_data,
                        'type_action': RESERVE['flag'],//1:recepcion, 2:Evento, 3:Ventas, 4: Facturacion multiples registros
                        'store': store_id
                    };

                    angular.element("#bill_now").attr('disabled', 'disabled');

                    EventsFactory.pushBroadcast('showSysLoading', {message: "Guardando..."});
                    $scope.loading_message = "Emitiendo comprobante";
                    $("#loadingSunat").css("display", "block");

                    RESTService.updated('reception_billing', id, data, function (response) {
                        EventsFactory.pushBroadcast('hideSysLoading');
                        Notify.success("Se grabó el pago correctamente");
                        if (response.print) {
                            Printer.printPdfBase64(response.pdf_base64);
                        }
                        $uibModalInstance.close(response);
                        $("#loadingSunat").css("display", "none");
                        angular.element("#bill_now").removeAttr('disabled');
                    }, function (error) {
                        EventsFactory.pushBroadcast('hideSysLoading');
                        $("#loadingSunat").css("display", "none");
                        AlertFactory.textType({
                            title: error.data.status,
                            message: error.data.message,
                            type: 'warning'
                        });
                        angular.element("#bill_now").removeAttr('disabled');
                        return false;
                    });
                });
            }
        };

        $scope.setupPayment = function (item) {//Cuando se cambia de divisa y calcula subtotales, precios
            $scope.exchange_rate = Number(item.exchange_rate_hotel);
            if (item.id === 1) {
                $scope.data_pay.foreign_amount = 0;
            } else {
                $scope.data_pay.foreign_amount = calculated_foreign_amount(RESERVE['response'].difference + $scope.tax, item.exchange_rate_hotel);
            }
            var amount_compare = RESERVE['response'].difference;
            var new_total_products = 0;//sumar subtotales de los productos
            for (var i in $scope.items) {
                if ($scope.items.length > 1) {
                    amount_compare = $scope.items_original[i].subtotal;
                }
                var new_price = calculated_foreign_amount(amount_compare, item.exchange_rate_hotel);
                // $scope.items[i].subtotal = Number(new_price);
                // $scope.items[i].price = Number(new_price) / Number($scope.items[i].quantity);
                // new_total_products += Number(new_price);
                var unit_price = Number(Number(Number(new_price) / Number($scope.items[i].quantity)).toFixed(2));
                $scope.items[i].price = unit_price;
                $scope.items[i].subtotal = unit_price * $scope.items[i].quantity;
                new_total_products += $scope.items[i].subtotal;
            }
            $scope.subtotal = calculated_foreign_amount(RESERVE['response'].difference, item.exchange_rate_hotel);
            $scope.total_to_bill = calculated_foreign_amount(RESERVE['response'].difference + $scope.tax, item.exchange_rate_hotel);
            if (item.id !== 1) {//Verifica si la conversion de la divisa es menor
                if (new_total_products < Number($scope.data_pay.foreign_amount)) {//Si lo es, sumar lo q falta a un item
                    var diff = Number(Number($scope.data_pay.foreign_amount) - new_total_products).toFixed(2);
                    $scope.items[0].subtotal = Number($scope.items[0].subtotal) + Number(diff);
                } else if (new_total_products > Number($scope.data_pay.foreign_amount)) {//TODO: Falta tomar en cuentas el tax
                    $scope.subtotal = new_total_products;
                    $scope.total_to_bill = new_total_products;
                    $scope.data_pay.foreign_amount = new_total_products;
                }
            }
        };

        function calculated_foreign_amount(amount, rate) {
            var calculated_amount = Number(amount) / Number(rate);
            return Number(calculated_amount).toFixed(2);
        }

        //Cuando se cambia el Tipo de cambio
        $scope.recalculated_foreign_exchange = function (item) {
            if ($scope.data_pay.currency_id.id !== 1) {
                var subtotal = 0;
                for (var i in $scope.items) {
                    //var new_price = calculated_foreign_amount(RESERVE['response'].difference, item);
                    var new_price = calculated_foreign_amount($scope.items_original[i].subtotal, item);
                    $scope.items[i].subtotal = Number(new_price);
                    $scope.items[i].price = Number($scope.items[i].subtotal) / Number($scope.items[i].quantity);
                    subtotal += Number(new_price);
                }
                //$scope.subtotal = calculated_foreign_amount(RESERVE['response'].difference, item);
                subtotal = Number(subtotal.toFixed(2));
                $scope.subtotal = subtotal;
                //$scope.total_to_bill = calculated_foreign_amount(RESERVE['response'].difference + $scope.tax, item);
                $scope.total_to_bill = subtotal + Number(calculated_foreign_amount($scope.tax, item));
                //$scope.data_pay.foreign_amount = calculated_foreign_amount(RESERVE['response'].difference + $scope.tax, item);
                $scope.data_pay.foreign_amount = subtotal + Number(calculated_foreign_amount($scope.tax, item));
            }
        };

        //Al cambiar el tipo del producto
        $scope.set_type_product = function (sunat, data, $index) {
            //sunat.sunat_code: 2001(producto), 2002(servicio), 2003(contrato)
            /*if (Number(sunat.sunat_code) === 2001){//Dividir el subtotal x cantidad, para tener el PU
                if ($scope.data_pay.currency_id.id === 1) {
                    $scope.items[$index].quantity = $scope.items_original[$index].quantity;
                    $scope.items[$index].price = $scope.items_original[$index].price;
                }else{
                    //console.log($scope.items[$index]); return false;
                    //$scope.items[$index].subtotal = Number(new_price);
                    $scope.items[$index].price = Number($scope.items[$index].subtotal) / Number($scope.items[$index].quantity);
                }
            }else{//Cambiar la cantidad a 1, y el precio sea igual al subtotal
                $scope.items[$index].quantity = 1;
                $scope.items[$index].price = Number($scope.items[$index].subtotal);
            }*/
        };

        $scope.verify_quantity = function (data, $index) {
            var subtotal = 0;
            var new_price = Number($scope.items[$index].price) * Number(data);
            $scope.items[$index].subtotal = Number(Number(new_price).toFixed(2));
            for (var i in $scope.items) {
                subtotal += Number($scope.items[i].subtotal);
            }
            $scope.subtotal = Number(Number(subtotal).toFixed(2));
            var aux_total = Number($scope.subtotal) + Number($scope.tax);
            aux_total = aux_total.toFixed(2);
            $scope.total_to_bill = Number(aux_total);
        };

        $scope.verify_unit_price = function (data, $index) {
            var subtotal = 0;
            var new_price = Number(data) * Number($scope.items[$index].quantity);
            $scope.items[$index].subtotal = Number(new_price.toFixed(2));

            for (var i in $scope.items) {
                subtotal += Number($scope.items[i].subtotal);
            }
            $scope.subtotal = Number(subtotal).toFixed(2);
            var aux_total = Number($scope.subtotal) + Number($scope.tax);
            aux_total = aux_total.toFixed(2);
            $scope.total_to_bill = Number(aux_total);
        };

        $scope.$on('modal.closing', function (event) {
            cleanSaleSave();
        });

        $scope.closeModal = function () {
            $uibModalInstance.dismiss('cancel');
            cleanSaleSave();
        };

        function cleanSaleSave() {
            resetModal();
        }

        function resetModal() {
            TAXES.modal = null;
            $uibModalInstance = null;
        }

    }
})();
