(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ModalReportOrderCtrl', ModalReportOrderCtrl);

    ModalReportOrderCtrl.$inject = ['$scope', '$uibModalInstance', '$timeout', 'ORDER', 'HelperFactory'];

    function ModalReportOrderCtrl($scope, $uibModalInstance, $timeout, ORDER, HelperFactory) {


        $scope.report = {
            'date_order': moment().format('YYYY-MM-DD')
        }


        sync()

        function sync() {

            $timeout(function () {
                $('#date_order').daterangepicker({
                    locale: {
                        format: 'YYYY-MM-DD'
                    },
                    singleDatePicker: true,
                    showDropdowns: true,
                    minDate: new Date()
                });
            }, 50);

            $scope.shifts = ORDER.SHIFT;
            $scope.shiftSelected = ORDER.SHIFT[0];

        }

        $scope.closeModal = function () {
            $uibModalInstance.dismiss('cancel');
        };

        $scope.save = function () {

            if(validate()){
                // var base_url = window.location.origin;
                window.open('api/report/orders_general/?date_order='+ $scope.report.date_order + '&shift='+ $scope.shiftSelected.id, '_blank');
                $uibModalInstance.close();

            }
        };


        function validate() {

            if ( $scope.shiftSelected.id == 0) {
                HelperFactory.show_AlertFactory('Debe seleccionar el turno');
                angular.element(document.querySelector('#shiftSelected')).focus();
                return false;
            }

            if (_.isUndefined($scope.report.date_order) || _.isNull($scope.report.date_order)) {
                HelperFactory.show_AlertFactory('Debe seleccionar una fecha');
                angular.element(document.querySelector('#date_order')).focus();
                return false;
            }

            return true;
        };

        $scope.selectedShift = function (item) {
            $scope.shiftSelected = item;
        }


    }
})();
