(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('MyAccountViewCtrl', MyAccountViewCtrl);

    MyAccountViewCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout','fileReader', 'CLIENT', 'TYPE_DOCUMENT', '$uibModal'];

    function MyAccountViewCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, fileReader, CLIENT, TYPE_DOCUMENT, $uibModal) {

        var loading;

        $scope.user = PARAM.data
        $scope.change_password = false;

        init()

        function init() {

            RESTService.all('user/list_profile', null, function (response) {
                $scope.profiles = response.results;
                $scope.profileSelected = response.results[0];
                profileSelected($scope.user.profile_id);
            });

            $timeout(function () {
                loading = angular.element(document.querySelector('#loading_modal'));
            }, 100);
        }

        function profileSelected(id) {
            if(!_.isUndefined(id)){
                $scope.profileSelected = ConfigPagination.searchById(id,$scope.profiles);
            }
        }

        $scope.activeChangePassword = function (item) {
            $scope.change_password = item;
            if($scope.change_password == true){
                $timeout(function () {
                    angular.element(document.querySelector('#user_password')).focus();
                }, 50);
            }
        };

        $scope.save = function () {
            if (validate()) {

                loading.show();

                $scope.user['change_password'] = $scope.change_password;

                RESTService.updated('user/updatepassword', $scope.user.id, $scope.user, function (result) {
                    notifyAlert.success("Contraseña modificada con éxito!!");
                    $uibModalInstance.close(result);
                }, function (error) {
                    loading.hide();
                    console.log('ERROR');
                    return false;
                });
            }
        };

        function validate() {
            if($scope.change_password == true){
                if (_.isNull($scope.user.password) || _.isEmpty($scope.user.password)) {
                    HelperFactory.show_AlertFactory('Debe ingresar la contraseña');
                    angular.element(document.querySelector('#user_password')).focus();
                    return false;
                }
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
            // $uibModalInstance.dismiss('Cancelado');
            $("#loading_object").css("display","none");
        };
    }

})();
