(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ModalPurchaseProviderCtrl', ModalPurchaseProviderCtrl);

    ModalPurchaseProviderCtrl.$inject = ['$scope', '$uibModalInstance', '_', 'RESTService', 'AlertFactory',
        'EventsFactory', 'Notify'];

    function ModalPurchaseProviderCtrl($scope, $uibModalInstance, _, RESTService, AlertFactory, EventsFactory,
                                       NotifyFactory) {
        $scope.purchase = '';
        $scope.details = '';
        $scope.new_provider = false;



        $scope.extract_ruc = function ($event, ruc) {
            $event.preventDefault();
            angular.element("#message_alert").html('');
            $scope.new_provider = false;
            if (_.isUndefined(ruc) || _.isEmpty(ruc)) {
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'Ingrese el ruc'
                });
            } else {
                $("#loadingSunat").css("display", "block");
                var option = 'ruc=' + ruc;
                angular.element("#ruc_input").attr('disabled','disabled');
                angular.element("#btn-ruc").attr('disabled','disabled');
                RESTService.all('get_ruc', option, function (response) {
                        angular.element("#message_alert").html(response.result.alert);
                        //$scope.entity.social_reason = response.result.social_reason;
                        //$scope.entity.address = response.result.fiscal_address;
                        $("#loadingSunat").css("display", "none");
                        angular.element("#ruc_input").removeAttr('disabled');
                        angular.element("#btn-ruc").removeAttr('disabled');
                        $scope.provider_new = response.result;
                        $scope.new_provider = true;
                    },
                    function (error) {
                        angular.element("#ruc_input").removeAttr('disabled');
                        angular.element("#btn-ruc").removeAttr('disabled');
                        $("#loadingSunat").css("display", "none");
                    });
            }
        };

        function validate_data(){
            if (_.isUndefined($scope.provider_new.social_reason) || _.isEmpty($scope.provider_new.social_reason)) {
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'El nombre del proveedor no debe estar vacio'
                });
                angular.element(document.querySelector('#social_reason')).focus();
                return false;
            }

            if (_.isUndefined($scope.provider_new.ruc) || _.isEmpty($scope.provider_new.ruc)) {
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'El ruc no debe estar vacío'
                });
                angular.element(document.querySelector('#ruc')).focus();
                return false;
            }

            if ($scope.provider_new.ruc.length < 11){
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'El ruc no debe ser menor de 11 caracteres'
                });
                angular.element(document.querySelector('#ruc')).focus();
                return false;
            }

            if (_.isUndefined($scope.provider_new.fiscal_address) || _.isEmpty($scope.provider_new.fiscal_address)) {
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'La direccion del proveedor no debe estar vacía'
                });
                angular.element(document.querySelector('#social_reason')).focus();
                return false;
            }

            return true;
        }

        $scope.add_provider = function () {
            var status = validate_data();
            if (status) {
                EventsFactory.pushBroadcast('showSysLoading', {message: "Guardando..."});
                RESTService.save('purchase/save_provider', $scope.provider_new, function (response) {
                    EventsFactory.pushBroadcast('hideSysLoading');
                    NotifyFactory.success("Se agregó correctamente el proovedor");
                    $uibModalInstance.close(response);
                }, function (error) {
                    EventsFactory.pushBroadcast('hideSysLoading');
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: error.data
                    });
                    return false;
                });
            }
        };



        $scope.closeModal = function () {
            $uibModalInstance.dismiss('cancel');
            $uibModalInstance = null;
        };

        $scope.agree = function () {
            agree();
        };

        function agree() {
            $uibModalInstance.close();
        }

    }


})();