(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .factory('HelperFactory', HelperFactory);

    HelperFactory.$inject = ['$location', '_', 'AlertFactory'];

    function HelperFactory($location, _, AlertFactory) {
        var functions = {
            roundToTwo: roundToTwo,
            addZerosLeft: addZerosLeft,
            capitalizeFirstLetter: capitalizeFirstLetter,
            getDateShort: getDateShort,
            getSubDomain: getSubDomain,
            calculateIGV: calculateIGV,
            cleanObject: cleanObject,
            arrayToHtml: arrayToHtml,
            getCurrentDateHora: getCurrentDateHora,
            getParseDate: getParseDate,
            getUniqueId: getUniqueId,
            slugify: slugify,
            activeMenu: activeMenu,
            remove_data_on_select:remove_data_on_select,
            add_data_on_select: add_data_on_select,
            convert_to_time_moment: convert_to_time_moment,
            show_AlertFactory: show_AlertFactory,
            selectedLogic: selectedLogic,
            sortDeleteid: sortDeleteid
        };
        return functions;

        function slugify(text) {
            return text.toString().toLowerCase()
                .replace(/\s+/g, '-')           // Replace spaces with -
                .replace(/[^\w\-]+/g, '')       // Remove all non-word chars
                .replace(/\-\-+/g, '-')         // Replace multiple - with single -
                .replace(/^-+/, '')             // Trim - from start of text
                .replace(/-+$/, '');
        }

        function getUniqueId() {
            var d = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = (d + Math.random() * 16) % 16 | 0;
                d = Math.floor(d / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }

        function getParseDate(date) {
            if (_.isNull(date) || _.isUndefined(date)) {
                return null;
            }
            return moment(date).format('YYYY-MM-DD');
        }

        function getCurrentDateHora(onlydate) {
            var today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1; //January is 0!
            var yyyy = today.getFullYear();
            var hh = today.getHours();
            var m = today.getMinutes();
            var secs = today.getSeconds();
            if(mm < 10){
                mm = '0'+mm;
            }
            if(_.isUndefined(onlydate)){
                var now = yyyy + "-" + mm + "-" + dd + "T" + hh + ":" + m + ":" + secs;
            }else if(!onlydate){
                var now = yyyy + "-" + mm + "-" + dd;
            }
            return now;
        }

        function arrayToHtml(object) {
            if (_.isArray(object)) {
                console.log(true);
            }
        }

        function cleanObject(object, keys) {
            for (var key in object) {
                var is_exists = keys.indexOf(key);
                if (is_exists == -1) {
                    delete object[key];
                }
            }
            return object;
        }

        function roundToTwo(num) {
            return +(Math.round(num + "e+2") + "e-2");
        }

        function addZerosLeft(num, max) {
            num = num.toString();
            return num.length < max ? addZerosLeft("0" + num, max) : num;
        }

        function capitalizeFirstLetter(string) {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }

        function getDateShort(date) {
            return moment(date).format('YYYY-MM-DD');
        }

        function getSubDomain() {
            var host = $location.host();
            if (host.indexOf('.') < 0)
                return null;
            else
                return host.split('.')[0];
        }

        function calculateIGV(price, taxe) {
            return this.roundToTwo(parseFloat(price) * parseFloat(taxe) / 100);
        }

        //Permite mantener activo un modulo en el menu lateral
        function activeMenu(location){
            var url = '/admin/u/#'+location;
            angular.element(document.querySelector('.active')).removeClass('active');
            angular.element(document.querySelector('.nav-second-level')).removeClass('in');
            angular.element(document.querySelector('li')).removeClass('active');
            angular.element(document.querySelector('li a[href="' + url + '"]')).parent().addClass('active');
            angular.element(document.querySelector('li a[href="' + url + '"]')).parents('li').children('ul').addClass('in');
        }

        //En un select, muestra solo los id de los registros que se le manda
        function remove_data_on_select(data, ids) {
              //var odds = _.reject([1, 2, 3, 4, 5, 6], function(num){ return num % 2 == 0; });
              var result = [];
              for (var i = 0; i < ids.length; i++) {
                  var odds = _.filter(data, function (num) {
                      return num.id === ids[i];
                  });

                  if (!_.isNull(odds[0]) && !_.isUndefined(odds[0]) && odds[0] !== 'undefined') {
                      result.push(odds[0]);
                  }
              }
              return result;
          }

          //En un select, quita los ids de los registros que se le manda
        function add_data_on_select(data, ids) {
              var result = [];
              for (var i = 0; i < ids.length; i++) {
                  var odds = _.filter(data, function (num) {
                      return num.id !== ids[i];
                  });

                  if(odds.length > 0){
                      for(var key in odds){
                        result.push(odds[key]);
                      }
                  }
              }
              return result;
          }

          function convert_to_time_moment(time, format){
            var dformat = 'YYYY-MM-DD HH:mm:ss';
            if(!_.isUndefined(format)){
                dformat = format;
            }
            return moment(time, dformat);
          }

        function show_AlertFactory(msg, title, type_) {
            var msg_type = 'warning';
            var msg_title = 'Advertencia';
            if(!_.isUndefined(type_)){
                msg_type = type_;
            }
            if(!_.isUndefined(title)){
                msg_title = title;
            }
            AlertFactory.textType({
                title: msg_title,
                message: msg,
                type: msg_type
            });
        }

        //Permite seleccionar varios objetos para amortizacion multiple
        function selectedLogic(input,result) {
            var items = [];
            var box = input;
            var counter = 0;
            box.each(function () {
                if ($(this).is(':checked')) {
                    items.push(searchById($(this).val(),result));
                    counter++;
                }
            });
            var data = [];
            data['items'] = items;
            data['total'] = counter;
            return data;
        }

        function searchById(id,result){
            var data = result;
            var res = [];
            for(var i = 0;i<data.length;i++){
                var indata = data[i];
                if(indata.id == id){
                    res.push(indata);
                    break;
                }
            }
            return res[0];
        }

        //Ordena el obj y solo devuelve el id
        function sortDeleteid(obj,index){
            var data = [];
            var id = '';
            for(var i=0;i<obj.length;i++){
                if(_.isEmpty(index)){
                    id =  obj[i].id;
                    data.push(id);
                }else{
                    switch(index){
                        case 'slug':
                            id =  obj[i].slug;
                            data.push(id);
                            break;
                        case 'sale':
                            id = obj[i].sale;
                            data.push(id);
                            break;
                        case 'sale_id':
                            id = obj[i].sale_id;
                            data.push(id);
                            break;
                        case 'none':
                            data.push(obj[i]);
                            break;
                        case 'value':
                            data.push(obj[i].value);
                            break;
                        case 'index':
                            data.push(obj[i].index);
                            break;
                        case 'time_charge_id':
                            data.push(obj[i].time_charge_id);
                            break;
                    }
                }
            }
            return data;
        }

    }
})();
