(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ModalPaymentAmountCtrl', ModalPaymentAmountCtrl);

    ModalPaymentAmountCtrl.$inject = ['$scope','RESTService','$uibModalInstance','_','saleScope',
        'EventsFactory','TAXES','Notify','AlertFactory'];

    function ModalPaymentAmountCtrl($scope,RESTService,$uibModalInstance,_,saleScope,EventsFactory,TAXES,
                                    Notify,AlertFactory){
        var store_id = null;
        $scope.data_pay = {
            vouchers: [],
            concepts: [],
            payment_methods: [],
            correlative: '',
            voucher_name: '',
            methods: [],
            price_sale: 0,
            detail_sale: 'Por consumo',
            check_custom: false,
            is_pay_all: true,
            total: saleScope.amount
        };
        $scope.client_pay = {};
        $scope.is_search_client = true;

        RESTService.all('data_payment_for_pay', null, function (response) {
            if (!_.isUndefined(response.status)) {
                $scope.data_pay.vouchers = response.vouchers;
                $scope.data_pay.voucher_id = response.vouchers[0];
                $scope.data_pay.concepts = response.concepts;
                $scope.data_pay.concept_id = response.concepts[6];
                $scope.data_pay.payment_methods = response.payment_methods;
                $scope.data_pay.method_id = response.payment_methods[0];
                $scope.original_amount = saleScope.amount;
                $scope.$broadcast('angucomplete-alt:changeInput', 'payClient', 'CLIENTE');
                $scope.data_pay.currency = response.currency;
                $scope.data_pay.currency_id = response.currency[0];
                $scope.data_pay.currency_id.foreign_amount = Number(saleScope.amount);
                $scope.addToMethod(saleScope.amount);
                $scope.changeTypeDocument();
            }
        });

        $scope.changeTypeDocument = function () {
            if (_.isNull(store_id)) {
                RESTService.get('serie', $scope.data_pay.voucher_id.id, function (response) {
                    if (!_.isUndefined(response.status)) {
                        $scope.data_pay.correlative = response.correlative;
                    }
                });
            } else {
                var data = 'voucher=' + $scope.data_pay.voucher_id.id+'&store='+store_id;
                RESTService.all('serie_by_store', data, function (response) {
                    if (!_.isUndefined(response.status)) {
                        $scope.data_pay.correlative = response.correlative;
                    }
                });
            }
            $scope.$broadcast('angucomplete-alt:changeInput', 'payClient', 'CLIENTE');
            $scope.client_pay = {};
                if ($scope.data_pay.voucher_id.id === 0) {
                    $scope.is_search_client = true;
                } else {
                    $scope.is_search_client = false;
                }
        };

        $scope.clientSelectedPay = function (response) {
            if (!_.isUndefined(response)) {
                var client = response.originalObject;
                $scope.$broadcast('angucomplete-alt:changeInput', 'payClient', client.label);
                $scope.client_pay = client;
                $scope.client_pay.is_client = true;
            }else{
               $scope.client_pay = {};
            }
        };

        $scope.addToMethod = function (amount) {
            if (!_.isUndefined($scope.data_pay.concepts[0]) &&
                !_.isUndefined($scope.data_pay.payment_methods[0])) {
                var total = 0;
                if($scope.data_pay.methods.length === 0){
                    total = Number(amount);
                }else{
                    total = calculate_remain();
                }
                if (total === 0){
                    AlertFactory.textType({
                    title: 'Monto Excedido',
                    message: 'No es posible agregar otro metodo de pago debido a que el valor total a amortizar ya fue asignado a los anteriores metodos de pago.',
                    type: 'warning'
                });
                    return false;
                }
                $scope.data_pay.methods.push({
                    method_id: $scope.data_pay.payment_methods[0],
                    concept_id: $scope.data_pay.concepts[6],
                    amount: total.toFixed(2),
                    glosa: '',
                    currency_id: $scope.data_pay.currency[0].id,
                    exchange_rate: 1,
                    exchange_amount: total.toFixed(2)
                });
            }
        };

        $scope.removeMethod = function ($index) {
            $scope.data_pay.methods.splice($index, 1);
        };


        function validateData() {
            if (!_.isUndefined($scope.data_pay.voucher_id)) {
                if ($scope.data_pay.voucher_id.id === 1) {
                    if (_.isUndefined($scope.client_pay) || _.isEmpty($scope.client_pay)) {
                        AlertFactory.showWarning({
                            title: 'Alerta',
                            message: 'Debe ingresar un cliente'
                        });
                        angular.element(document.querySelector('#payClient_value')).focus();
                        return false;
                    }else if (!_.isUndefined($scope.client_pay) || !_.isEmpty($scope.client_pay)) {
                        if ($scope.client_pay.document.length < 8 || $scope.client_pay.document.length > 8) {
                            AlertFactory.showWarning({
                                title: 'Alerta',
                                message: 'El número de DNI no debe ser menor o mayor de 8 dígitos'
                            });
                            angular.element(document.querySelector('#document_pay')).focus();
                            return false;
                        }

                    }
                }
            }

            if ($scope.data_pay.voucher_id.sunat_id === '01') {
                if ($scope.client_pay.document.length < 11) {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'Debe ingresar un número de RUC válido'
                    });
                    angular.element(document.querySelector('#document_pay')).focus();
                    return false;
                }else if (_.isEmpty($scope.client_pay.address) || _.isNull($scope.client_pay.address)) {
                    AlertFactory.showWarning({
                        title: 'Alerta',
                        message: 'Debe ingresar la direccion del cliente'
                    });
                    angular.element(document.querySelector('#address_pay')).focus();
                    return false;
                }
            }

            var sum_total = 0;
            for (var key in $scope.data_pay.methods){
                sum_total += Number($scope.data_pay.methods[key].amount);
            }

            if (Number($scope.data_pay.total) != sum_total) {
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'El monto a amortizar debe ser igual al monto total de la deuda'
                });
                return false;
            }

            if (sum_total > 700 && (_.isUndefined($scope.client_pay) || _.isEmpty($scope.client_pay))) {
                AlertFactory.showWarning({
                    title: 'Alerta',
                    message: 'Las deudas mayores a S/ 700.00 deben consignar un cliente'
                });
                return false;
            }

            return true;
        }

        $scope.actionPay = function () {
            if (validateData()) {
                if (_.isEmpty($scope.client_pay)){
                    $scope.client_pay.id = 1;
                }
                var pay_data = {
                    'correlative': $scope.data_pay.correlative,
                    'methods': $scope.data_pay.methods,
                    'total': $scope.data_pay.total,
                    'voucher': $scope.data_pay.voucher_id
                };
                var data = {
                    'client': $scope.client_pay,
                    'charges': saleScope.charges,
                    'data_pay': pay_data
                };

                var options = {
                    message: '¿Está seguro que desea realizar el pago?',
                    confirm: 'Si',
                    cancel: 'No'
                };
                AlertFactory.confirm(options, function (options) {
                    EventsFactory.pushBroadcast('showSysLoading', {message: "Guardando..."});
                    RESTService.updated('pay_charges', saleScope.charges[0], data, function (response) {
                        EventsFactory.pushBroadcast('hideSysLoading');
                        Notify.success("Se grabó el pago correctamente");
                        $uibModalInstance.close(response);
                    }, function (error) {
                        EventsFactory.pushBroadcast('hideSysLoading');
                        console.log('ERROR');
                        return false;
                    });
                });

            }
        };

        var original_exchange_rate = 1;
        $scope.setupPayment = function (currency, item) {
            var current_currency;
            for (var key in currency){
                if (currency[key].id === item.currency_id){
                    current_currency = currency[key];
                }
            }
            original_exchange_rate = Number(current_currency.exchange_rate_hotel);
            item.exchange_rate = Number(current_currency.exchange_rate_hotel);
            item.exchange_amount = calculated_foreign_amount(item.amount, current_currency.exchange_rate_hotel);
        };

        function calculated_foreign_amount(amount, rate){
            var calculated_amount = Number(amount) / Number(rate);
            return Number(calculated_amount).toFixed(2);
        }

        //Tipo de cambio
        $scope.recalculated_foreign_exchange = function (item, value) {
            if (_.isEmpty(item.exchange_rate) || _.isUndefined(item.exchange_rate)){
                item.exchange_rate = original_exchange_rate;
            }
            item.amount = Number(Number(item.exchange_amount) * Number(value)).toFixed(2);
        };

        $scope.verify_foreign_amount = function () {
            var calculated_amount = calculated_foreign_amount($scope.original_amount, $scope.exchange_rate_hotel);
            if (_.isEmpty($scope.data_pay.currency_id.foreign_amount) || _.isUndefined($scope.data_pay.currency_id.foreign_amount)){
                $scope.data_pay.currency_id.foreign_amount = calculated_foreign_amount($scope.original_amount, $scope.exchange_rate_hotel);
            } else if ($scope.data_pay.currency_id.foreign_amount < calculated_amount) {
                AlertFactory.textType({
                    title: 'Monto Incorrecto',
                    message: 'El pago a realizar no debe ser menor al monto base calculado',
                    type: 'warning'
                });
                $scope.data_pay.currency_id.foreign_amount = calculated_foreign_amount($scope.original_amount, $scope.exchange_rate_hotel);
            }
        };

        //calcular el monto a pagar en soles
        $scope.recalculate_total_amount_foreign = function (item, value, $index) {
            var amount = Number(Number(value) * Number(item.exchange_rate)).toFixed(2);
            item.amount = amount;

            var aux_total = 0;
            var without_last = 0;
            for (var i in $scope.data_pay.methods) {
                    aux_total += Number($scope.data_pay.methods[i].amount);
                    if (Number($index) !== Number(i)) {
                        without_last += Number($scope.data_pay.methods[i].amount);
                    }
                }
            if (item.currency_id !== 1) {
                if (aux_total > Number($scope.original_amount)) {
                    item.amount = Number($scope.original_amount) - without_last;
                }
            }
        };

        function calculate_remain() {
            var aux_total = 0;
            var total = 0;
            for (var i in $scope.data_pay.methods) {
                aux_total += Number($scope.data_pay.methods[i].amount);
            }
            total = Number($scope.original_amount) - aux_total;
            return total;
        }

        //*************************************************************************************************************

        $scope.$on('modal.closing', function (event) {
            cleanSaleSave();
        });

        $scope.closeModal = function () {
            $uibModalInstance.dismiss('cancel');
            cleanSaleSave();
        };

        function cleanSaleSave() {
            resetModal();
        }

        function resetModal() {
            TAXES.modal = null;
            $uibModalInstance = null;
        }

        //*************************************************************************************************************

    }


})();
