(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .factory('ConfigPagination', ConfigPagination);

    function ConfigPagination(){
        var functions = {
            searchById: searchById,
            selectedLogic:selectedLogic,
            sorting:sorting,
            init:init,
            sortDeleteid:sortDeleteid
        };
        return functions;

        function searchById(id,result){
            var data = result;
            var res = [];
            for(var i = 0;i<data.length;i++){
                var indata = data[i];
                if(indata.id == id){
                    res.push(indata);
                    break;
                }
            }
            return res[0];
        }

        function selectedLogic(input,result) {
            var items = [];
            var box = input;
            var counter = 0;
            box.each(function () {
                if ($(this).is(':checked')) {
                    items.push(searchById($(this).val(),result));
                    counter++;
                }
            });
            var data = new Array();
            data['items'] = items;
            data['total'] = counter;
            return data;
        }

        function sorting(index,sort,keyname,num,selector) {
            var selectedKeyname = '';
            if(!_.isNull(selector) && !_.isUndefined(selector)){
                for (var i = 0; i < selector.length; i++) {
                    var inside_value = selector.options[i].value;
                    if(inside_value == keyname){
                        selectedKeyname = keyname;
                        break;
                    }
                }
            }

            if(keyname == ''){
                index = 1;

            }else if(keyname != sort){
                index *= -1;
            }

            var itemClass = $("th:eq("+num+")").children().attr("class");
            var classtoAdd = itemClass == 'fa fa-caret-down iconOrder' ? 'fa fa-caret-up iconOrder':'fa fa-caret-down iconOrder';

            var data = new Array();
            data['itemClass'] = itemClass;
            data['classtoAdd'] = classtoAdd;
            data['index'] = index;
            data['key'] = selectedKeyname;
            return data;
        }

        function init($scope,module,name){
            $scope.aditionalOptions = 0;//flag para mostrar/esconder opciones
            $scope.page = 1;//Inicio de pagina
            $scope.criteriaSelected = '';//Criterio de busqueda
            $scope.text = '';//Texto a buscar
            $scope.sortIndex = 1;//sorting
            $scope.allData = '';
            $scope.showgrid = 1;//Flag que ayuda a ocultar o mostrar la grilla y buscador
            $scope.selectedModule = module;
            $scope.module = name;
        }

        function sortDeleteid(obj,index){
            var data = [];
            var id = '';
            for(var i=0;i<obj.length;i++){
                if(_.isEmpty(index)){
                    id =  obj[i].id;
                    data.push(id);
                }else{
                    switch(index){
                        case 'slug':
                            id =  obj[i].slug;
                            data.push(id);
                            break;
                        case 'sale':
                            id = obj[i].sale;
                            data.push(id);
                            break;
                        case 'sale_id':
                            id = obj[i].sale_id;
                            data.push(id);
                            break;
                        case 'none':
                            data.push(obj[i]);
                            break;
                    }
                }
            }
            return data;
        }

    }



})();