(function () {
    'use strict';

    angular.module('sys.utils.widgets')
        .directive('ngFileSelect', ngFileSelect)

    ngFileSelect.$inject = ['fileReader', '$timeout', 'HelperFactory'];

    function ngFileSelect(fileReader, $timeout, HelperFactory) {
        return {
            scope: {
                ngModel: '='
            },
            link: function($scope, el) {
                function getFile(file) {
                    fileReader.readAsDataUrl(file, $scope)
                        .then(function(result) {
                            $timeout(function() {
                                $scope.ngModel = result;
                            });
                        });
                }

                function formatBytes(bytes) {
                    if (bytes === 0) return '0 Bytes';
                    var decimals = 2
                    var k = 1024;
                    var dm = decimals < 0 ? 0 : decimals;
                    var sizes = ['Bytes', 'KB', 'MB', 'GB'];

                    var i = Math.floor(Math.log(bytes) / Math.log(k));

                    var response = {
                        'size': parseFloat((bytes / Math.pow(k, i)).toFixed(dm)),
                        'code':sizes[i]
                    };

                    return response;
                }

                el.bind("change", function(e) {
                    var file = (e.srcElement || e.target).files[0];
                    var nameFile = file['name'];
                    var sizeFile = file['size'];

                    var extension = nameFile.split('.').pop().toUpperCase();
                    if (extension!="PNG" && extension!="JPG" && extension!="GIF" && extension!="JPEG"){
                        HelperFactory.show_AlertFactory('El arhivo seleccionado debe ser una imágen.');
                    }
                    else {
                        var formByte = formatBytes(sizeFile);

                        if(formByte['size']> 4 && formByte['code']=='MB'){
                            HelperFactory.show_AlertFactory('La imágen debe tener un tamaño máximo de 4 MB');
                        }
                        else if(formByte['code']=='GB'){
                            HelperFactory.show_AlertFactory('La imágen debe tener un tamaño máximo de 4 MB');
                        }
                        else{
                            angular.element(document.querySelector("#label_url_image")).html('<span>'+nameFile+'</span>');
                            getFile(file);
                        }
                    }

                });

            }
        };
    };



})();

