(function () {
    'use strict';

    angular.module('sys.utils.widgets')
        .factory('Printer', Printer);

    Printer.$inject = ['$rootScope', '$compile', '$http', '$timeout', '$q', 'EventsFactory'];

    function Printer($rootScope, $compile, $http, $timeout, $q, EventsFactory) {
        var printHtml = function (html) {
            var deferred = $q.defer();
            var hiddenFrame = $('<iframe style="display: block"></iframe>').appendTo('body')[0];
            hiddenFrame.contentWindow.printAndRemove = function () {
                hiddenFrame.contentWindow.print();

                //trigger close windows print
                EventsFactory.pushBroadcast('onCloseWindowPrint');
                $(hiddenFrame).remove();
            };
            var htmlContent = "<!doctype html>" +
                "<html>" +
                '<body onload="printAndRemove();">' +
                html +
                '</body>' +
                "</html>";
            var doc = hiddenFrame.contentWindow.document.open("text/html", "replace");
            doc.write(htmlContent);

            deferred.resolve();
            doc.close();
            return deferred.promise;
        };

        var openNewWindow = function (html) {
            var newWindow = window.open("printTest.html");
            newWindow.addEventListener('load', function () {
                $(newWindow.document.body).html(html);
            }, false);
        };

        var print = function (templateUrl, data) {
            $http.get(templateUrl).success(function (template) {
                var printScope = $rootScope.$new();
                angular.extend(printScope, data);
                var element = $compile($('<div>' + template + '</div>'))(printScope);
                var waitForRenderAndPrint = function () {
                    if (printScope.$$phase || $http.pendingRequests.length) {
                        $timeout(waitForRenderAndPrint);
                    } else {
                        // Replace printHtml with openNewWindow for debugging
                        printHtml(element.html());
                        printScope.$destroy();
                    }
                };
                waitForRenderAndPrint();
            });
        };

        var printFromScope = function (templateUrl, scope, callback) {
            $rootScope.isBeingPrinted = true;
            $http.get(templateUrl).success(function (template) {
                var printScope = scope;
                var element = $compile($('<div>' + template + '</div>'))(printScope);

                var waitForRenderAndPrint = function () {
                    if (printScope.$$phase || $http.pendingRequests.length) {
                        $timeout(waitForRenderAndPrint);
                    } else {
                        printHtml(element.html()).then(function () {
                            $rootScope.isBeingPrinted = false;
                            if (_.isFunction(callback)) {
                                setTimeout(function() {
                                    callback();
                                }, 500);
                            }
                        });
                    }
                };
                waitForRenderAndPrint();
            });
        };

        var printPdfBase64 = function (pdf_base64) {

            function dataURItoBlob(dataURI) {
                var byteString;
                if (dataURI.split(',')[0].indexOf('base64') >= 0)
                    byteString = atob(dataURI.split(',')[1]);
                else
                    byteString = unescape(dataURI.split(',')[1]);

                // separate out the mime component
                var mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0];

                // write the bytes of the string to a typed array
                var ia = new Uint8Array(byteString.length);
                for (var i = 0; i < byteString.length; i++) {
                    ia[i] = byteString.charCodeAt(i);
                }
                return new Blob([ia], {type: mimeString});
            }

            // console.log(pdf_base64);
            var data_document = "data:application/pdf;base64," + pdf_base64;
            var preBlob = dataURItoBlob(data_document);
            var pdfFile = new Blob([preBlob], {type: 'application/pdf'});
            var pdfUrl = URL.createObjectURL(pdfFile);
            const iframe = document.createElement('iframe');
            iframe.style.display = 'none';
            iframe.src = pdfUrl;
            document.body.appendChild(iframe);
            iframe.contentWindow.print();
        };

        return {
            print: print,
            printFromScope: printFromScope,
            printPdfBase64: printPdfBase64
        }
    }

})();