<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 26/06/2020
 * Time: 11:01 PM
 */

namespace App\Core;

use Illuminate\Database\Eloquent\Model;


class ModelsCore extends Model
{

    public static function all($columns = ['*'])
    {
//        return (new static)->newQuery()->get(
//            is_array($columns) ? $columns : func_get_args()
//        );

        $columns = is_array($columns) ? $columns : func_get_args();

        $instance = new static;

        return $instance->newQuery()->where('deleted_at', null)->get($columns);
    }

    public function delete()
    {
        if (is_null($this->getKeyName())) {
            throw new Exception('No primary key defined on model.');
        }

        // If the model doesn't exist, there is nothing to delete so we'll just return
        // immediately and not do anything else. Otherwise, we will continue with a
        // deletion process on the model, firing the proper events, and so forth.
        if (! $this->exists) {
            return;
        }

        if ($this->fireModelEvent('deleting') === false) {
            return false;
        }

        // Here, we'll touch the owning models, verifying these timestamps get updated
        // for the models. This will allow any caching to get broken on the parents
        // by the timestamp. Then we will go ahead and delete the model instance.
        $this->touchOwners();

        // ESTA FUNCION BORRA EL REGISTRO DE LA BASE DE DATOS
        //            $this->performDeleteOnModel();

        // SE HA CAMBIADO PARA LLENAR EL CAMPO DE DELETED_AT
        $time = $this->freshTimestamp();
        $this->deleted_at = $time;
        $this->save();

        $this->exists = false;

        // Once the model has been deleted, we will fire off the deleted event so that
        // the developers may hook into post-delete operations. We will then return
        // a boolean true as the delete is presumably successful on the database.
        $this->fireModelEvent('deleted', false);

        return true;
    }


}