<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 23/07/2020
 * Time: 12:39 AM
 */

namespace App\Core;


use App\Helper\HelperChecker;
use App\Helper\UtilHelper;
use App\Models\Tenant\Billing\NoteDocument\NoteDocumentRepository;
use App\Models\Tenant\Billing\NoteDocumentDetail\NoteDocumentDetailRepository;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Config\BillingCode\BillingCodeRepository;
use App\Models\Tenant\Config\TypeVoucher\TypeVoucherRepository;
use App\Models\Tenant\Config\UnitMeasure\UnitMeasureRepository;
use App\Models\Tenant\Money\DischargeDocument\DischargeDocument;
use App\Models\Tenant\Money\Movement\MovementRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\SaleDetail\SaleDetailRepository;
use App\Models\Tenant\Sale\ScheduleSale\ScheduleSaleRepository;
use App\Models\Tenant\Sale\ScheduleSaleDetail\ScheduleSaleDetailRepository;
use App\Models\Tenant\Ubigeo\UbigeoDetail\UbigeoDetailRepository;
use Illuminate\Support\Facades\Storage;

class SendBillingDocument
{

    protected $tenant;
    protected $rSaleDetail;
    protected $rUnitMeasure;
    protected $rProduct;
    protected $rTypeVoucher;
    protected $rClient;
    protected $rMoneyMovement;
    protected $helperChecker;
    protected $rUbigeoDetail;
    protected $rNoteDocument;
    protected $rNoteDocumentDetail;
    protected $rBillingCode;
    protected $utilHelper;
    protected $rScheduleSale;
    protected $rScheduleSaleDetail;


    public function __construct()
    {
        $this->tenant = new TenantCore();
        $this->rSaleDetail = new SaleDetailRepository();
        $this->rUnitMeasure = new UnitMeasureRepository();
        $this->rProduct = new ProductRepository();
        $this->rTypeVoucher = new TypeVoucherRepository();
        $this->rClient = new ClientRepository();
        $this->helperChecker = new HelperChecker();
        $this->rMoneyMovement = new MovementRepository();
        $this->rUbigeoDetail = new UbigeoDetailRepository();
        $this->rNoteDocument = new NoteDocumentRepository();
        $this->rNoteDocumentDetail = new NoteDocumentDetailRepository();
        $this->rBillingCode = new BillingCodeRepository();
        $this->utilHelper = new UtilHelper();
        $this->rScheduleSale = new ScheduleSaleRepository();
        $this->rScheduleSaleDetail = new ScheduleSaleDetailRepository();
    }

    public function validateClient($client, $voucher, $amount)
    {

        if ($voucher['id'] == config('app.voucher_factura_id')) {
            if ($client['typedocument_id'] != config('app.typedocument_ruc')) {
                throw new \ErrorException('Para la emisión de Facturas Electrónicas, el tipo de documento del cliente debe ser RUC.');
            }
            $this->helperChecker->checkDocumentLengthByTypeDocument($client['document'], $client['typedocument_id']);
        }

        if ($voucher['id'] == config('app.voucher_boleta_id')) {
            if ($amount > config('app.max_monto_boleta_sin_dni')) {
                if ($client['id'] == config('app.client_default')) {
                    throw new \ErrorException('Para ventas superiores a S/'.config("app.max_monto_boleta_sin_dni").' no se puede asignar al CLIENTE VARIOS');
                } else {
                    if ($client['document'] === null) {
                        throw new \ErrorException('Para ventas superiores a S/700.00 es requerido el número de documento del cliente.');
                    }
                    $this->helperChecker->checkDocumentLengthByTypeDocument($client['document'], $client['typedocument_id']);
                }
            }
        }

        return true;
    }

    public function cancelledDocument($movement)
    {
        $company = $this->tenant->company();
        $api = $company['api_facturador'];
        $url = $api . "/api/summaries";

        $contenido = array(
            "fecha_de_emision_de_documentos" => date('Y-m-d', strtotime($movement['date_movement'])),
            "codigo_tipo_proceso" => "3",
            "documentos" => array([
                "external_id" => $movement['billing_external_id'],
                "motivo_anulacion" => $movement['motive_cancelled']
            ])
        );

        if ($movement['voucher_id'] == config('app.voucher_factura_id')) {
            $url = $api . "/api/voided";
            unset($contenido);
            $contenido = array(
                "fecha_de_emision_de_documentos" => date('Y-m-d', strtotime($movement['date_movement'])),
                "documentos" => array([
                    "external_id" => $movement['billing_external_id'],
                    "motivo_anulacion" => $movement['motive_cancelled']
                ])
            );
        }

        $correlative_discharge = $this->getCorrelativeDischargeDocument();

        $txt_nombre = $company['ruc'] . '-RA-' . date('Ymd') . '-' . $movement['serie'] . '-' . $correlative_discharge['correlative'] . '.json';

        $contenido = json_encode($contenido, JSON_UNESCAPED_UNICODE);

        // save document
        Storage::disk('tenancy')->put($this->tenant->database() . '/discharge/' . $txt_nombre, []);
        $txt = Storage::disk('tenancy')->path($this->tenant->database() . '/discharge/' . $txt_nombre);

        $fichero = fopen($txt, 'w');
        fwrite($fichero, $contenido . PHP_EOL);
        fclose($fichero);


        $method = "POST";
        $result = $this->callApiCancelled($method, $contenido, $url);

        // dd($result);

        if (!$result) {
            if ($movement['billing_external_id'] != null) {
                unlink($txt);
                throw new \ErrorException('El comprobante ya ha sido enviado a Sunat, para poder anular debe verificar su conexión a internet, caso contrario contacte con su administrador.');
            }
        } else {
            $data_api = json_decode($result, true);
            if ($data_api['success'] == true) {
                $movement->billing_cancelled = $data_api;
            } else {
                throw new \ErrorException($data_api['message']);
            }

        }

        $movement->dischargedocument_id = $correlative_discharge['id'];
        $movement->save();

        return true;
    }

    public function facturaExonerada($sale, $movement, $module_billing = false)
    {

        $company = $this->tenant->company();
        $detail = $this->rSaleDetail->findBySale($sale['id']);
        $voucher = $this->rTypeVoucher->find($movement['voucher_id']);

        // data client
        $client = $this->rClient->find($movement['client_id']);

        $this->validateClient($client, $voucher, $movement['amount']);

        // get ubigeo data
        $ubigeo = "220901";
        $ubigeo_detail = $this->rUbigeoDetail->findUbigeoClient($client->id);
        if ($ubigeo_detail != null) {
            $ubigeo = $ubigeo_detail['district_id'];
        }
        // =============


        // LEYENDAS IN FOOTER JSON
        $code_leyenda = config('app.code_leyenda_bienes_exonerado');
        $txt_leyenda = config('app.txt_leyenda_bienes_exonerado');

        $val_igv = 18;

        // FORMATO POR TIPO DE FACTURA : EXONERADA Y GRAVADA
        $detail_structure = array();

        $is_exonerada = false;

        if ($company->typebilling_id == config('app.billing_gravada')) {
            $is_exonerada = true;
        }


        // config store hostignet bellavista =============
        $branchoofice_id = $this->utilHelper->getBranchOffice();
        $database = $this->tenant->database();

        if($database == config("app.database_hostingnet")){
            if($branchoofice_id == 2){
                $is_exonerada = true;
            }
        }
        // ==============================

        if ($is_exonerada==true) {
            foreach ($detail as $k => $item) {

                $product = $this->rProduct->find($item['product_id']);
                $unit = $this->rUnitMeasure->find($item['unitmeasure_id']);
                $subtotal = ($item['price'] * $item['quantity']);
                $total_base_igv = ($item['price'] * $item['quantity']);

                $precio_unitario = $item['price'] + (($item['price'] * $val_igv)/100);

                if($item['is_igv'] == false){
                    $precio_unitario = $item['price'];
                    $item['igv'] = (($item['price'] * $item['quantity']) * $val_igv)/100;
                    $total_base_igv = $total_base_igv - $item['igv'];
                }

                // DETALLE NUEVA VERSION
                $data = array(
                    "codigo_interno" => $product['code'],
                    "descripcion" => $product['description'],
                    "codigo_producto_sunat" => "",
                    "unidad_de_medida" => $unit['code'],
                    "cantidad" => $item['quantity'],
                    "valor_unitario" => number_format($item['price'], 2, '.', ''),
                    "codigo_tipo_precio" => "01",
//                    "precio_unitario" => number_format($item['price'], 2, '.', ''),
                    "precio_unitario" => number_format($precio_unitario, 2, '.', ''),
                    "codigo_tipo_afectacion_igv" => "10",
                    "total_base_igv" => number_format($total_base_igv, 2, '.', ''),
                    "porcentaje_igv" => 18,
                    "total_igv" => number_format($item['igv'], 2, '.', ''),
                    "total_impuestos" => number_format($item['igv'], 2, '.', ''),
                    "total_valor_item" => number_format($total_base_igv, 2, '.', ''),
                    "total_item" => number_format($total_base_igv + $item['igv'], 2, '.', ''),
                );

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                array_push($detail_structure, $data);
            }

            $fecha_vencimiento = date('Y-m-d');
            if($sale['typetransaction_id'] == config('app.transaction_credit')){
                $schedule = $this->rScheduleSale->findBySale($sale['id']);
                $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule->id);
                $fecha_vencimiento = $schedule_detail->last()->date_assigned;
            }

            $contenido = array(
                "serie_documento" => $movement['serie'],
                "numero_documento" => $movement['correlative'],
                "fecha_de_emision" => date('Y-m-d', strtotime($movement['date_movement'])),
                "hora_de_emision" => date('H:i:s', strtotime($movement['date_movement'])),
                "codigo_tipo_operacion" => "0101",
                "codigo_tipo_documento" => $voucher['sunat_id'],
                "codigo_tipo_moneda" => "PEN",
                "fecha_de_vencimiento" => $fecha_vencimiento,
                "numero_orden_de_compra" => "",
                "datos_del_cliente_o_receptor" => ([
                    "codigo_tipo_documento_identidad" => $client['typeDocumentCode'],
                    "numero_documento" => $client['document'],
                    "apellidos_y_nombres_o_razon_social" => $client['fullname'],
                    "codigo_pais" => "PE",
                    "ubigeo" => $ubigeo,
                    "direccion" => ($client['address'] == null || $client['address'] == '') ? '-' : $client['address'],
                    "correo_electronico" => $client['email'],
                    "telefono" => $client['cellphone']
                ]),
                "totales" => ([
                    "total_exportacion" => '0.00',
                    "total_operaciones_gravadas" => $sale['subtotal'],
                    "total_operaciones_inafectas" => '0.00',
                    "total_operaciones_exoneradas" => '0.00',
                    "total_operaciones_gratuitas" => "0.00",
                    "total_igv" => $sale['igv'],
                    "total_impuestos" => $sale['igv'],
                    "total_valor" => $sale['subtotal'],
                    "total_venta" => $sale['total']
                ]),
                "items" => ($detail_structure),
                "leyendas" => array([
                    "codigo" => $code_leyenda,
                    "valor" => $txt_leyenda
                ])

            );
        }
        else {
            foreach ($detail as $k => $item) {

                $product = $this->rProduct->find($item['product_id']);
                $unit = $this->rUnitMeasure->find($item['unitmeasure_id']);

//            $subtotal = (($item['price'] * $item['quantity']) + $item['discount'] + $item['igv']);
                $subtotal = ($item['price'] * $item['quantity']);

                // DETALLE NUEVA VERSION
                $data = array(
                    "codigo_interno" => $product['code'],
                    "descripcion" => $product['description'],
                    "codigo_producto_sunat" => "",
                    "unidad_de_medida" => $unit['code'],
//                "unidad_de_medida" => $unit['prefix'],
                    "cantidad" => $item['quantity'],
                    "valor_unitario" => number_format($item['price'], 2, '.', ''),
                    "codigo_tipo_precio" => "01",
                    "precio_unitario" => number_format($item['price'], 2, '.', ''),
                    "codigo_tipo_afectacion_igv" => "20",
                    "total_base_igv" => number_format($subtotal, 2, '.', ''),
//                    "total_base_igv" => "0.00",
                    "porcentaje_igv" => 18,
                    "total_igv" => "0.00",
                    "total_impuestos" => "0.00",
                    "total_valor_item" => number_format($subtotal, 2, '.', ''),
                    "total_item" => number_format($subtotal, 2, '.', ''),
                );

                if ($product['type_product'] == config('app.typeproduct_servicios')) {
                    $code_leyenda = config('app.code_leyenda_servicios_exonerado');
                    $txt_leyenda = config('app.txt_leyenda_servicios_exonerado');
                }

                array_push($detail_structure, $data);
            }
            $contenido = array(
                "serie_documento" => $movement['serie'],
                "numero_documento" => $movement['correlative'],
                "fecha_de_emision" => date('Y-m-d', strtotime($movement['date_movement'])),
                "hora_de_emision" => date('H:i:s', strtotime($movement['date_movement'])),
                "codigo_tipo_operacion" => "0101",
                "codigo_tipo_documento" => $voucher['sunat_id'],
                "codigo_tipo_moneda" => "PEN",
                "fecha_de_vencimiento" => date('Y-m-d'),
                "numero_orden_de_compra" => "",
                "datos_del_cliente_o_receptor" => ([
                    "codigo_tipo_documento_identidad" => $client['typeDocumentCode'],
                    "numero_documento" => $client['document'],
                    "apellidos_y_nombres_o_razon_social" => $client['fullname'],
                    "codigo_pais" => "PE",
                    "ubigeo" => $ubigeo,
                    "direccion" => ($client['address'] == null || $client['address'] == '') ? '-' : $client['address'],
                    "correo_electronico" => $client['email'],
                    "telefono" => $client['cellphone']
                ]),
                "totales" => ([
                    "total_exportacion" => '0.00',
                    "total_operaciones_gravadas" => '0.00',
                    "total_operaciones_inafectas" => '0.00',
                    "total_operaciones_exoneradas" => $movement['amount'],
                    "total_operaciones_gratuitas" => "0.00",
                    "total_igv" => "0.00",
                    "total_impuestos" => "0.00",
                    "total_valor" => $movement['amount'],
                    "total_venta" => $movement['amount']
                ]),
                "items" => ($detail_structure),
                "leyendas" => array([
                    "codigo" => $code_leyenda,
                    "valor" => $txt_leyenda
                ])

            );
        }

        if($sale['typetransaction_id'] == config('app.transaction_cash')){
            $contenido['codigo_condicion_de_pago'] = "01";
        }
        else{
            $contenido['codigo_condicion_de_pago'] = "02";

            $schedule = $this->rScheduleSale->findBySale($sale['id']);
            $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule->id);

            $arr_schedule = array();

            foreach ($schedule_detail as $detail) {
                array_push($arr_schedule, array(
                    "fecha" => $detail['date_assigned'],
                    "codigo_tipo_moneda" => "PEN",
                    "monto" =>$detail['amount_assigned']
                ));
            }

            $contenido['cuotas'] = $arr_schedule;
        }

        $txt_nombre = $company['ruc'] . '-' . $voucher['sunat_id'] . '-' . $movement['serie'] . '-' . $movement['correlative'] . '.json';

        $contenido = json_encode($contenido, JSON_UNESCAPED_UNICODE);

        // save document
        Storage::disk('tenancy')->put($this->tenant->database() . '/documents/' . $txt_nombre, []);
        $txt = Storage::disk('tenancy')->path($this->tenant->database() . '/documents/' . $txt_nombre);

        $fichero = fopen($txt, 'w');
        fwrite($fichero, $contenido . PHP_EOL);
        fclose($fichero);

        $method = "POST";
        $result = $this->callApiFacturador($method, $contenido);

        $arr_response = array(
            'json_file' => $txt_nombre,
        );

        if (!$result) {
            $arr_response['code'] = 'pending';
            $arr_response['message'] = 'El comprobante queda pendiente de envío a la SUNAT';

            if ($module_billing) {
                throw new \ErrorException('Por favor !!, verifique su conexión a internet, caso contrario contacte con su administrador.');
            }

        } else {
            $data_api = json_decode($result, true);
            if ($data_api['success'] == true) {
                $check_movement = $this->updateMovementAfterBilling($data_api, $movement['id']);
                $arr_response['code'] = 'success';
                $arr_response['message'] = 'El comprobante electrónico ha sido enviado satisfactoriamente a Sunat!!';

                if ($check_movement['date_repayment'] != null) {
                    $this->cancelledDocument($check_movement);
                }
            } else {
                throw new \ErrorException($data_api['message']);
            }
        }

        return $arr_response;
    }

    public function updateMovementAfterBilling($data, $movement_id)
    {
        $movement = $this->rMoneyMovement->find($movement_id);
        $movement->billing_external_id = $data['data']['external_id'];
        $movement->billing_response = json_encode($data);
        $movement->billing_hash = $data['data']['hash'];
        $movement->save();
//        Movement::where('id', $movement_id)->update(['billing_external_id' => '' . $data['data']['external_id'] . '', 'billing_response' => '' . json_encode($data) . '', 'billing_hash' => $data['data']['hash']]);
        return $movement;
    }

    public function callApiFacturador($method, $data)
    {

        $company = $this->tenant->company();
        $url = $company['api_facturador'] . '/api/documents';
        $api_token = $company['api_token'];

        $curl = curl_init();

        switch ($method) {
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            default:
                if ($data)
                    $url = sprintf("%s?%s", $url, http_build_query($data));
        }


        // OPTIONS:
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer ' . $api_token,
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        // EXECUTE:

        $result = curl_exec($curl);

        if (!$result) {
            return false;
        }
        curl_close($curl);
        return $result;
    }

    public function getCorrelativeDischargeDocument()
    {
        $comunicacion_baja = new DischargeDocument();
        $correlativo = DischargeDocument::where('date_discharge', date('Y-m-d'))->orderBy('id', 'DESC')->first();

        if (!$correlativo) {
            $correlativo = ((int)1);
        } else {
            $correlativo = ((int)$correlativo->correlative + 1);
        }

        $comunicacion_baja->date_discharge = date('Y-m-d');
        $comunicacion_baja->correlative = $correlativo;
        $comunicacion_baja->save();
        return $comunicacion_baja;
    }

    public function callApiCancelled($method, $data, $url)
    {
        $company = $this->tenant->company();
        $api_token = $company['api_token'];
        $curl = curl_init();

        switch ($method){
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            default:
                if ($data)
                    $url = sprintf("%s?%s", $url, http_build_query($data));
        }

        // OPTIONS:
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer '.$api_token,
            'Content-Type: application/json',
        ));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        // EXECUTE:

        $result = curl_exec($curl);

        if(!$result){
            return false;
        }
        curl_close($curl);
        return $result;
    }



    // NOTE DOCUMENT : CREDIT NOTE

    public function sendCreditNote($note, $module_billing = false)
    {
        // $sale  => $note : data credit note _ table billing_notedocuments
        $company = $this->tenant->company();
        $detail = $this->rNoteDocumentDetail->findByNote($note['id']);
        $voucher = $this->rTypeVoucher->find($note['voucher_id']);
        $type_note = $this->rBillingCode->find($note['billingcode_id']);
        $document_movement = $this->rMoneyMovement->find($note['movement_id']);

        // data client
        $client = $this->rClient->find($note['client_id']);

        $this->validateClient($client, $voucher, $note['total']);

        // get ubigeo data
        $ubigeo = "220901";
        $ubigeo_detail = $this->rUbigeoDetail->findUbigeoClient($client->id);
        if ($ubigeo_detail != null) {
            $ubigeo = $ubigeo_detail['district_id'];
        }
        // =============

        $val_igv = 18;

        // FORMATO POR TIPO DE FACTURA : EXONERADA Y GRAVADA
        $detail_structure = array();

        if ($company->typebilling_id == config('app.billing_gravada')) {
            throw new \ErrorException("Estamos trabajando , contacte con su administrador");
        }
        else {
            foreach ($detail as $k => $item) {
                $product = $this->rProduct->find($item['product_id']);
                $unit = $this->rUnitMeasure->find($item['unitmeasure_id']);
                $subtotal = ($item['price'] * $item['quantity']);

                // DETALLE NUEVA VERSION
                $data = array(
                    "codigo_interno" => $product['code'],
                    "descripcion" => $product['description'],
                    "codigo_producto_sunat" => "",
                    "unidad_de_medida" => $unit['code'],
                    "cantidad" => $item['quantity'],
                    "valor_unitario" => number_format($item['price'], 2, '.', ''),
                    "codigo_tipo_precio" => "01",
                    "precio_unitario" => number_format($item['price'], 2, '.', ''),
                    "codigo_tipo_afectacion_igv" => "20",
                    "total_base_igv" => number_format($subtotal, 2, '.', ''),
                    "porcentaje_igv" => 18,
                    "total_igv" => "0.00",
                    "total_impuestos" => "0.00",
                    "total_valor_item" => number_format($subtotal, 2, '.', ''),
                    "total_item" => number_format($subtotal, 2, '.', ''),
                );

                array_push($detail_structure, $data);
            }
            $contenido = array(
                "serie_documento" => $note['serie'],
                "numero_documento" => $note['correlative'],
                "fecha_de_emision" => date('Y-m-d', strtotime($note['date_document'])),
                "hora_de_emision" => date('H:i:s', strtotime($note['date_document'])),
                "codigo_tipo_documento" => $voucher['sunat_id'],
                "codigo_tipo_nota" => $type_note['sunat_code'],
                "motivo_o_sustento_de_nota"=> $note['motive'],
                "codigo_tipo_moneda" => "PEN",
                "numero_orden_de_compra" => "",
                "documento_afectado" => ([
                    "external_id" => $document_movement['billing_external_id'],
                ]),
                "datos_del_cliente_o_receptor" => ([
                    "codigo_tipo_documento_identidad" => $client['typeDocumentCode'],
                    "numero_documento" => $client['document'],
                    "apellidos_y_nombres_o_razon_social" => $client['fullname'],
                    "codigo_pais" => "PE",
                    "ubigeo" => $ubigeo,
                    "direccion" => ($client['address'] == null || $client['address'] == '') ? '-' : $client['address'],
                    "correo_electronico" => $client['email'],
                    "telefono" => $client['cellphone']
                ]),
                "totales" => ([
                    "total_exportacion" => '0.00',
                    "total_operaciones_gravadas" => '0.00',
                    "total_operaciones_inafectas" => '0.00',
                    "total_operaciones_exoneradas" => $note['total'],
                    "total_operaciones_gratuitas" => "0.00",
                    "total_igv" => "0.00",
                    "total_impuestos" => "0.00",
                    "total_valor" => $note['total'],
                    "total_venta" => $note['total']
                ]),
                "items" => ($detail_structure)
            );
        }

        $txt_nombre = $company['ruc'] . '-' . $voucher['sunat_id'] . '-' . $note['serie'] . '-' . $note['correlative'] . '.json';

        $contenido = json_encode($contenido, JSON_UNESCAPED_UNICODE);

        // save document
        Storage::disk('tenancy')->put($this->tenant->database() . '/documents/' . $txt_nombre, []);
        $txt = Storage::disk('tenancy')->path($this->tenant->database() . '/documents/' . $txt_nombre);

        $fichero = fopen($txt, 'w');
        fwrite($fichero, $contenido . PHP_EOL);
        fclose($fichero);

        $method = "POST";
        $result = $this->callApiFacturador($method, $contenido);

        $arr_response = array(
            'json_file' => $txt_nombre,
        );

        if (!$result) {
            $arr_response['code'] = 'pending';
            $arr_response['message'] = 'El comprobante queda pendiente de envío a la SUNAT';

            if ($module_billing) {
                throw new \ErrorException('Por favor !!, verifique su conexión a internet, caso contrario contacte con su administrador.');
            }

        } else {
            $data_api = json_decode($result, true);
            if ($data_api['success'] == true) {
                $check_movement = $this->updateNoteDocumentAfterSend($data_api, $note['id'], $document_movement);
                $arr_response['code'] = 'success';
                $arr_response['message'] = 'El comprobante electrónico ha sido enviado satisfactoriamente a Sunat!!';
            } else {
                throw new \ErrorException($data_api['message']);
            }
        }

        return $arr_response;
    }

    public function updateNoteDocumentAfterSend($data, $note_id, $document_movement)
    {
        $note = $this->rNoteDocument->find($note_id);
        $note->billing_external_id = $data['data']['external_id'];
        $note->billing_response = json_encode($data);
        $note->billing_hash = $data['data']['hash'];
        $note->save();

        // update movement after generate note document
        $document_movement->is_note_document = true;
        $document_movement->notedocument_id = $note_id;
        $document_movement->save();

        return $note;
    }

}
