<?php

namespace App\Core\Services\Api;

use GuzzleHttp\Client;

class ServiceData
{
    public static function service($type, $number)
    {

        if($type=='dni'){
            if (strlen($number) !== 8) {
                return [
                    'success' => false,
                    'message' => 'DNI debe tener 8 digitos.'
                ];
            }
        }

        if($type=='ruc'){
            if (strlen($number) !== 11) {
                return [
                    'success' => false,
                    'message' => 'RUC debe tener 11 digitos.'
                ];
            }
        }

        $client = new Client(['base_uri' => config('app.api_service_url')]);

        $parameters = [
            'http_errors' => false,
            'connect_timeout' => 5,
            'headers' => [
                'Authorization' => 'Bearer '.config('app.api_service_token'),
                'Accept' => 'application/json',
            ],
        ];

        $res = $client->request('GET', '/api/'.$type.'/'.$number, $parameters);
        $response = json_decode($res->getBody()->getContents(), true);

        return $response;
    }
}