<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 24/06/2020
 * Time: 01:02 AM
 */

namespace App\Core;


use App\Models\System\Company\CompanyRepository;

class TenantCore
{
    protected $core;
    protected $rCompany;

    public function __construct()
    {
        $this->core = app(\Hyn\Tenancy\Environment::class)->hostname();
        $this->rCompany = new CompanyRepository();
    }

    public function hostname()
    {
        return $this->core;
    }

    public function database()
    {
        return $this->core->website->uuid;
    }

    public function company()
    {
        $query = $this->rCompany->findByWebsite($this->core->website->id);
        return $query;
    }

    public function includeIgv()
    {
        $check_igv = false;
        $query = $this->rCompany->findByWebsite($this->core->website->id);
        if ($query->typebilling_id != config('app.billing_exonerada')) {
            $check_igv = true;
        }
        return $check_igv;
    }

}