<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 26/05/2020
 * Time: 12:54 AM
 */

namespace App\Helper;

use App\Models\Tenant\Catalog\Product\Product;
use App\Models\Tenant\Company\Employee\Employee;
use App\Models\Tenant\Management\User\UserTenant;
use App\Models\Tenant\Purchase\Provider\Provider;
use App\Models\Tenant\Sale\Client\Client;
use App\Models\Tenant\Inquiry\Response\Response;

class HelperChecker
{

    static function checkProductCode($code){
        $product = Product::where('code',$code)->get();
        if(count($product)>0){
            throw new \ErrorException('Ya existe un producto con el código ingresado ('.$code.')');
        }
        return true;
    }

    static function checkProductCodeUpdate($code, $product_id){

        $product = Product::where('code',$code)->where('id','<>', $product_id)->get();
        if(count($product)>0){
            throw new \ErrorException('El código del producto ya se encuentra registrado');
        }
        return true;
    }

    static function checkClientDocument($document){

        $client = Client::where('document',$document)->get();
        if(count($client)>0){
            throw new \ErrorException('El número de documento del cliente ya se encuentra registrado');
        }
        return true;
    }

    public function checkClientDocumentGuest($document)
    {

        $client = Client::where('document', $document)->get();
        if (count($client) > 0) {
           return (["check" => false, "data" => $client]);
    
        }
        return (["check" => true, "data" => false]);;
    }

    static function checkEployeeEmail($email){

        $employee = Employee::where('email', $email)->get();
        if(count($employee)>0){
            throw new \ErrorException('El correo electrónico ingresado ya se encuentra registrado.');
        }
        return true;
    }

    static function checkEmployeeDocument($document){

        $client = Employee::where('document',$document)->get();
        if(count($client)>0){
            throw new \ErrorException('El número de documento del empleado ya se encuentra registrado');
        }
        return true;
    }

    static function checkUserTenantEmail($email){

        $user = UserTenant::where('email', $email)->get();
        if(count($user)>0){
            throw new \ErrorException('El correo electrónico ingresado ya se encuentra registrado.');
        }
        return true;
    }

    static function checkProviderDocument($document){

        $provider = Provider::where('document',$document)->get();
        if(count($provider)>0){
            throw new \ErrorException('El número de documento del proveedor ya se encuentra registrado');
        }
        return true;
    }

    static function checkClientDocumentUpdate($document, $client_id){

        $client = Client::where('document',$document)->where('id','<>', $client_id)->get();
        if(count($client)>0){
            throw new \ErrorException('El número de documento del cliente ya se encuentra registrado');
        }
        return true;
    }

    static function checkEmployeeDocumentUpdate($document, $client_id){

        $client = Employee::where('document',$document)->where('id','<>', $client_id)->get();
        if(count($client)>0){
            throw new \ErrorException('El número de documento del empleado ya se encuentra registrado');
        }
        return true;
    }

    static function checkProviderDocumentUpdate($document, $provider_id){
        $provider = Provider::where('document',$document)->where('id','<>', $provider_id)->get();
        if(count($provider)>0){
            throw new \ErrorException('El número de documento del proveedor ya se encuentra registrado');
        }
        return true;
    }

    public function checkClientInSurveyResponse($response){

        $client = Response::where('client_id',$response['client_id'])->where('survey_id',$response['survey_id'])->get();
        if(count($client)>0){
            throw new \ErrorException('El cliente seleccionado ya registró el llenado de la encuesta', 500);
        }
        return true;
    }

    static function checkDocumentLengthByTypeDocument($document, $type){

        if(config('app.typedocument_dni')==$type){
            if (strlen($document) !== 8) {
                throw new \ErrorException('El DNI ingresado debe tener 8 digitos', 500);
            }

        }

        if(config('app.typedocument_ruc')==$type) {
            if (strlen($document) !== 11) {
                throw new \ErrorException('El RUC ingresado debe tener 11 digitos', 500);
            }
        }

        return true;
    }


    static function checkSeemDescriptionModel($model, $columncheck, $txt, $title = null){
        $item = $model->where($columncheck, $txt)->where('deleted_at',null)->first();
        if($item){
            $message = 'Ya existe un registro con la misma descripción ingresada';
            if($title != null) $message = 'Ya existe un registro de '.$title. ' con la misma descripción ingresada';
            throw new \ErrorException($message, 100);
        }
    }

    static function checkUpdateSeemDescriptionModel($item_id, $model, $columncheck, $txt, $title = null){
        $item = $model->where($columncheck, $txt)->where('id','<>', $item_id)->where('deleted_at',null)->first();
        if($item){
            $message = 'Ya existe un registro con la misma descripción ingresada';
            if($title != null) $message = 'Ya existe un registro de '.$title. ' con la misma descripción ingresada';
            throw new \ErrorException($message, 100);
        }
    }


    public function convertIdCeroToNull($val){
        if($val == 0 or $val == '0'){
            $val = null;
        }
        return $val;
    }

}