<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 26/05/2020
 * Time: 01:46 AM
 */

namespace App\Helper;


class SearchQueryStructure
{
    // GET SEARCH BY TABLE
    public function getSearchCampByTable($model, $search_text){

        $text_search = strtoupper($search_text);

        // PRODUCTS TABLE
        if($model->getTable() == 'catalog_products'){
            $structure = $model->where('deleted_at', null)->where('description', 'LIKE', '%' . $text_search . '%');
        }

        // CLIENTS TABLE
        else if($model->getTable() == 'sale_clients'){
            $structure = $model->where('deleted_at', null)
                ->where('id', '<>', config('app.client_default'))
                ->where('fullname', 'LIKE', '%' . $text_search . '%')
                ->orWhere('document',  'LIKE', '%' . $text_search . '%');
        }

        else if($model->getTable() == 'sale_orders'){
            $structure =$model->join('users', 'orders.user_id', '=', ' users.id')
                ->select('orders.*', 'users.name')
                ->where('deleted_at', null);
        }

        // PROVIDERS TABLE
        else if($model->getTable() == 'purchase_providers'){
            $structure = $model->where('deleted_at', null)
                ->where('id', '<>', config('app.client_default'))
                ->where('fullname', 'LIKE', '%' . $text_search . '%')
                ->orWhere('document',  'LIKE', '%' . $text_search . '%');
        }

        else{
            $structure = $model->where('description', 'LIKE', '%' . $text_search . '%')->where('deleted_at', null);
        }

        return $structure;

    }

}