<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 24/06/2020
 * Time: 01:07 AM
 */

namespace App\Helper;


use App\Core\TenantCore;
use Illuminate\Support\Facades\Storage;

class StorageHelper
{
    protected $tenant;

    public function __construct()
    {
        $this->tenant = new TenantCore();
    }

    public function saveUrlImgClient($data){

        $image = $data['url_image'];
        $document = $data['document'];

        $imageInfo = explode(";base64,", $image);
        $imgExt = str_replace('data:image/', '', $imageInfo[0]);
        $image = str_replace(' ', '+', $imageInfo[1]);

        $imageName = $document.".".$imgExt;

        Storage::disk('tenancy')->makeDirectory($this->tenant->database().'/clients/');
        $path =  Storage::disk('tenancy')->path($this->tenant->database().'/clients/');

        // save image format png
        $this->saveImagePng($path, $imageName, $image);
//        Storage::disk('tenancy')->put($this->tenant->database().'/clients/'.$imageName, base64_decode($image));
        return $imageName;
    }

    public function saveUrlImgCategoryFood($data){

        $image = $data['url_image'];
        $time = getdate();
        $document = $time[0];

        $imageInfo = explode(";base64,", $image);
        $imgExt = str_replace('data:image/', '', $imageInfo[0]);
        $image = str_replace(' ', '+', $imageInfo[1]);

        $imageName = $document.".".$imgExt;

        Storage::disk('tenancy')->makeDirectory($this->tenant->database().'/categoryfood/');
        $path =  Storage::disk('tenancy')->path($this->tenant->database().'/categoryfood/');

        // save image format png
        $this->saveImagePng($path, $imageName, $image);
        return $imageName;
    }

    public function getUrlImgCategoryFood($url_image){
        $path = Storage::disk('tenancy')->path($this->tenant->database().'/categoryfood/'.$url_image);
        $base64 = null;
        if(file_exists($path)){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data = file_get_contents($path);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        }
        return $base64;
    }

    public function getUrlImgClient($url_image){
        $path = Storage::disk('tenancy')->path($this->tenant->database().'/clients/'.$url_image);
        $base64 = null;
        if(file_exists($path)){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data = file_get_contents($path);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        }
        return $base64;
    }

    public function saveUrlImgProduct($data){

        $image = $data['url_image'];
        $document = $data['product_id'];

        $imageInfo = explode(";base64,", $image);
        $imgExt = str_replace('data:image/', '', $imageInfo[0]);
        $image = str_replace(' ', '+', $imageInfo[1]);

        $imageName = 'product-id'.$document.".".$imgExt;

        Storage::disk('tenancy')->makeDirectory($this->tenant->database().'/products/');
        $path =  Storage::disk('tenancy')->path($this->tenant->database().'/products/');

        // save image format png
        $this->saveImagePng($path, $imageName, $image);
//        Storage::disk('tenancy')->put($this->tenant->database().'/products/'.$imageName, base64_decode($image));
        return $imageName;
    }

    public function getUrlImgProduct($url_image){
        $path = Storage::disk('tenancy')->path($this->tenant->database().'/products/'.$url_image);
        $base64 = null;
        if(file_exists($path)){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data = file_get_contents($path);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        }
        return $base64;
    }

    public function saveUrlImgProvider($data){

        $image = $data['url_image'];
        $document = $data['document'];

        $imageInfo = explode(";base64,", $image);
        $imgExt = str_replace('data:image/', '', $imageInfo[0]);
        $image = str_replace(' ', '+', $imageInfo[1]);

        $imageName = $document.".".$imgExt;

        Storage::disk('tenancy')->makeDirectory($this->tenant->database().'/providers/');
        $path =  Storage::disk('tenancy')->path($this->tenant->database().'/providers/');
        // save image format png
        $this->saveImagePng($path, $imageName, $image);

//        Storage::disk('tenancy')->put($this->tenant->database().'/providers/'.$imageName, base64_decode($image));

        return $imageName;
    }

    public function getUrlImgProvider($url_image){
        $path = Storage::disk('tenancy')->path($this->tenant->database().'/providers/'.$url_image);
        $base64 = null;
        if(file_exists($path)){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data = file_get_contents($path);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        }
        return $base64;
    }

    public function saveUrlImgEmployee($data){

        $image = $data['url_image'];
        $document = $data['document'];

        $imageInfo = explode(";base64,", $image);
        $imgExt = str_replace('data:image/', '', $imageInfo[0]);
        $image = str_replace(' ', '+', $imageInfo[1]);

        $imageName = $document.".".$imgExt;

        Storage::disk('tenancy')->makeDirectory($this->tenant->database().'/empleados/');
        $path =  Storage::disk('tenancy')->path($this->tenant->database().'/empleados/');
        // save image format png
        $this->saveImagePng($path, $imageName, $image);

//        Storage::disk('tenancy')->put($this->tenant->database().'/providers/'.$imageName, base64_decode($image));

        return $imageName;
    }

    public function getUrlImgEmployee($url_image){
        $path = Storage::disk('tenancy')->path($this->tenant->database().'/empleados/'.$url_image);
        $base64 = null;
        if(file_exists($path)){
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data = file_get_contents($path);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        }
        return $base64;
    }


    function saveImagePng($path, $name_img, $base64_string){
        $im = base64_decode($base64_string);
        $filename = $path;
        $filename .= $name_img;

        $file = fopen($filename, "wb");
        $newIamge = $this->resize_image($im, 80, 80);
        fwrite($file, $newIamge);
        fclose($file);
        return $filename;
    }

    function resize_image($file, $w, $h, $crop=FALSE) {
        $src = imagecreatefromstring($file);
        if (!$src) return false;
        $width = imagesx($src);
        $height = imagesy($src);

        $r = $width / $height;
        if ($crop) {
            if ($width > $height) {
                $width = ceil($width-($width*abs($r-$w/$h)));
            } else {
                $height = ceil($height-($height*abs($r-$w/$h)));
            }
            $newwidth = $w;
            $newheight = $h;
        } else {
            if ($w/$h > $r) {
                $newwidth = $h*$r;
                $newheight = $h;
            } else {
                $newheight = $w/$r;
                $newwidth = $w;
            }
        }
        //$src = imagecreatefrompng($file);
        $dst = imagecreatetruecolor($newwidth, $newheight);
        imagecopyresampled($dst, $src, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

        // Buffering
        ob_start();
        imagepng($dst);
        $data = ob_get_contents();
        ob_end_clean();
        return $data;
    }
}