<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 23/05/2020
 * Time: 11:43 PM
 */

namespace App\Helper;

use App\Models\Tenant\Config\SerieVoucher\SerieVoucherRepository;
use App\Models\Tenant\Hotel\Booking\BookingRepository;
use App\Models\Tenant\Purchase\OrderPurchase\OrderPurchaseRepository;
use App\Models\Tenant\Purchase\Purchase\PurchaseRepository;
use App\Models\Tenant\Sale\Order\OrderRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use App\Models\Tenant\Warehouse\Movement\Movement;
use App\Models\Tenant\Warehouse\Movement\MovementRepository;
use App\Models\Tenant\Warehouse\WarehouseTransfer\WarehouseTransferRepository;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use function PHPSTORM_META\type;

class UtilHelper
{
    protected $searchQueryStructure;
    protected $serie;

    public function __construct()
    {
        $this->searchQueryStructure = new SearchQueryStructure();
        $this->serie = new SerieVoucherRepository();
    }

    public function paginate($model, $header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');

        $data = $model->where('deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();

        // COMPANY
        if($model->getTable() == 'company_employees'){
            $data = $model->where('deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();
        }

        // VENTAS
        if($model->getTable() == 'sale_clients'){
            $data = $model->where('id', '<>', config('app.client_default'))->where('deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();
        }

        // CATALOGO
        if($model->getTable() == 'catalog_lines'){
            $category = $header->has('category') ? $header->get('category') : null;
            if($category !== 'null'){
                $data = $model->where('category_id', $category)->where('deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();
            }
        }

        if($model->getTable() == 'catalog_products'){
            $typeProduct = $header->has('typeProduct') ? $header->get('typeProduct') : null;
            if($typeProduct !== 'null'){
                $data = $model->where('type_product', $typeProduct)->where('deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();
            }
        }

        // ALMACEN
        if($model->getTable() == 'warehouse_movements'){
            $type_movement = $header->has('type_movement') ? $header->get('type_movement') : 'E';
            if($type_movement !== 'null'){
                $data = $model->where('type_movement', $type_movement)->where('is_newproduct', false)->where('deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();
            }
        }


        $all_data = $model->all();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }
            if ($text_search !== null) {
//                $data = $model->where('description', 'LIKE', '%' . $text_search . '%')->where('deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();
                $structure_search = $this->searchQueryStructure->getSearchCampByTable($model, $text_search);
                $data = $structure_search->skip(($page - 1) * $limit)->take($limit)->orderBy('id', 'DESC')->get()->toArray();
                $all_data = $data;
            }
        }

//        $data = $model->where('deleted_at', null)->skip(($page - 1) * $limit)->take($limit)->orderBy('id','DESC')->get()->toArray();
//        $all_data = $model->all();

        $response = array(
            'results' => $data,
            'count' => count($data),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );
        return $response;

    }


    public function createCorrelative()
    {
        $res = $this->serie->findByVoucher(config('app.voucher_nota_pedido_id'));

        $correlativo = intval($res['correlative']) + 1;

        if ($correlativo >= $res['max_correlative']){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Debe agregar otra serie');
        }

//        $len_0 = strlen($res['max_correlative']) - strlen(strval($correlativo));
        $len_0 = strlen($res['max_correlative']);
        $codigo = $res["series"] .'-' . str_pad($correlativo, $len_0, "0", STR_PAD_LEFT);

        $this->serie->updatedCorrelative($res['id'], $correlativo);
        return $codigo;
    }

    public function getCorrelativeVoucher($voucher_id, $serie = null, $branchoffice_id)
    {
        $res = $this->serie->findByVoucherAndBranchOffice($voucher_id, $serie, $branchoffice_id);

        $correlativo = intval($res['correlative']) + 1;

        if ($correlativo >= $res['max_correlative']){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Debe agregar otra serie');
        }

        $len_0 = strlen($res['max_correlative']);
        $codigo = $res["series"] .'-' . str_pad($correlativo, $len_0, "0", STR_PAD_LEFT);

        $this->serie->updatedCorrelative($res['id'], $correlativo);

        $response = array(
            'nro_voucher'=>$codigo,
            'correlative'=>$correlativo,
            'serie'=>$res["series"]
        );

        return $response;
    }

    public function transformDatetime($date){
        $datetime = $date.' '.date('H:i:s');
        return $datetime;
    }

    public function concatDateAndTime($date, $time){
        $combinedDT = date('Y-m-d H:i:s', strtotime("$date $time"));
        return $combinedDT;
    }


    public function getCodeProduct($val, $type_product){
        $code = $val;
        if($val == null or $val == ''){
            $code = $this->createCodeProduct($type_product);
        }
        return $code;
    }

    public function createCodeProduct($type_product){
        $ext = 'PR';
        if ($type_product == config('app.typeproduct_servicios')){
            $ext = 'SR';
        }
        $time = getdate();
        $code = $ext.$time[0];
        return $code;
    }

    public function getBranchOffice(){
        if (!Session::has('branchoffice_id')) {
            session()->flash('msg', 'Por favor seleccione una sucursal para poder ingresar al control del sistema!!');
            return redirect()->route('tenant.company.branchoffice');
        }
        $branch_office = Session::get('branchoffice_id');
        return $branch_office;
    }


    public function strToBooleanValue($val){
        $response = true;

        if($val == 'false'){
            $response = false;
        }

        if($val == 'true'){
            $response = true;
        }

        if($val == false){
            $response = false;
        }

        return $response;
    }

    public function checkIsNullValue($val){
        $response = $val;
        if($val == 'null'){
            $response = null;
        }
        else if ($val == null){
            $response = null;
        }
        return $response;
    }


    public function checkCeroToNull($val){
        $response = $val;
        if($val == 0){
            $response = null;
        }
        else if ($val == '0'){
            $response = null;
        }
        return $response;
    }



    public function createEntryCorrelative()
    {

        $init_correlative = '0000000';
        $max_correlative = '9999999';
        $correlative = 1;


        $rMovement = new MovementRepository();

        $item = $rMovement->getEntryLastCheckCorrelative();

        if($item){
            $correlative = intval($item['correlative']) + 1;
        }

        $code  =  str_pad($correlative, strlen($init_correlative), "0", STR_PAD_LEFT);

        if ($code == $max_correlative){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Consulte con su administrador');
        }

        $str_code ='ES'.$this->getBranchOffice().$code;

        $arr = array(
          'nro_voucher' => $str_code,
          'correlative' => $correlative
        );

        return $arr;
    }

    public function createPurchaseCorrelative()
    {

        $init_correlative = '0000000';
        $max_correlative = '9999999';
        $correlative = 1;

        $rMovement = new PurchaseRepository();

        $item = $rMovement->getPurchaseLastCheckCorrelative();

        if($item){
            $correlative = intval($item['correlative']) + 1;
        }

        $code  =  str_pad($correlative, strlen($init_correlative), "0", STR_PAD_LEFT);

        if ($code == $max_correlative){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Consulte con su administrador');
        }

        $str_code ='CS'.$this->getBranchOffice().$code;

        $arr = array(
            'code' => $str_code,
            'correlative' => $correlative
        );

        return $arr;
    }


    public function createOrderCorrelative()
    {

        $init_correlative = '0000000';
        $max_correlative = '9999999';
        $correlative = 1;

        $rMovement = new OrderRepository();

        $item = $rMovement->getOrderLastCheckCorrelative();

        if($item){
            $correlative = intval($item['correlative']) + 1;
        }

        $code  =  str_pad($correlative, strlen($init_correlative), "0", STR_PAD_LEFT);

        if ($code == $max_correlative){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Consulte con su administrador');
        }

        $str_code ='PS'.$this->getBranchOffice().$code;

        $arr = array(
            'code' => $str_code,
            'correlative' => $correlative
        );

        return $arr;
    }

    public function createOrderPurchaseCorrelative()
    {

        $init_correlative = '0000000';
        $max_correlative = '9999999';
        $correlative = 1;

        $rOrderPurchase = new OrderPurchaseRepository();

        $item = $rOrderPurchase->getOrderLastCheckCorrelative();

        if($item){
            $correlative = intval($item['correlative']) + 1;
        }

        $code  =  str_pad($correlative, strlen($init_correlative), "0", STR_PAD_LEFT);

        if ($code == $max_correlative){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Consulte con su administrador');
        }

        $str_code ='OC'.$this->getBranchOffice().$code;

        $arr = array(
            'code' => $str_code,
            'correlative' => $correlative
        );

        return $arr;
    }

    public function createOutputCorrelative()
    {

        $init_correlative = '0000000';
        $max_correlative = '9999999';
        $correlative = 1;


        $rMovement = new MovementRepository();

        $item = $rMovement->getOuputLastCheckCorrelative();

        if($item){
            $correlative = intval($item['correlative']) + 1;
        }

        $code  =  str_pad($correlative, strlen($init_correlative), "0", STR_PAD_LEFT);

        if ($code == $max_correlative){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Consulte con su administrador');
        }

        $str_code ='SS'.$this->getBranchOffice().$code;

        $arr = array(
            'nro_voucher' => $str_code,
            'correlative' => $correlative
        );

        return $arr;
    }

    public function createTransferCorrelative()
    {

        $init_correlative = '0000000';
        $max_correlative = '9999999';
        $correlative = 1;


        $rMovement = new WarehouseTransferRepository();

        $item = $rMovement->getTransferLastCheckCorrelative();

        if($item){
            $correlative = intval($item['correlative']) + 1;
        }

        $code  =  str_pad($correlative, strlen($init_correlative), "0", STR_PAD_LEFT);

        if ($code == $max_correlative){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Consulte con su administrador');
        }

        $str_code ='TR'.$this->getBranchOffice().$code;

        $arr = array(
            'nro_voucher' => $str_code,
            'correlative' => $correlative
        );

        return $arr;
    }


    public function createSaleCorrelative()
    {
        $init_correlative = '0000000';
        $max_correlative = '9999999';
        $correlative = 1;

        $rSale = new SaleRepository();

        $item = $rSale->getSaleLastCheckCorrelative();

        if($item){
            $correlative = intval($item['correlative']) + 1;
        }

        $code  =  str_pad($correlative, strlen($init_correlative), "0", STR_PAD_LEFT);

        if ($code == $max_correlative){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Consulte con su administrador');
        }

        $str_code ='VS'.$this->getBranchOffice().$code;

        $arr = array(
            'code' => $str_code,
            'correlative' => $correlative
        );

        return $arr;
    }

    public function validateAmountSaleByVoucherClientDefault($client_id, $sale_amount, $type_voucher)
    {
        if ($client_id == config("app.client_default")) {
            if ($type_voucher == config("app.voucher_boleta_id")) {
                if ($sale_amount > config('app.max_monto_boleta_sin_dni')) {
                    throw new \ErrorException('Para ventas superiores a S/ ' . config("app.max_monto_boleta_sin_dni") . ' no se puede asignar al CLIENTE VARIOS', 100);
                }
            }
        }
    }

    public function row_excel($excel, $col, &$row, $val, $merge="", $bold=false, $border=false, $repayment = false) {
        if(is_int($col))
            $col = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($col);
        if(is_int($merge))
            $merge = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($merge);
        if($bold === true) {
            $excel->getActiveSheet()->getStyle("{$col}{$row}")->getFont()->setBold(true);
        }
        $excel->getActiveSheet()->setCellValue("{$col}{$row}", $val);
        if( ! empty($merge)) {
            $excel->setActiveSheetIndex(0)->mergeCells("{$col}{$row}:{$merge}{$row}");
        }
        if($border === true) {
            $cels = empty($merge) ? "{$col}{$row}" : "{$col}{$row}:{$merge}{$row}";
            $excel->getActiveSheet()->getStyle($cels)->applyFromArray(array(
                'borders' => array(
                    'outline' => array(
                        'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                    ,'color' => array('argb' => 'FF000000')
                    )
                )
            ));
        }
        if($repayment === true) {
            $cels = empty($merge) ? "{$col}{$row}" : "{$col}{$row}:{$merge}{$row}";

            $excel->getActiveSheet()->getStyle($cels)->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()->setARGB('E57F7F');
        }

    }

    public function createBookingDirectCorrelative()
    {
        $init_correlative = '000000';
        $max_correlative = '999999';
        $correlative = 1;

        $rBooking = new BookingRepository();

        $item = $rBooking->getBookingLastCheckCorrelative();

        if($item){
            $correlative = intval($item['correlative']) + 1;
        }

        $code  =  str_pad($correlative, strlen($init_correlative), "0", STR_PAD_LEFT);

        if ($code == $max_correlative){
            throw new \ErrorException('Ha alcanzado el límite del correlativo para el documento. Consulte con su administrador');
        }

        $str_code ='R'.date('Y').'-'.$code;

        $arr = array(
            'code' => $str_code,
            'correlative' => $correlative
        );

        return $arr;
    }


}
