<?php

namespace App\Http\Controllers\Api;

use App\Helper\UtilHelper;
use App\Models\System\System\Module\ModuleRepository;
use App\Models\System\System\ModulePermission\ModulePermissionRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AppApiController extends Controller
{

    protected $utilHelper;
    protected $rModule;
    protected $rModulePermission;

    public function __construct()
    {
        $this->rModule = new ModuleRepository();
        $this->rModulePermission = new ModulePermissionRepository();
        $this->utilHelper = new UtilHelper();
    }

    public function index(){

    }

    public function config()
    {
        $modules = $this->rModule->allByProfile();
        $permissions = $this->rModulePermission->permissions();

        $response = array(
            'status' => 'success',
            'modules'=> $modules,
            'permissions'=> $permissions
        );
        return response()->json($response);
    }

    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
