<?php

namespace App\Http\Controllers\Api\Billing;

use App\Core\SendBillingDocument;
use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Billing\NoteDocument\NoteDocumentRepository;
use App\Models\Tenant\Billing\NoteDocumentDetail\NoteDocumentDetailRepository;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Catalog\ProductStock\ProductStockRepository;
use App\Models\Tenant\Config\BillingCode\BillingCodeRepository;
use App\Models\Tenant\Money\MoneyBox\MoneyBoxRepository;
use App\Models\Tenant\Money\Movement\MovementRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use App\Models\Tenant\Sale\SaleDetail\SaleDetailRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class VoucherApiController extends Controller
{
    protected $rMoneyMovement;
    protected $rMoneyBox;
    protected $rSale;
    protected $utilHelper;
    protected $sendBilling;
    protected $rSaleDetail;
    protected $rProduct;
    protected $rProductStock;
    protected $rNoteDocument;
    protected $rNoteDocumentDetail;
    protected $rProductEquivalence;
    protected $tenant;


    public function __construct()
    {
        $this->rMoneyMovement = new MovementRepository();
        $this->rMoneyBox = new MoneyBoxRepository();
        $this->rSale = new SaleRepository();
        $this->utilHelper = new UtilHelper();
        $this->sendBilling = new SendBillingDocument();
        $this->rSaleDetail = new SaleDetailRepository();
        $this->rProduct = new ProductRepository();
        $this->rProductStock = new ProductStockRepository();
        $this->rNoteDocument = new NoteDocumentRepository();
        $this->rNoteDocumentDetail = new NoteDocumentDetailRepository();
        $this->rProductEquivalence = new ProductEquivalenceRepository();
        $this->tenant = new TenantCore();
    }

    public function listVouchers(Request $request)
    {
        $query = $this->rMoneyMovement->listVouchers($request);
        return response()->json($query);
    }

    public function cancelledVoucher(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $data_cancelled = $data['cancelled'];

            $moneybox = $this->rMoneyBox->getBoxMoney();
            $cancelled = $this->rMoneyMovement->cancelledVoucher($data_cancelled);

            // cancelled associate sale
            $sale_id = $data_cancelled['sale_id'];
            $this->rSale->deleted($sale_id);

            // detail sale
            $detail_sale = $this->rSaleDetail->findBySale($sale_id);
            foreach ($detail_sale as $detail) {
                $product = $this->rProduct->find($detail['product_id']);

                if($product['type_product']== config('app.typeproduct_bienes')){

                    if($product['is_control_stock'] == true){
                        $detail['stock'] = $detail['quantity'];
                        if($product['typeprice_id'] == config('app.catalog_price_unit') ){
                            $detail['quantity'] = $detail['quantity'] * $detail['equivalence_val'];
                            $detail['stock'] = $detail['quantity'];
                        }

//                         substract product batch
//                        if($detail['productbatch_id'] != null){
//                            $this->rProductBatch->substractBatchProduct($detail['productbatch_id'], $detail);
//                        }

                        // update stock product
                        $this->rProductStock->updatedStockByWarehouse($detail['product_id'],$detail);
                    }
                }
            }

            if ($this->utilHelper->strToBooleanValue($data_cancelled['affect_moneybox']) == true) {
                $this->rMoneyBox->substractAmount($moneybox, $cancelled['amount']);
            }

            // cancelled to facturador

            if ($cancelled['billing_external_id'] != null) {
                $this->sendBilling->cancelledDocument($cancelled);
            }

            // create movement cancelled
            $cancelled['repaymentmovement_id'] = $cancelled['id'];
            $cancelled['moneybox_id'] = $moneybox->id;

            $movement_repayment = $this->rMoneyMovement->createRepaymentMovement($cancelled);

            // verificar pagos asociados a una venta
            $payments = $this->rSale->paymentsAssociateToSale($data_cancelled['sale_id']);

            $response = array(
                'status' => 'success',
                'data' => $movement_repayment,
                'payments' => $payments
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function sendVoucher(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $data_movement = $data['movement'];

            $movement = $this->rMoneyMovement->find($data_movement['id']);

            // get sale information
            $sale_id = $this->rMoneyMovement->getMovementSaleJoinAmortization($movement['id']);
            $sale = $this->rSale->find($sale_id['sale_id']);

            $this->sendBilling->facturaExonerada($sale, $movement, true);

            $response = array(
                'status' => 'success',
                'data' => $movement
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }


    }

    public function printVoucher($movement_id){
        $sale = $this->rMoneyMovement->getMovementSaleJoinAmortization($movement_id);
        $response = array(
            'status' => 'success',
            'data' => $sale,
            'sale_id' => $sale['sale_id']
        );
        return $response;
    }

    public function listNoteDocuments(Request $request)
    {
        $query = $this->rNoteDocument->listNoteDocuments($request);
        return response()->json($query);
    }

    public function saveNoteDocument(Request $request){
        DB::connection('tenant')->beginTransaction();
        try {
            $note_data = $request->get('note');
            $detail_data = $request->get('detail');

            // CREATE BILLING NOTE
            $sale = $this->rNoteDocument->create($note_data);

            foreach ($detail_data as $detail) {
                $detail['notedocument_id'] = $sale['id'];
                $detail['product_id'] = $detail['id'];
                $detail_sale = $this->rNoteDocumentDetail->create($detail);

                $product = $this->rProduct->find($detail['product_id']);
                $productequivalence_id = null;
                $productvariant_id = null;
                $detail['equivalence'] = null;

                // replace data in sale detail  according type price product
                if ($product['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unitmeasure_id']);
                    $detail['equivalence'] = $equivalence['equivalence'];
                    $productequivalence_id = $equivalence->id;
                }

                $detail_sale->productequivalence_id =$productequivalence_id;
                $detail_sale->productvariant_id =$productvariant_id;
                $detail_sale->equivalence_val = $detail['equivalence'];
                $detail_sale->save();
            }


            $company = $this->tenant->company();

            // $sale = note document data
            if($company->send_billing == true){
                $billing = $this->sendBilling->sendCreditNote($sale);
            }

            $response = array(
                'status' => 'success',
                'sale' => $sale,
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        }catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }

    }
}
