<?php

namespace App\Http\Controllers\Api\Branch;

use App\Http\Controllers\Controller;
use App\Models\Tenant\Branch\BranchBoxes\BranchBoxesRepository;
use App\Models\Tenant\Branch\BranchConfig\BranchConfigRepository;
use App\Models\Tenant\Branch\BranchOffice\BranchOfficeRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class BranchApiController extends Controller
{
    protected $rBranchBox;
    protected $rBranchConfig;
    protected $rBranchOffice;

    public function __construct()
    {
        $this->rBranchBox = new BranchBoxesRepository();
        $this->rBranchConfig = new BranchConfigRepository();
        $this->rBranchOffice = new BranchOfficeRepository();

    }

    public function branchOffices(){
        $query = $this->rBranchOffice->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function checkBranchBoxSelected(){
        $check = $this->rBranchBox->checkBranchBoxSelected();
        $branchbox_id = $this->rBranchBox->getBranchBox(true);

        $response = array(
            'results' => $check,
            'branchbox_id' => $branchbox_id,
        );

        return response()->json($response);
    }

    public function selectBranchBox(Request $request){

        $data = $request->all();
        $boxselected = $data['boxselected'];

        $item = $this->rBranchBox->selectBranchBox($boxselected);

        $response = array(
            'results' => $item,
        );

        return response()->json($response);
    }


    public function listBoxes(){

        $query = $this->rBranchBox->boxesByBranchOffice();

        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function settingGeneral(){
        $config_branch = $this->rBranchConfig->findByBranchoffice();
        $config_barcode = $this->rBranchConfig->configBarcodeByBranchoffice();
        $response = array(
            'success'=>true,
            'general' => $config_branch,
            'is_barcode' => $config_barcode,
        );

        return response()->json($response);
    }

    public function settingGeneralSave(Request $request){
        $general_data = $request->get('general');
        $this->rBranchConfig->updated($general_data['id'], $general_data);

        // update option barcode

        $this->rBranchConfig->updatedConfigBarcode($request->get('is_barcode'));

        $response = array(
            'success'=>true,
            'general' => $general_data,
            'is_barcode' => $this->rBranchConfig->configBarcodeByBranchoffice(),
        );

        return response()->json($response);

    }
}
