<?php

namespace App\Http\Controllers\Api\Catalog;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Brand\BrandRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BrandApiController extends Controller
{
    protected $utilHelper;
    protected $rBrand;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rBrand = new BrandRepository();
    }

    public function index(Request $request)
    {
        $model = $this->rBrand->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }

    public function allBrands()
    {
        $query = $this->rBrand->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $item = $this->rBrand->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
//            return response()->json($e->getMessage(), 400);
            DB::connection('tenant')->rollback();

            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $item = $this->rBrand->find($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }


    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rBrand->updated($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );
            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function destroy($id)
    {
        try {
            $this->rBrand->deleted($id);
            $response = array(
                'status' => 'success'
            );
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }

    public function search(Request $request)
    {

        $text_search = $request->get('search');
        $item = $this->rBrand->search($text_search);

        $response = array(
            'status' => 'success',
            'data' => $item
        );

        return response()->json($response);
    }
}
