<?php

namespace App\Http\Controllers\Api\Catalog;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Line\LineRepository;
use Illuminate\Http\Request;

class LineApiController extends Controller
{

    protected $utilHelper;
    protected $rLine;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rLine = new LineRepository();
    }

    public function index(Request $request)
    {
        $model = $this->rLine->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }

    public function allLines()
    {
        $query = $this->rLine->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        try {
            $data = $request->all();
            $item = $this->rLine->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $item = $this->rLine->find($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }


    public function update(Request $request, $id)
    {
        $attributes = $request->all();
        $item = $this->rLine->updated($id, $attributes);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function destroy($id)
    {
        try {
            $this->rLine->deleted($id);
            $response = array(
                'status' => 'success'
            );
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }

    public function search(Request $request)
    {

        $text_search = $request->get('search');
        $item = $this->rLine->search($text_search);

        $response = array(
            'status' => 'success',
            'data' => $item
        );

        return response()->json($response);
    }
}
