<?php

namespace App\Http\Controllers\Api\Catalog;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductBatch\ProductBatchRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Catalog\ProductGrouped\ProductGroupedRepository;
use App\Models\Tenant\Catalog\ProductPrice\ProductPriceRepository;
use App\Models\Tenant\Catalog\ProductStock\ProductStockRepository;
use App\Models\Tenant\Catalog\ProductVariant\ProductVariantRepository;
use App\Models\Tenant\Purchase\PurchaseDetail\PurchaseDetailRepository;
use App\Models\Tenant\Warehouse\Movement\MovementRepository;
use App\Models\Tenant\Warehouse\MovementDetail\MovementDetailRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProductApiController extends Controller
{
    protected $utilHelper;
    protected $rProduct;
    protected $rProductPrice;
    protected $rProductEquivalence;
    protected $rProductVariant;
    protected $rProductStock;
    protected $rWarehouseMovement;
    protected $rWarehouseMovementDetail;
    protected $tenantCore;
    protected $rProductBatch;
    protected $rPurchaseDetail;
    protected $rMovementDetail;


    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->tenantCore = new TenantCore();

        $this->rProduct = new ProductRepository();
        $this->rProductPrice = new ProductPriceRepository();
        $this->rProductEquivalence = new ProductEquivalenceRepository();
        $this->rProductVariant = new ProductVariantRepository();
        $this->rProductStock = new ProductStockRepository();

        $this->rWarehouseMovement = new MovementRepository();
        $this->rWarehouseMovementDetail = new MovementDetailRepository();
        $this->rProductBatch = new ProductBatchRepository();
        $this->rPurchaseDetail = new PurchaseDetailRepository();
        $this->rMovementDetail = new MovementDetailRepository();
    }

    public function index(Request $request)
    {
//        $model = $this->rProduct->model();
//        $query = $this->utilHelper->paginate($model, $request);
        $item = $this->rProduct->listBienes($request);
        return response()->json($item);
    }


    public function favorite(Request $request)
    {
        $warehouse_id = $request->get('warehouse_id');
        $item = $this->rProduct->listSaleFavorite($warehouse_id, $request);
//        $response = array(
//            'status' => 'success',
//            'data' => $item
//        );
//        return response()->json($response);
        return response()->json($item);
    }

    public function services(Request $request)
    {
        $item = $this->rProduct->listServices($request);
        return response()->json($item);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $product = $request->get('product');
            $item = $this->rProduct->create($product);
            $unit_id = $request->get('unit_id');
            $price_general = null;

            // price general
            if ($product['typeprice_id'] == config('app.catalog_price_general')) {
                $price_general = $request->get('price_general');
                $price_general['product_id'] = $item['id'];
                $price_general['unit_id'] = $unit_id;
                $this->rProductPrice->create($price_general);
            }

            // price by unit measure

            if ($product['typeprice_id'] == config('app.catalog_price_unit')) {
                $price_unit = $request->get('unitprices');
                foreach ($price_unit as $detail) {
                    $detail['product_id'] = $item['id'];
//                    $detail['unit_id'] = $unit_id;
                    $detail['unit_id'] = $detail['id'];
                    $this->rProductEquivalence->create($detail);
                }
            }


            // price by variant
            if ($product['typeprice_id'] == config('app.catalog_price_variant')) {
                $price_variant = $request->get('variantprices');
                foreach ($price_variant as $detail) {
                    $detail['product_id'] = $item['id'];
                    $detail['typevariant_id'] = $detail['id'];
                    $detail['unit_id'] = $unit_id;
                    $this->rProductVariant->create($detail);
                }
            }

            if ($product['is_control_stock'] == 'true') {
                $stock_general = $request->get('stock_general');
                $stock_general['product_id'] = $item['id'];
                $stock_general['unit_id'] = $unit_id;
                $this->rProductStock->create($stock_general);

                // add warehouse_movement initial product
//                $data_movement = $stock_general;
//                $movement = $this->rWarehouseMovement->createNewProduct($data_movement);
//                $data_movement['warehousemovement_id'] = $movement['id'];
//                $data_movement['price'] = $price_general['price_purchase'];
//                // detail movement
//                $this->rWarehouseMovementDetail->createNewProduct($data_movement);
            }

            //TODO: quitar cuando todas las bases de datos tenga la migracion del campo is_grouped - tabla productos(produtos agrupados)
            if ($product['is_grouped'] == 'true') {
                $check_column = \Schema::connection("tenant")->hasColumn('catalog_products','is_grouped');
                if($check_column){
                    $rProductGrouped = new ProductGroupedRepository();
                    $productgroupeds = $request->get('productgroupeds');
                    foreach ($productgroupeds as $detail) {
                        $detail['product_id'] = $item['id'];
                        $rProductGrouped->create($detail);
                    }
                }
            }


            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function storeService(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $product = $request->get('product');
            $item = $this->rProduct->createService($product);
            $unit_id = $request->get('unit_id');
            $price_general = null;

            // price general
            if ($product['typeprice_id'] == config('app.catalog_price_general')) {
                $price_general = $request->get('price_general');
                $price_general['product_id'] = $item['id'];
                $price_general['unit_id'] = $unit_id;
                $this->rProductPrice->create($price_general);
            }


            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $item = $this->rProduct->find($id);

//         this line is for products imports from excel : ej: mcumbaza
//        $products = $this->rProduct->all();
//        foreach ($products as $item) {
//            $result = $this->rProductPrice->findByProductId($item->id);
//            if($result == null){
//                $this->rProductPrice->createForProductImport($item->id);
//            }
//        }

        if ($item['typeprice_id'] == config('app.catalog_price_general')) {
            $item['price_general'] = $this->rProductPrice->findByProductId($item['id']);
        }

        if ($item['typeprice_id'] == config('app.catalog_price_unit')) {
            $item['unitprices'] = $this->rProductEquivalence->findByProductId($item['id']);
        }

        if ($item['typeprice_id'] == config('app.catalog_price_variant')) {
            $item['variantprices'] = $this->rProductVariant->findByProductId($item['id']);
        }

        if ($item['is_control_stock']) {
            $item['stock_general'] = $this->rProductStock->findByProductAndWarehouse($item['id']);
        }

        $check_column = \Schema::connection("tenant")->hasColumn('catalog_products','is_grouped');
        if($check_column){
            if($item['is_grouped']){
                $rProductGrouped = new ProductGroupedRepository();
                $item['productgroupeds'] = $rProductGrouped->findByProductId($item['id']);
            }
        }

        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }


    public function informationDetail($id)
    {
        $item = $this->rProduct->find($id);

        if ($item['typeprice_id'] == config('app.catalog_price_general')) {
            $item['price_general'] = $this->rProductPrice->findByProductId($item['id']);
        }

        if ($item['typeprice_id'] == config('app.catalog_price_unit')) {
            $item['unitprices'] = $this->rProductEquivalence->findByProductId($item['id']);
        }

        if ($item['is_control_stock']) {
            $item['stock_general'] = $this->rProductStock->findByProductAndWarehouse($item['id']);
        }

        // calculate average_price_product
        $average_purchase = $this->rPurchaseDetail->averagePricePurchaseProduct($id);
        $average_warehouse= $this->rMovementDetail->averagePriceMovementProduct($id);
        $last_price_purchase = $this->rPurchaseDetail->lastPricePurchaseProduct($id);

        $divider = 0;

        if($average_purchase['average_price'] != null or $average_purchase['average_price'] != 0){
            $divider = $divider + 1;
        }

        if($average_warehouse['average_price'] != null or $average_warehouse['average_price'] != 0){
            $divider = $divider + 1;
        }

        $calculate = ($average_purchase['average_price'] + $average_warehouse['average_price']);
        $average = "No registra datos";

        if ($calculate > 0){
            $average = round($calculate/$divider, 2);
        }

        $data = array(
            'product' => $item,
            'purchase_average' => $average,
            'last_price_purchase' => $last_price_purchase,
        );

        $response = array(
            'status' => 'success',
            'data' => $data
        );
        return response()->json($response);
    }


    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $product = $request->get('product');
            $item = $this->rProduct->updated($id, $product);
            $unit_id = $request->get('unit_id');

            if ($product['typeprice_id'] == config('app.catalog_price_general')) {
                $price_general = $request->get('price_general');
                $price_general['unit_id'] = $unit_id;
                $price_general['product_id'] = $item['id'];

                $check_pricegeneral = $this->rProductPrice->findByProductId($item['id']);

                if($check_pricegeneral != null){
                    $this->rProductPrice->updated($check_pricegeneral['id'], $price_general);
                }
                else{
                    $this->rProductPrice->create($price_general);
                }
            }


            if ($product['typeprice_id'] == config('app.catalog_price_unit')) {

                // delete pass equivalences
                $detail_pass = $this->rProductEquivalence->findByProductId($item['id']);

                $price_unit = $request->get('unitprices');

                if(count($detail_pass) > 0){
                    foreach ($detail_pass as $pass) {
                        $this->rProductEquivalence->deletedByProductAndUnit($pass->product_id, $pass->id);
//                        $this->rProductEquivalence->deleted($pass->detail_id);
                    }

                    foreach ($price_unit as $detail) {
//                        $data = $this->rProductEquivalence->find($detail['detail_id']);
                        $data = $this->rProductEquivalence->findByProductAndUnit($item['id'], $detail['id']);
                        if ($data) {
//                            $this->rProductEquivalence->updated($detail['detail_id'], $detail);
                            $this->rProductEquivalence->updated($detail['id'], $detail);
                        } else {
                            $detail['product_id'] = $item['id'];
                            $detail['unit_id'] = $detail['id'];
                            $this->rProductEquivalence->create($detail);
                        }
                    }
                }
                else{
                    foreach ($price_unit as $detail) {
                        $detail['product_id'] = $item['id'];
                        $detail['unit_id'] = $detail['id'];
                        $this->rProductEquivalence->create($detail);
                    }
                }


//            $price_general['unit_id'] = $unit_id;
//            $this->rProductPrice->updated($price_general['id'], $price_general);
            }


            if ($product['typeprice_id'] == config('app.catalog_price_variant')) {

                // delete pass variants
                $detail_pass = $this->rProductVariant->findByProductId($item['id']);

                $price_unit = $request->get('variantprices');

                if(count($detail_pass) > 0){
                    foreach ($detail_pass as $pass) {
                        $this->rProductVariant->deletedByProductAndTypeVariant($pass->product_id, $pass->id);
                    }

                    foreach ($price_unit as $detail) {
                        $data = $this->rProductVariant->findByProductAndTypeVariant($item['id'], $detail['id']);
                        $detail['unit_id'] = $detail['id'];
                        if ($data) {
                            $this->rProductVariant->updated($data['id'], $detail);
                        } else {
                            $detail['product_id'] = $item['id'];
                            $detail['typevariant_id'] = $detail['id'];
                            $this->rProductVariant->create($detail);
                        }
                    }
                }
                else{
                    foreach ($price_unit as $detail) {
                        $detail['product_id'] = $item['id'];
                        $detail['typevariant_id'] = $detail['id'];
                        $this->rProductVariant->create($detail);
                    }
                }
            }

            if ($this->utilHelper->strToBooleanValue($product['is_control_stock'])) {
                $stock_general = $request->get('stock_general');
                $stock_general['unit_id'] = $unit_id;
                $stock_general['product_id'] = $item['id'];
                if (isset($stock_general['id'])) {
                    $this->rProductStock->updated($stock_general['id'], $stock_general);
                } else {
                    $this->rProductStock->create($stock_general);
                }
            }

            //TODO: quitar cuando todas las bases de datos tenga la migracion del campo is_grouped - tabla productos(produtos agrupados)
            if ($this->utilHelper->strToBooleanValue($product['is_grouped'])) {
                $check_column = \Schema::connection("tenant")->hasColumn('catalog_products','is_grouped');
                if($check_column){
                    $rProductGrouped = new ProductGroupedRepository();
                    $productgroupeds = $request->get('productgroupeds');

                    $detail_pass = $rProductGrouped->findByProductId($item['id']);

                    if(count($detail_pass) > 0){
                        foreach ($detail_pass as $pass) {
                            $rProductGrouped->deletedByProductAndExtend($item['id'], $pass->id);
                        }

                        foreach ($productgroupeds as $detail) {
                            $data = $rProductGrouped->findByProductAndExtend($item['id'], $detail['id']);
                            if ($data) {
                                $rProductGrouped->updated($data['id'], $detail);
                            } else {
                                $detail['product_id'] = $item['id'];
                                $rProductGrouped->create($detail);
                            }
                        }
                    }
                    else{
                        foreach ($productgroupeds as $detail) {
                            $detail['product_id'] = $item['id'];
                            $rProductGrouped->create($detail);
                        }
                    }
                }
            }


            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $this->rProduct->deleted($id);
            $response = array(
                'status' => 'success'
            );
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }

    public function search(Request $request)
    {

        $text_search = $request->get('search');
        $item = $this->rProduct->search($text_search);

        $response = array(
            'status' => 'success',
            'data' => $item
        );

        return response()->json($response);
    }

    public function saleSearch(Request $request)
    {
        $text_search = $request->get('search');
        $warehouse_id = $request->get('warehouse_id');

        $item = $this->rProduct->saleSearch($text_search, $warehouse_id);

        $response = array(
            'status' => 'success',
            'data' => $item
        );

        return response()->json($response);
    }

    public function searchBienesAngucomplete(Request $request)
    {
//        $text_search = $request->get('search');
//        $control_stock = $request->get('control_stock');

//        $item = $this->rProduct->searchTypeBienes($text_search, $control_stock);
        $item = $this->rProduct->searchTypeBienes($request);

        $response = array(
            'incomplete_results' => false,
            'items' => $item,
            'total_count' => count($item));

        return response()->json($response);
    }

    public function searchBienesAndServiciosAngucomplete(Request $request)
    {
        $text_search = $request->get('search');

        $item = $this->rProduct->searchBienesAndServicios($text_search);

        $response = array(
            'incomplete_results' => false,
            'items' => $item,
            'total_count' => count($item));

        return response()->json($response);
    }


    public function batchExpiration(Request $request){
        $data = $request->all();
        $query = $this->rProductBatch->findByProductAndWarehouse($data['product_id'], $data['warehouse_id']);
        $response = array(
            'results' => $query,
            'total' => count($query)
        );
        return response()->json($response);
    }

    public function searchByCategory(Request $request)
    {
        $category_id = $request->get('category_id');
        $item = $this->rProduct->searchByCategory($category_id);

        $response = array(
            'status' => 'success',
            'data' => $item
        );

        return response()->json($response);
    }
}
