<?php

namespace App\Http\Controllers\Api\Catalog;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\TypeVariant\TypeVariantRepository;
use App\Models\Tenant\Catalog\Variant\VariantRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class VariantApiController extends Controller
{

    protected $utilHelper;
    protected $rVariant;
    protected $rTypeVariant;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rVariant = new VariantRepository();
        $this->rTypeVariant = new TypeVariantRepository();
    }

    public function index(Request $request)
    {
        $model = $this->rVariant->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }


    public function all()
    {
        $query = $this->rVariant->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function typesByVariant(Request $request)
    {
        $variant_id = $request->get('variant_id');
        $item = $this->rVariant->searchTypesByVariant($variant_id);

        $response = array(
            'data' => $item,
            'status' => 'success'
        );

        return response()->json($response);
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $variant_data = $request->get('variant');
            $types_data = $request->get('types');

            $variant = $this->rVariant->create($variant_data);

            // insert data in order Detail

            foreach ($types_data as $item) {
                $item['variant_id'] = $variant['id'];
                $this->rTypeVariant->create($item);
            }

            $response = array(
                'status' => 'success',
            );

            DB::commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $item = $this->rVariant->find($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }


    public function update(Request $request, $id)
    {
        $variant_data = $request->get('variant');
        $types = $request->get('types');

        $variant = $this->rVariant->updated($variant_data['id'], $variant_data);

        // delete pass history orderdetail
        $types_pass = $this->rTypeVariant->findByVariantId($variant['id']);

        foreach ($types_pass as $item){
            $this->rTypeVariant->deleted($item->id);
        }

        foreach ($types as $item){
            if(isset($item['id'])){
                $this->rTypeVariant->updated($item['id'], $item);
            }
            else{
                $item['variant_id'] = $variant['id'];
                $this->rTypeVariant->create($item);
            }
        }

        $response = array(
            'status' => 'success',
            'data'=> $variant
        );
        return response()->json($response);
    }

    public function destroy($id)
    {
        try {
            $this->rVariant->deleted($id);
            $response = array(
                'status' => 'success'
            );
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }

    public function search(Request $request)
    {

        $text_search = $request->get('search');
        $item = $this->rVariant->search($text_search);

        $response = array(
            'status' => 'success',
            'data' => $item
        );

        return response()->json($response);
    }
}
