<?php

namespace App\Http\Controllers\Api\Company;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\System\Company\CompanyRepository;
use App\Models\Tenant\Company\CompanyJob\CompanyJobRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CompanyApiController extends Controller
{

    protected $utilHelper;
    protected $rCompanyJob;
    protected $tenant;
    protected $rCompany;


    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rCompanyJob = new CompanyJobRepository();
        $this->tenant = new TenantCore();
        $this->rCompany = new CompanyRepository();
    }



    public function index()
    {
        //
    }

    public function informationCompany(Request $request){
        $query = $this->tenant->company();

        $response = array(
            'results' => $query,
        );

        return response()->json($response);
    }

    public function updateInformationCompany(Request $request, $id)
    {
        try {
            $attributes = $request->all();
            $item = $this->rCompany->updated($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );
            return response()->json($response);
        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }

    public function jobs(Request $request)
    {
        $model = $this->rCompanyJob->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }

    public function allJobs()
    {
        $query = $this->rCompanyJob->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }


    public function storeJob(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $item = $this->rCompanyJob->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {

            DB::connection('tenant')->rollback();
            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function editJob($id)
    {
        $item = $this->rCompanyJob->find($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function updateJob(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rCompanyJob->updated($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );
            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function destroyJob($id)
    {
        try {
            $this->rCompanyJob->deleted($id);
            $response = array(
                'status' => 'success'
            );
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }


    public function getUrlDownloadXml()
    {
        $company = $this->tenant->company();
        $url_download = $company->api_facturador."/downloads/document/xml/";

        $response = array(
            'status' => 'success',
            'url_download' => $url_download
        );

        return response()->json($response);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
