<?php

namespace App\Http\Controllers\Api\Company;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Company\AssignedBranch\AssignedBranchRepository;
use App\Models\Tenant\Company\Employee\EmployeeRepository;
use App\Models\Tenant\Ubigeo\Department\DepartmentRepository;
use App\Models\Tenant\Ubigeo\District\DistrictRepository;
use App\Models\Tenant\Ubigeo\Province\ProvinceRepository;
use App\Models\Tenant\Ubigeo\UbigeoDetail\UbigeoDetailRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class EmployeeApiController extends Controller
{

    protected $utilHelper;

    protected $rEmployee;
    protected $rUbigeoDepartment;
    protected $rUbigeoProvince;
    protected $rUbigeoDistrict;
    protected $rUbigeoDetail;
    protected $rAssignedBranch;

    public function __construct()
    {
        $this->rEmployee = new EmployeeRepository();
        $this->utilHelper = new UtilHelper();

        $this->rUbigeoDepartment = new DepartmentRepository();
        $this->rUbigeoProvince = new ProvinceRepository();
        $this->rUbigeoDistrict = new DistrictRepository();
        $this->rUbigeoDetail = new UbigeoDetailRepository();
        $this->rAssignedBranch = new AssignedBranchRepository();

    }

    public function index(Request $request)
    {
        $model = $this->rEmployee->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $employee = $this->rEmployee->create($data);

            $assignedbranchs = $data['assignedbranchs'];

            foreach ($assignedbranchs as $branch) {
                $branch['employee_id'] = $employee['id'];
                $this->rAssignedBranch->create($branch);
            }


//            // add ubigeo detail
//            $data['client_id'] = $item->id;
//            $data['is_required_ubigeo'] = $data['is_required_ubigeo'] === 'true' ? true : false;
//            if ($data['is_required_ubigeo']) {
//                $this->rUbigeoDetail->createUbigeoClient($data);
//            }

            $response = array(
                'status' => 'success',
                'data' => $employee
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $item = $this->rEmployee->find($id);

        // get ubigeo data
//        $ubigeo_detail = $this->rUbigeoDetail->findUbigeoClient($item->id);
        $ubigeo = false;

//        if ($ubigeo_detail) {
//            $ubigeo = array(
//                'department_id' => $ubigeo_detail->department_id,
//                'province_id' => $ubigeo_detail->province_id,
//                'district_id' => $ubigeo_detail->district_id,
//                'departments' => $this->rUbigeoDepartment->all(),
//                'provinces' => $this->rUbigeoProvince->allByDepartment($ubigeo_detail->department_id),
//                'districts' => $this->rUbigeoDistrict->allByProvince($ubigeo_detail->province_id),
//            );
//
//        }

        $response = array(
            'status' => 'success',
            'ubigeo' => $ubigeo,
            'data' => $item
        );
        return response()->json($response);
    }

    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $employee = $this->rEmployee->updated($id, $attributes);

            $assignedbranchs = $attributes['assignedbranchs'];

            $assigned_pass = $this->rAssignedBranch->findByEmployee($employee['id']);

            if(count($assigned_pass) > 0){
                foreach ($assigned_pass as $pass) {
                    $this->rAssignedBranch->deleted($pass->detail_id);
                }
            }

            foreach ($assignedbranchs as $branch) {
                $branch['employee_id'] = $employee['id'];

                $data = $this->rAssignedBranch->findByEmployeeAndBranchoffice($branch['employee_id'], $branch['id']);

                if($data != null){
                    $data->deleted_at = null;
                    $data->save();
//                    $this->rAssignedBranch->updated($branch['detail_id'], $branch);
                }else{
                    $this->rAssignedBranch->create($branch);
                }
            }

            // update ubigeo
//            $attributes['client_id'] = $item->id;
//            $attributes['is_required_ubigeo'] = $attributes['is_required_ubigeo'] === 'true' ? true : false;
//
//            if ($attributes['is_required_ubigeo']) {
//                $this->rUbigeoDetail->updatedUbigeoClient($attributes);
//            }

            $response = array(
                'status' => 'success',
                'data' => $employee
            );

            DB::connection('tenant')->commit();
            return response()->json($response);
        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function destroy($id)
    {
        try {
            $this->rEmployee->deleted($id);
            $response = array(
                'status' => 'success'
            );
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }


    public function searchAngucomplete(Request $request)
    {
        $text_search = $request->get('search');
        $item = $this->rEmployee->search($text_search);

        $response = array(
            'incomplete_results' => false,
            'items' => $item,
            'total_count' => count($item));

        return response()->json($response);
    }
}
