<?php

namespace App\Http\Controllers\Api\Config;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Models\Tenant\Branch\BranchOffice\BranchOfficeRepository;
use App\Models\Tenant\Config\BillingCode\BillingCodeRepository;
use App\Models\Tenant\Config\Currency\CurrencyRepository;
use App\Models\Tenant\Config\PaymentMethod\PaymentMethodRepository;
use App\Models\Tenant\Config\SerieVoucher\SerieVoucherRepository;
use App\Models\Tenant\Config\Tax\TaxRepository;
use App\Models\Tenant\Config\TypeDocument\TypeDocumentRepository;
use App\Models\Tenant\Config\TypeTransaction\TypeTransactionRepository;
use App\Models\Tenant\Config\TypeVoucher\TypeVoucherRepository;
use App\Models\Tenant\Config\UnitMeasure\UnitMeasureRepository;
use App\Models\Tenant\Ubigeo\Department\DepartmentRepository;
use App\Models\Tenant\Ubigeo\District\DistrictRepository;
use App\Models\Tenant\Ubigeo\Province\ProvinceRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ConfigApiController extends Controller
{
    protected $utilHelper;
    protected $rTypeDocument;
    protected $rUnitMeasure;
    protected $rCurrency;
    protected $rTypevoucher;
    protected $rTax;
    protected $rTypetransaction;
    protected $rSerie;
    protected $rPaymentMethod;
    protected $rBillingCode;

    protected $rUbigeoDepartment;
    protected $rUbigeoProvince;
    protected $rUbigeoDistrict;

    protected $tenant;

    protected $rBranchOffice;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rTypeDocument = new TypeDocumentRepository();
        $this->rUnitMeasure = new UnitMeasureRepository();
        $this->rTypetransaction = new TypeTransactionRepository();
        $this->rCurrency = new CurrencyRepository();
        $this->rTypevoucher = new TypeVoucherRepository();
        $this->rTax = new TaxRepository();
        $this->rSerie = new SerieVoucherRepository();
        $this->rPaymentMethod = new PaymentMethodRepository();
        $this->rBillingCode = new BillingCodeRepository();

        $this->rUbigeoDepartment = new DepartmentRepository();
        $this->rUbigeoProvince = new ProvinceRepository();
        $this->rUbigeoDistrict = new DistrictRepository();

        $this->tenant = new TenantCore();
        $this->rBranchOffice = new BranchOfficeRepository();

    }


    public function index()
    {
        $query = $this->rTypeDocument->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function typeTransaction()
    {
        $query = $this->rTypetransaction->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }


    public function currency()
    {
        $query = $this->rCurrency->allOrderByPrincipal();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }


    public function tax()
    {
        $query = $this->rTax->all();
        $include_igv = $this->tenant->includeIgv();

        // config store hostignet bellavista
        $branchoofice_id = $this->utilHelper->getBranchOffice();
        $database = $this->tenant->database();

        if($database == config("app.database_hostingnet")){
            if($branchoofice_id == 2){
                $include_igv = true;
            }
        }
//        dd($branchoofice_id, $database, $include_igv);
        // =========

        $response = array(
            'results' => $query,
            'include_igv' => $include_igv,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function typeVoucher()
    {
        $query = $this->rTypevoucher->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function typeVoucherPurchase()
    {
        $query = $this->rTypevoucher->allTypePurchase();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function typeVoucherSale()
    {
        $query = $this->rTypevoucher->allTypeSale();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function typeVoucherBilling()
    {
        $query = $this->rTypevoucher->allTypeBilling();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function typeVoucherNotes()
    {
        $query = $this->rTypevoucher->allTypeNotes();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function paymentMethod()
    {
        $query = $this->rPaymentMethod->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function voucherSerie($unit_id)
    {
        $branchoofice_id = $this->utilHelper->getBranchOffice();

        $query = $this->rSerie->allSerieByVoucher($unit_id, $branchoofice_id);
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }


    public function billingCodesByVoucher($voucher_id)
    {
        $query = $this->rBillingCode->allByVoucher($voucher_id);
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }



    public function typeDocument()
    {
        $query = $this->rTypeDocument->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function unitMeasureParents()
    {
        $query = $this->rUnitMeasure->unitParents();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function unitMeasureChilds($unit_id)
    {
        $query = $this->rUnitMeasure->unitChilds($unit_id);
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function unitMeasureAllChilds()
    {
        $query = $this->rUnitMeasure->unitAllChilds();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }


    public function ubigeoDepartments()
    {
        $departments = $this->rUbigeoDepartment->all();
        $response = array(
            'status' => 'success',
            'results'=> $departments
        );
        return response()->json($response);
    }

    public function ubigeoProvinces($department_id)
    {
        $provinces = $this->rUbigeoProvince->allByDepartment($department_id);
        $response = array(
            'status' => 'success',
            'results'=> $provinces
        );
        return response()->json($response);
    }

    public function ubigeoDistricts($province_id)
    {
        $districts = $this->rUbigeoDistrict->allByProvince($province_id);
        $response = array(
            'status' => 'success',
            'results'=> $districts
        );
        return response()->json($response);
    }



    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
