<?php

namespace App\Http\Controllers\Api\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Purchase\Provider\ProviderRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use App\Models\Tenant\Sale\SalePaid\SalePaidRepository;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    protected $rProduct;
    protected $rClient;
    protected $rSale;
    protected $rSalePaid;
    protected $rProvider;

    public function __construct()
    {
        $this->rProduct = new ProductRepository();
        $this->rClient = new ClientRepository();
        $this->rSale = new SaleRepository();
        $this->rSalePaid = new SalePaidRepository();
        $this->rProvider = new ProviderRepository();
    }

    public function index()
    {

        $response = array(
            'status' => 'success',
            'count_product' => count($this->rProduct->all()),
            'count_client' => count($this->rClient->all()),
            'count_provider' => count($this->rProvider->all()),
            'total_sale_month' => $this->rSale->sumTotalSaleByMonth()['total_month'],
            'graph_sale_month' => $this->rSale->totalSaleMonthByYear(),
            'list_credits' => $this->rSale->top10listCharge(),
            'total_credit' => $this->rSalePaid->sumTotalChargeCredit()['total_credit'],
        );

//        dd($response);

        return response()->json($response);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
