<?php

namespace App\Http\Controllers\Api\Finance;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Finance\AccountBank\AccountBankRepository;
use App\Models\Tenant\Finance\Bank\BankRepository;
use App\Models\Tenant\Finance\TypeAccount\TypeAccountRepository;
use App\Models\Tenant\Money\Movement\Movement;
use App\Models\Tenant\Money\Movement\MovementRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FinanceApiController extends Controller
{
    protected $utilHelper;
    protected $rBank;
    protected $rAccountBank;
    protected $rTypeAccount;
    protected $rMoneyMovement;


    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rBank = new BankRepository();
        $this->rAccountBank= new AccountBankRepository();
        $this->rTypeAccount= new TypeAccountRepository();
        $this->rMoneyMovement= new MovementRepository();
    }

    public function typeAccount()
    {
        $query = $this->rTypeAccount->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function banks(Request $request){
        $model = $this->rBank->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }

    public function allBanks()
    {
        $query = $this->rBank->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function accountBanks(Request $request){
        $query = $this->rAccountBank->listAccountBank($request);
        return response()->json($query);
    }

    public function storeBank(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $item = $this->rBank->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();

            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function storeAccountBank(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();

            $item = $this->rAccountBank->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();

            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function editBank($id)
    {
        $item = $this->rBank->find($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function editAccountBank($id)
    {
        $item = $this->rAccountBank->find($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function updateBank(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rBank->updated($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );
            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function updateAccountBank(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rAccountBank->updated($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );
            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }


    public function destroyBank($id)
    {
        $this->rBank->deleted($id);
        $response = array(
            'status' => 'success'
        );
        return response()->json($response);
    }

    public function destroyAccountBank($id)
    {
        $this->rAccountBank->deleted($id);
        $response = array(
            'status' => 'success'
        );
        return response()->json($response);
    }

    public function allAccountBank()
    {
        $query = $this->rAccountBank->allByBranchoffice();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function listMovementAccountBank(Request $request)
    {
        $query = $this->rMoneyMovement->listMovementAccountBank($request);
        return response()->json($query);
    }


}
