<?php

namespace App\Http\Controllers\Api\Hotel;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Hotel\Bedroom\BedroomRepository;
use App\Models\Tenant\Hotel\BedroomDetail\BedroomDetailRepository;
use App\Models\Tenant\Hotel\Booking\BookingRepository;
use App\Models\Tenant\Hotel\GuestDetail\GuestDetailRepository;
use App\Models\Tenant\Money\Movement\MovementRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use App\Models\Tenant\Sale\SalePaid\SalePaidRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BookingApiController extends Controller
{
    protected $rBooking;
    protected $rBedroom;
    protected $utilHelper;
    protected $rBedroomDetail;
    protected $rGuestDetail;
    protected $rClient;
    protected $rSalePaid;
    protected $rMoneyMovement;
    protected $rSale;

    public function __construct()
    {
        $this->rBooking = new BookingRepository();
        $this->rBedroom = new BedroomRepository();
        $this->rBedroomDetail = new BedroomDetailRepository();
        $this->rGuestDetail = new GuestDetailRepository();
        $this->utilHelper = new UtilHelper();
        $this->rClient = new ClientRepository();
        $this->rSalePaid = new SalePaidRepository();
        $this->rMoneyMovement = new MovementRepository();        
        $this->rSale = new SaleRepository();
    }

    public function index(Request $request)
    {
//        $item = $this->rBedroom->list($request);


        $item = $this->rBedroomDetail->list($request);
        return response()->json($item);

    }


    public function availableBedroomsToday(Request $request)
    {
        $item = $this->rBedroom->availableBedroomsToday($request);
        return response()->json($item);

    }

    public function planning(Request $request)
    {
        $bedrooms = $this->rBedroom->resourcesPlanning();
        $events_data = $this->rBedroomDetail->eventsPlanning($request->all());
        $response = array(
            'results' => $bedrooms,
            'events_data' => $events_data,
            'total' => count($bedrooms)
        );
        return response()->json($response);
    }

    public function checkAvailableBedroom(Request $request)
    {
//        $query = $this->rBedroom->availableBedroom($request->all());
        $query = $this->rBedroomDetail->availableBedroom($request->all());
        $response = array(
            'results' => $query,
            'total' => count($query)
        );
        return response()->json($response);
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $book_data = $request->get('book');
            $bedroom_data = $request->get('book_bedroom');
            $guest_data = $request->get('book_guest');

            $booking = $this->rBooking->create($book_data);

            // data bedroom booking
            $bedroom_data["booking_id"] = $booking->id;
            $bedroom_detail = $this->rBedroomDetail->create($bedroom_data);

            // data guest booking
            foreach ($guest_data as $guest) {

                $client = $this->rClient->createFromGuest($guest);

                $guest["client_id"] =$client->id;
                $guest["booking_id"] = $booking->id;
                $guest_detail = $this->rGuestDetail->create($guest);
            }

            // sale  paid =======
            $arr_salepaid = array();
            $arr_salepaid['booking_id'] = $booking->id;
            $arr_salepaid['total_amount'] = $booking->total;
            $arr_salepaid['total_paid'] = 0;

            $salepaid = $this->rSalePaid->createFromBooking($arr_salepaid);
            //=======
            $response = array(
                'status' => 'success',
                'data' => $booking
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $book_bedroom = $this->rBedroomDetail->find($id);
        $book = $this->rBooking->find($book_bedroom->booking_id);
        $book_guest = $this->rGuestDetail->findBybooking($book->id);


        $result = array(
            'book' => $book,
            'book_bedroom' => $book_bedroom,
            'book_guest' => $book_guest
        );

        $response = array(
            'status' => 'success',
            'data' => $result
        );
        return response()->json($response);
    }

    public function detail($id)
    {
        $book_bedroom = $this->rBedroomDetail->find($id);
        $book = $this->rBooking->find($book_bedroom->booking_id);
        $book_guest = $this->rGuestDetail->findBybooking($book->id);
        $sales = $this->rSale->findByBookingHotelId($book->id);
        $movements = $this->rMoneyMovement->getMovementByHotelBooking($id);

        $result = array(
            'book' => $book,
            'book_bedroom' => $book_bedroom,
            'book_guest' => $book_guest,
            'sales' => $sales,
            'movements' => $movements,
        );

        $response = array(
            'status' => 'success',
            'data' => $result
        );
        return response()->json($response);
    }



    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $book_data = $request->get('book');
            $bedroom_data = $request->get('book_bedroom');
            $guest_data = $request->get('book_guest');

            $booking = $this->rBooking->updated($id, $book_data);

             // data bedroom booking            
             $bedroom_obj = $this->rBedroomDetail->findByBooking($booking->id);
             $bedroom_detail = $this->rBedroomDetail->updated($bedroom_obj->id, $bedroom_data);

            // delete pass clients data
            $guest_pass = $this->rGuestDetail->findByBooking($booking['id']);
            foreach ($guest_pass as $item) {
                $this->rGuestDetail->deleted($item->id);
            }

            if ($guest_data != null) {
                foreach ($guest_data as $item) {
                    $detail = $this->rGuestDetail->findByBookingAndClient($booking['id'], $item['client_id']);

                    if ($detail == null) {
                        $client = $this->rClient->createFromGuest($item);
                        $item['booking_id'] = $booking['id'];
                        $item['client_id'] = $client->id;
                        $this->rGuestDetail->create($item);
                    } else {
                        $client_data = $this->rGuestDetail->updated($detail['id'], $item);
                        // update client data
                        $this->rClient->updateFromGuest($client_data->client_id, $item);
                    }
                }
            }

            // update sale  paid =======
            $sale_paid = $this->rSalePaid->findByBooking($booking->id);
            $sale_paid->total_amount =  $booking->total;
            $sale_paid->total_paid = 0;
            $sale_paid->save();
            //=======

            $response = array(
                'status' => 'success',
                'data' => $booking
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }

    }


    public function checkin(Request $request, $id)
    {
        $item = $this->rBooking->checkin($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function checkout(Request $request, $id)
    {
        $bedroom_data = $request->get('bedroom_data');
        $item = $this->rBooking->checkout($id);

        // updatep bedroom to dirty
        $this->rBedroom->passToDirty($bedroom_data["id"]);

        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function enableBedroom(Request $request, $id)
    {
        $item = $this->rBedroom->enableBedroom($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function maintenanceBedroom(Request $request, $id)
    {
        $item = $this->rBedroom->maintenanceBedroom($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function destroy($id)
    {
        //
    }
}
