<?php

namespace App\Http\Controllers\Api\Hotel;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Hotel\Bedroom\BedroomRepository;
use App\Models\Tenant\Hotel\Rate\RateRepository;
use App\Models\Tenant\Hotel\RateBedroom\RateBedroomRepository;
use App\Models\Tenant\Hotel\RoomType\RoomtypeRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HotelApiController extends Controller
{

    protected $utilHelper;
    protected $rRoomType;
    protected $rBedroom;
    protected $rRate;
    protected $rRateBedroom;


    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rRoomType = new RoomtypeRepository();
        $this->rBedroom = new BedroomRepository();
        $this->rRate = new RateRepository();
        $this->rRateBedroom = new RateBedroomRepository();
    }


    public function roomtypes(Request $request){
        $model = $this->rRoomType->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }

    public function allRoomTypes()
    {
        $query = $this->rRoomType->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function storeRoomType(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $item = $this->rRoomType->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();

            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function editRoomType($id)
    {
        $item = $this->rRoomType->find($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function updateRoomType(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rRoomType->updated($id, $attributes);
            $response = array(
                'status' => 'success',
                'data' => $item
            );
            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function destroyRoomType($id)
    {
        $this->rRoomType->deleted($id);
        $response = array(
            'status' => 'success'
        );
        return response()->json($response);
    }



    public function bedrooms(Request $request){
        $model = $this->rBedroom->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }


    public function allBedrooms()
    {
        $query = $this->rBedroom->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function storeBedroom(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
//            $data = $request->all();
            $data = $request->get('bedrooms');
            $item = $this->rBedroom->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            $ratesbedrooms = $request->get('ratesbedrooms');
            foreach ($ratesbedrooms as $detail) {
                $detail['bedroom_id'] = $item['id'];
                $detail['rate_id'] = $detail['id'];

                $this->rRateBedroom->create($detail);
            }

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();

            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function editBedroom($id)
    {
        $item = $this->rBedroom->find($id);

        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    public function updateBedroom(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
//            $attributes = $request->all();
            $attributes = $request->get("bedrooms");
            $item = $this->rBedroom->updated($id, $attributes);

            // deleted pass rates
            $detail_pass = $this->rRateBedroom->findByBedroom($item['id']);
            $ratesbedrooms = $request->get('ratesbedrooms');

//            dd($detail_pass);

            if(count($detail_pass) > 0){
                foreach ($detail_pass as $pass) {
                    $this->rRateBedroom->deleted($pass->id);
                }
                foreach ($ratesbedrooms as $detail) {
                    $data = $this->rRateBedroom->findByBedroomAndRate($item['id'], $detail['id']);
                    $detail['bedroom_id'] = $item['id'];
                    $detail['rate_id'] = $detail['id'];

                    if ($data) {
                        $this->rRateBedroom->updated($data['id'], $detail);
                    } else {
                        $this->rRateBedroom->create($detail);
                    }
                }
            }
            else{
                foreach ($ratesbedrooms as $detail) {
                    $detail['bedroom_id'] = $item['id'];
                    $detail['rate_id'] = $detail['id'];
                    $this->rRateBedroom->create($detail);
                }
            }

            $response = array(
                'status' => 'success',
                'data' => $item
            );
            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }

    public function destroyBedroom($id)
    {
        $this->rBedroom->deleted($id);
        $response = array(
            'status' => 'success'
        );
        return response()->json($response);
    }


    public function allRates()
    {
        $query = $this->rRate->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

}
