<?php

namespace App\Http\Controllers\Api;

use App\Helper\CustomResponseException;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Inquiry\Response\ResponseRepository;
use App\Models\Tenant\Inquiry\ResponseDetail\ResponseDetailRepository;
use App\Models\Tenant\Inquiry\Survey\SurveyRepository;
use Illuminate\Http\Request;

class InquiryApiController extends Controller
{


    protected $utilHelper;
    protected $rSurvey;
    protected $rResponse;
    protected $rResponseDetail;


    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rSurvey = new SurveyRepository();
        $this->rResponse = new ResponseRepository();
        $this->rResponseDetail = new ResponseDetailRepository();
    }

    public function index(Request $request)
    {
        $model = $this->rSurvey->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        //
    }


    public function show($id)
    {
        //
    }


    public function file($id)
    {
        $survey = $this->rSurvey->find($id);
        $survey_response = $this->rResponse->findBySurveyIdJoined($id);

        $result = array(
            'survey' => $survey,
            'responses' => $survey_response,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }


    public function savePoll(Request $request)
    {
        try {
            $poll = $request->get('poll');
            $questions = $request->get('questions');

            $response = $this->rResponse->create($poll);

            foreach ($questions as $item) {
                $item['response_id'] = $response->id;
                $this->rResponseDetail->create($item);
            }

            $response = array(
                'status' => 'success',
                'data'=> $item
            );
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 400);
        }
    }


    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
