<?php

namespace App\Http\Controllers\Api\Money;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Hotel\Booking\BookingRepository;
use App\Models\Tenant\Money\MoneyBox\MoneyBoxRepository;
use App\Models\Tenant\Money\MoneyConcept\MoneyConceptRepository;
use App\Models\Tenant\Money\Movement\MovementRepository;
use App\Models\Tenant\Purchase\Purchase\PurchaseRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use App\Models\Tenant\Sale\SaleAmortization\SaleAmortizationRepository;
use App\Models\Tenant\Sale\SalePaid\SalePaidRepository;
use App\Models\Tenant\Sale\ScheduleSale\ScheduleSaleRepository;
use App\Models\Tenant\Sale\ScheduleSaleDetail\ScheduleSaleDetailRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MoneyApiController extends Controller
{
    protected $utilHelper;
    protected $rMoneyBox;
    protected $rMoneyConcept;
    protected $rMoneyMovement;
    protected $rSale;
    protected $rSalePaid;
    protected $rSaleAmortization;
    protected $rScheduleSale;
    protected $rScheduleSaleDetail;
    protected $rPurchase;
    protected $rBooking;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rMoneyBox = new MoneyBoxRepository();
        $this->rMoneyConcept = new MoneyConceptRepository();
        $this->rMoneyMovement = new MovementRepository();
        $this->rSale = new SaleRepository();
        $this->rSalePaid = new SalePaidRepository();
        $this->rSaleAmortization = new SaleAmortizationRepository();
        $this->rScheduleSale = new ScheduleSaleRepository();
        $this->rScheduleSaleDetail = new ScheduleSaleDetailRepository();
        $this->rPurchase = new PurchaseRepository();
        $this->rBooking = new BookingRepository();
    }

    public function checkMoneyBox()
    {
        $checkbox = $this->rMoneyBox->checkBox();

        return response()->json($checkbox);
    }

    public function informationOpening(){
        $date = date('Y-m-d');
        $moneybox = $this->rMoneyBox->getBoxOpening();
        $summary_paymethods = $this->rMoneyBox->summaryPayMethod($moneybox);

        $response = array(
            'status' => 'success',
            'date' => $date,
            'user' => auth()->user(),
            'moneybox' => $moneybox,
            'summary_paymethods' => $summary_paymethods,

//            'detail' => $sale_detail,
//            'movements' => $movements
        );
        return response()->json($response);

    }

    public function openbox(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();

            $item = $this->rMoneyBox->openbox($data);

            // create register money movement
            $this->rMoneyMovement->createMovementOpenBox($item);

            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function closebox(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $moneybox = $data['moneybox'];
            $item = $this->rMoneyBox->closebox($moneybox);

            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function concepIncomes(){
        $query = $this->rMoneyConcept->allConceptIncomes();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function listMoneyMovements(Request $request)
    {
        $query = $this->rMoneyMovement->listMoneyMovements($request);
        return response()->json($query);
    }

    public function listIncome(Request $request)
    {
        $query = $this->rMoneyMovement->listIncome($request);
        return response()->json($query);
    }

    public function saveIncome(Request $request){

        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $data_income = $data['income'];
            $moneybox = $this->rMoneyBox->getBoxMoney();

            $data_income['moneybox_id'] = $moneybox->id;

            $income = $this->rMoneyMovement->saveIncome($data_income);

            if ($income['paymentmethod_id'] == config('app.paymethod_cash')) {
                $this->rMoneyBox->sumAmount($moneybox, $income['amount']);
            }

            $response = array(
                'status' => 'success',
                'data' => $income
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function saveAmortizationBooking(Request $request){

        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $data_income = $data['income'];
            $moneybox = $this->rMoneyBox->getBoxMoney();

            $data_income['moneybox_id'] = $moneybox->id;

            $income = $this->rMoneyMovement->saveAmortizationBooking($data_income);

            if ($income['paymentmethod_id'] == config('app.paymethod_cash')) {
                $this->rMoneyBox->sumAmount($moneybox, $income['amount']);
            }

            // update booking data
            $booking = $this->rBooking->find($data_income['booking_id']);
            $difference_paid = $booking->total_paid + $data_income['amount'];
            $booking->total_paid = $difference_paid;
            $booking->save();

            $response = array(
                'status' => 'success',
                'data' => $income
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function concepExpenses(){
        $query = $this->rMoneyConcept->allConceptExpenses();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function listExpense(Request $request)
    {
        $query = $this->rMoneyMovement->listExpense($request);
        return response()->json($query);
    }

    public function listHistoryMoneyBox(Request $request)
    {
        $query = $this->rMoneyBox->listHistoryMoneyBox($request);
        return response()->json($query);
    }

    public function saveExpense(Request $request){

        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $data_expense = $data['expense'];
            $moneybox = $this->rMoneyBox->getBoxMoney();

            $data_expense['moneybox_id'] = $moneybox->id;

            if ($data_expense['paymentmethod_id'] == config('app.paymethod_cash')) {
                $this->rMoneyBox->substractAmount($moneybox, $data_expense['amount']);
            }

            $expense = $this->rMoneyMovement->saveExpense($data_expense);

            $response = array(
                'status' => 'success',
                'data' => $expense
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function listCharge(Request $request)
    {
        $query = $this->rSale->listCharge($request);

//        $arr_order = $query['results'];
//        usort($arr_order, function($a, $b) {
//            return strtotime($a["nextdateschedule"]) - strtotime($b["nextdateschedule"]);
//        });
//        $query['results'] = $arr_order;

        return response()->json($query);
    }

    public function listPendingPayments(Request $request)
    {
        $query = $this->rPurchase->listPendingPayments($request);

//        $arr_order = $query['results'];
//        usort($arr_order, function($a, $b) {
//            return strtotime($a["nextdateschedule"]) - strtotime($b["nextdateschedule"]);
//        });
//        $query['results'] = $arr_order;

        return response()->json($query);
    }

    public function detailCharge($sale_id)
    {
        $sale = $this->rSale->findSaleJoinedSalePaid($sale_id);
        $schedule = $this->rScheduleSale->findBySale($sale_id);
        $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($schedule['id']);
        $movements = $this->rSalePaid->getMovementBySale($sale_id);

        $result = array(
            'sale' => $sale,
            'schedule' => $schedule,
            'schedule_detail' => $schedule_detail,
            'movements'=>$movements
        );

        $response = array(
            'status' => 'success',
            'data' => $result
        );
        return response()->json($response);
    }

    public function amotizationCharge(Request $request){
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $data_paid = $data['paid'];
            $data_schedule = $data['schedule'];

            $moneybox = $this->rMoneyBox->getBoxMoney();
            $data_paid['moneybox_id'] = $moneybox->id;

            $sale = $this->rSale->findSaleJoinedSalePaid($data_paid['sale_id']);

            $temp_total_paid = $data_paid['amount'] + $sale['total_paid'];

            if($temp_total_paid > $sale['total_amount']){
                throw new \ErrorException('Con el monto ingresado sobrepasa el saldo restante de pago.');
            }else{
                $sale_paid = $this->rSalePaid->find($sale['salepaid_id']);
                $sale_paid->total_paid = $temp_total_paid;
                $sale_paid->save();
            }


            $movement = $this->rMoneyMovement->saveAmortizationCharge($data_paid);

            // create amortization sale
            $arr_amortization = array();
            $arr_amortization['salepaid_id'] = $sale['salepaid_id'];
            $arr_amortization['moneymovement_id'] = $movement['id'];
            $arr_amortization['total_amount'] = $movement['amount'];

            $saleamortization = $this->rSaleAmortization->create($arr_amortization);

            if($data_schedule != 'null'){
                $schedule_detail = $this->rScheduleSaleDetail->findBySchedule($data_schedule['id']);
                $total_paid = $movement['amount'];

                foreach ($schedule_detail as $detail){
                    $item = $this->rScheduleSaleDetail->find($detail['id']);
                    if(!$item['is_paid']){

                        if($total_paid >= $item['amount_assigned']){
                            $diff = $item['amount_assigned'] - $item['amount_paid'];
                            $item->amount_paid = $item['amount_assigned'];
                            $item->date_paid = date('Y-m-d');
                            $item->is_paid = true;

                            $total_paid = $total_paid - $diff;
                        }else{
                            $item->amount_paid = $total_paid + $item['amount_paid'];
                            $item->date_paid = date('Y-m-d');
                            $total_paid = 0;
                        }

                        $item->saleamortization_id = $saleamortization['id'];
                        $item->save();
                    }
                }

            }


            if($movement['paymentmethod_id'] == config('app.paymethod_cash')){
                $this->rMoneyBox->sumAmount($moneybox, $movement['amount']);
            }

            $response = array(
                'status' => 'success',
                'data' => $movement
            );

            DB::connection('tenant')->commit();

            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function edit($id)
    {
        $movement = $this->rMoneyMovement->findJoined($id);

        $response = array(
            'status' => 'success',
            'data'=> $movement
        );

        return response()->json($response);
    }

    public function updateExpense(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $data_expense = $data['expense'];

            $last_expense = $this->rMoneyMovement->find($id);

            $expense = $this->rMoneyMovement->updatedExpense($id, $data_expense);

            if($this->utilHelper->strToBooleanValue($data_expense['available_edit']) == true){
                if($this->utilHelper->strToBooleanValue($data_expense['change_amount']) == true) {
                    if ($data_expense['paymentmethod_id'] == config('app.paymethod_cash')) {

                        // first return amount
                        $moneybox = $this->rMoneyBox->getBoxMoney();
                        $this->rMoneyBox->sumAmount($moneybox, $last_expense['amount']);

                        // after substract amount update
                        $moneybox = $this->rMoneyBox->getBoxMoney();
                        $this->rMoneyBox->substractAmount($moneybox, $data_expense['amount']);
                    }

                    $expense->amount = $data_expense['amount'];
                    $expense->save();
                }
            }

            $response = array(
                'status' => 'success',
                'data' => $expense
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function updateIncome(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $data_income = $data['income'];

            $last_income = $this->rMoneyMovement->find($id);

            $income = $this->rMoneyMovement->updatedIncome($id, $data_income);

            if($this->utilHelper->strToBooleanValue($data_income['available_edit']) == true){
                if($this->utilHelper->strToBooleanValue($data_income['change_amount']) == true){
                    if ($data_income['paymentmethod_id'] == config('app.paymethod_cash')) {

                        // first sum amount
                        $moneybox = $this->rMoneyBox->getBoxMoney();
                        $this->rMoneyBox->sumAmount($moneybox, $data_income['amount']);

                        // after substract last amount update
                        $moneybox = $this->rMoneyBox->getBoxMoney();
                        $this->rMoneyBox->substractAmount($moneybox, $last_income['amount']);
                    }
                    $income->amount = $data_income['amount'];
                    $income->save();
                }
            }

            $response = array(
                'status' => 'success',
                'data' => $income
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function destroyExpense($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {

            $expense = $this->rMoneyMovement->deleted($id);
//            $expense = $this->rMoneyMovement->find($id)->toArray();
//            $expense['motive_cancelled'] = 'Anulación recibo de egreso';
//            $expense['movement_id'] = $id;
//            $cancelled = $this->rMoneyMovement->cancelledVoucher($expense);

            if ($expense['paymentmethod_id'] == config('app.paymethod_cash')) {
                // first return amount
                $moneybox = $this->rMoneyBox->getBoxMoney();
                $this->rMoneyBox->sumAmount($moneybox, $expense['amount']);
            }

            // create movement cancelled
//            $cancelled['repaymentmovement_id'] = $cancelled['id'];
//            $movement_repayment = $this->rMoneyMovement->createRepaymentMovement($cancelled);

            $response = array(
                'status' => 'success',
//                'data' => $movement_repayment
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function destroyIncome($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $income = $this->rMoneyMovement->deleted($id);

            if ($income['paymentmethod_id'] == config('app.paymethod_cash')) {
                // first return amount
                $moneybox = $this->rMoneyBox->getBoxMoney();
                $this->rMoneyBox->substractAmount($moneybox, $income['amount']);
            }

            $response = array(
                'status' => 'success'
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

}
