<?php

namespace App\Http\Controllers\Api\Purchase;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Purchase\Provider\ProviderRepository;
use App\Models\Tenant\Ubigeo\Department\DepartmentRepository;
use App\Models\Tenant\Ubigeo\District\DistrictRepository;
use App\Models\Tenant\Ubigeo\Province\ProvinceRepository;
use App\Models\Tenant\Ubigeo\UbigeoDetail\UbigeoDetailRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProviderApiController extends Controller
{
    protected $utilHelper;

    protected $rProvider;
    protected $rUbigeoDepartment;
    protected $rUbigeoProvince;
    protected $rUbigeoDistrict;
    protected $rUbigeoDetail;

    public function __construct()
    {
        $this->rProvider = new ProviderRepository();
        $this->utilHelper = new UtilHelper();

        $this->rUbigeoDepartment = new DepartmentRepository();
        $this->rUbigeoProvince = new ProvinceRepository();
        $this->rUbigeoDistrict = new DistrictRepository();
        $this->rUbigeoDetail = new UbigeoDetailRepository();
    }


    public function index(Request $request)
    {
        $model = $this->rProvider->model();
        $query = $this->utilHelper->paginate($model, $request);
        return response()->json($query);
    }

    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $item = $this->rProvider->create($data);

            // add ubigeo detail
            $data['provider_id'] = $item->id;
            $data['is_required_ubigeo'] = $data['is_required_ubigeo'] === 'true' ? true : false;
            if ($data['is_required_ubigeo']) {
                $this->rUbigeoDetail->createUbigeoProvider($data);
            }

            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();

            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $item = $this->rProvider->find($id);

        // get ubigeo data
        $ubigeo_detail = $this->rUbigeoDetail->findUbigeoProvider($item->id);

        $ubigeo = false;

        if ($ubigeo_detail) {
            $ubigeo = array(
                'department_id' => $ubigeo_detail->department_id,
                'province_id' => $ubigeo_detail->province_id,
                'district_id' => $ubigeo_detail->district_id,
                'departments' => $this->rUbigeoDepartment->all(),
                'provinces' => $this->rUbigeoProvince->allByDepartment($ubigeo_detail->department_id),
                'districts' => $this->rUbigeoDistrict->allByProvince($ubigeo_detail->province_id),
            );

        }

        $response = array(
            'status' => 'success',
            'ubigeo' => $ubigeo,
            'data' => $item
        );
        return response()->json($response);
    }


    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $attributes = $request->all();
            $item = $this->rProvider->updated($id, $attributes);

            // update ubigeo
            $attributes['provider_id'] = $item->id;
            $attributes['is_required_ubigeo'] = $attributes['is_required_ubigeo'] === 'true' ? true : false;

            if ($attributes['is_required_ubigeo']) {
                $this->rUbigeoDetail->updatedUbigeoProvider($attributes);
            }

            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function destroy($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $this->rProvider->deleted($id);
            $response = array(
                'status' => 'success'
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function searchAngucomplete(Request $request)
    {
        $text_search = $request->get('search');
        $item = $this->rProvider->search($text_search);

        $response = array(
            'incomplete_results' => false,
            'items' => $item,
            'total_count' => count($item));

        return response()->json($response);
    }
}
