<?php

namespace App\Http\Controllers\Api\Purchase;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductBatch\ProductBatchRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Catalog\ProductStock\ProductStockRepository;
use App\Models\Tenant\Money\MoneyBox\MoneyBoxRepository;
use App\Models\Tenant\Money\Movement\MovementRepository;
use App\Models\Tenant\Purchase\Purchase\PurchaseRepository;
use App\Models\Tenant\Purchase\PurchaseDetail\PurchaseDetailRepository;
use App\Models\Tenant\Purchase\PurchasePaid\PurchasePaidRepository;
use App\Models\Tenant\Purchase\SchedulePurchase\SchedulePurchaseRepository;
use App\Models\Tenant\Purchase\SchedulePurchaseDetail\SchedulePurchaseDetailRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PurchaseApiController extends Controller
{
    protected $utilHelper;
    protected $rPurchase;
    protected $rPurchaseDetail;
    protected $rProduct;
    protected $rProductStock;
    protected $rProductEquivalence;
    protected $rPurchasePaid;
    protected $rProductBatch;
    protected $rMoneyBox;
    protected $rMoneyMovement;
    protected $rSchedulePurchase;
    protected $rSchedulePurchaseDetail;

    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rPurchase = new PurchaseRepository();
        $this->rPurchaseDetail = new PurchaseDetailRepository();
        $this->rProduct = new ProductRepository();
        $this->rProductStock = new ProductStockRepository();
        $this->rProductEquivalence = new ProductEquivalenceRepository();
        $this->rPurchasePaid = new PurchasePaidRepository();
        $this->rProductBatch = new ProductBatchRepository();
        $this->rMoneyBox = new MoneyBoxRepository();
        $this->rMoneyMovement = new MovementRepository();
        $this->rSchedulePurchase = new SchedulePurchaseRepository();
        $this->rSchedulePurchaseDetail = new SchedulePurchaseDetailRepository();
    }


    public function index(Request $request)
    {
        $query = $this->rPurchase->listPurchase($request);
        return response()->json($query);
    }



    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $purchase_data = $request->get('purchase');
            $detail_data = $request->get('detail');

            $purchase = $this->rPurchase->create($purchase_data);

            $total_purchase = $purchase['total'];

            foreach ($detail_data as $detail) {
                $detail['purchase_id'] = $purchase['id'];
                $detail['product_id'] = $detail['id'];
                $detail['warehouse_id'] = $purchase['warehouse_id'];
                $detail_purchase = $this->rPurchaseDetail->create($detail);

                // check if price is unit
                $stock = $detail['quantity'];
                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $stock = $equivalence['equivalence']*$detail['quantity'];

                    $detail_purchase->equivalence = $equivalence['equivalence'];
                    $detail_purchase->save();

                    // set unit in product stock
                    $principal_equivalence = $this->rProductEquivalence->findPrincipalMeasureByProduct($detail['product_id']);
                    $detail['unit_id'] = $principal_equivalence['unit_id'];
                }

                // update stock product
                $detail['quantity'] = $stock;
                $detail['stock'] = $stock;
                $this->rProductStock->updatedStockByWarehouse($detail['product_id'],$detail);

                if($this->utilHelper->strToBooleanValue($detail['check_date_expiration'])){
                    $batch_product = $this->rProductBatch->checkBatchProduct($detail);
                    $detail_purchase->productbatch_id = $batch_product['id'];
                    $detail_purchase->save();
                }

                // update control stock product
                $this->rProduct->setIsControlStock($detail['product_id']);
            }

            // sale  paid =======
            $arr_purchasepaid= array();
            $arr_purchasepaid['purchase_id'] = $purchase['id'];
            $arr_purchasepaid['total_amount'] = $purchase['total'];
            $arr_purchasepaid['total_paid'] = $purchase['total'];
            $purchasepaid = $this->rPurchasePaid->create($arr_purchasepaid);

            if ($purchase['typetransaction_id'] == config('app.transaction_cash')) {
                // if affect_money_box
                if ($purchase_data['paymentmethod_id'] == config('app.paymethod_cash')) {
                    if ($this->utilHelper->strToBooleanValue($purchase['affect_moneybox']) == true) {
                        $moneybox = $this->rMoneyBox->getBoxMoney();
                        $this->rMoneyBox->substractAmount($moneybox, $purchase['total']);

                        // create movement for purchase
                        $purchase['moneybox_id'] = $moneybox->id;
                        $this->rMoneyMovement->createPurchaseMovement($purchase);
                    }
                }

            } else if ($purchase['typetransaction_id'] == config('app.transaction_credit')) {
                $schedule_data = $request->get('schedule');
                $schedule_data['purchase_id'] = $purchase['id'];

                // create schedule
                $schedule = $this->rSchedulePurchase->create($schedule_data);

                // detail schedule
                $date_assigned = $schedule_data['first_date_schedule'];
//                $amount_assigned = number_format($total_sale/$schedule_data['number_quota'], 2);
                $amount_assigned = round($total_purchase / $schedule_data['number_quota'], 2);

                for ($i = 1; $i <= (int)$schedule_data['number_quota']; $i++) {
                    $detail_schedule = array();

                    $detail_schedule['date_assigned'] = $date_assigned;
                    $detail_schedule['number_quota'] = $i;
                    $detail_schedule['amount_assigned'] = $amount_assigned;
                    $detail_schedule['purchaseschedule_id'] = $schedule['id'];
                    $this->rSchedulePurchaseDetail->create($detail_schedule);

                    $date_assigned = strtotime('+' . $schedule_data['interval_schedule'] . ' days', strtotime($date_assigned));
                    $date_assigned = date('Y-m-d', $date_assigned);
                }

                $purchasepaid->total_paid = 0;
                $purchasepaid->save();
            }

            $response = array(
                'status' => 'success',
                'data' => $purchase
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }


    public function detail($id)
    {
        $purchase = $this->rPurchase->find($id);
        $order_detail = $this->rPurchaseDetail->findByPurchaseIdJoined($id);

        $result = array(
            'purchase' => $purchase,
            'detail' => $order_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }


    public function destroy($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {

            $detail_purchase = $this->rPurchaseDetail->findByPurchaseIdJoined($id);
            foreach ($detail_purchase as $detail) {
                $product = $this->rProduct->find($detail['product_id']);

                $detail['stock'] = $detail['quantity'];

                if($product['typeprice_id'] == config('app.catalog_price_unit') ){
                    $detail['quantity'] = $detail['quantity'] * $detail['equivalence'];
                    $detail['stock'] = $detail['quantity'];
                }

                // substract product batch
                if($detail['productbatch_id'] != null){
                    $this->rProductBatch->substractBatchProduct($detail['productbatch_id'], $detail);
                }


                // update stock product
                $this->rProductStock->substractStockByWarehouse($detail['product_id'],$detail);
            }

            $this->rPurchase->deleted($id);


            $response = array(
                'status' => 'success'
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }
}
