<?php

namespace App\Http\Controllers\Api\Purchase;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Purchase\OrderDetailPurchase\OrderDetailPurchaseRepository;
use App\Models\Tenant\Purchase\OrderPurchase\OrderPurchaseRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PurchaseOrderApiController extends Controller
{

    protected $utilHelper;
    protected $rOrderPurchase;
    protected $rOrderDetailPurchase;
    protected $rProduct;
    protected $rProductEquivalence;


    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rOrderPurchase = new OrderPurchaseRepository();
        $this->rOrderDetailPurchase = new OrderDetailPurchaseRepository();
        $this->rProduct = new ProductRepository();
        $this->rProductEquivalence = new ProductEquivalenceRepository();
    }


    public function index(Request $request)
    {
        $query = $this->rOrderPurchase->listOrder($request);
        return response()->json($query);
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $order_data = $request->get('order');
            $detail_data = $request->get('detail');

            $order = $this->rOrderPurchase->create($order_data);

            foreach ($detail_data as $detail) {
                $detail['order_id'] = $order['id'];
                $detail['product_id'] = $detail['id'];
                $detail['equivalence'] = null;

                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $detail['equivalence'] =  $equivalence['equivalence'];
                }

                $this->rOrderDetailPurchase->create($detail);
            }

            $response = array(
                'status' => 'success',
                'data' => $order
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $order = $this->rOrderPurchase->findJoined($id);
        $order_detail = $this->rProduct->findByJoinedOrderDetail($id);

        $result = array(
            'order' => $order,
            'detail' => $order_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }


    public function detail($id)
    {

        $order = $this->rOrderPurchase->findJoined($id);
        $order_detail = $this->rOrderDetailPurchase->findByOrderIdJoined($id);

        $result = array(
            'order' => $order,
            'detail' => $order_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }

    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $order_data = $request->get('order');
            $detail_order_data = $request->get('detail');

            $order = $this->rOrderPurchase->updated($id, $order_data);

            // delete pass history orderdetail
            $detail_pass = $this->rOrderDetailPurchase->findByOrderId($order['id']);

            foreach ($detail_pass as $item) {
                $this->rOrderDetailPurchase->deleted($item->id);
            }


            foreach ($detail_order_data as $item) {
                $detail = $this->rOrderDetailPurchase->findByOrderIdAndProductId($order['id'], $item['id']);

                $item['equivalence'] = null;

                if ($item['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($item['id'], $item['unit_id']);
                    $item['equivalence'] =  $equivalence['equivalence'];
                }

                if($detail == null){
                    $item['order_id'] = $order['id'];
                    $item['product_id'] = $item['id'];
                    $this->rOrderDetailPurchase->create($item);
                } else {
                    $this->rOrderDetailPurchase->updated($detail['id'], $item);
                }
            }

            $response = array(
                'status' => 'success',
                'data' => $order
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function destroy($id)
    {
        //
    }
}
