<?php

namespace App\Http\Controllers\Api\Report;

use App\Core\TenantCore;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Money\Movement\MovementRepository;
use Illuminate\Http\Request;

class BillingReportController extends Controller
{
    protected $rMoneyMovement;
    protected $tenant;

    public function __construct()
    {
        $this->rMoneyMovement = new MovementRepository();
        $this->tenant = new TenantCore();
    }

    public function exportVouchers(Request $request)
    {
        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        if ($format == config('app.export_format_pdf')) {

            $cols = $this->get_columns_voucher($parameters);
            $rows = $this->get_rows_voucher($parameters);

//            dd($cols, $rows);

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
//            $pdf->SetTitle("REPORTE DE VENTAS {$subtitle}", 11);
//            $pdf->SetY(20);
            $pdf->SetTitle("REPORTE DE COMPROBANTES", 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $separetor_coluns = 5;
            $h_row = 3.5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();

            // subtitle dates  date("d M Y");

            $pdf->SetFont('Arial','',11);
            $pdf->SetY(13);
            $pdf->SetWidths(array(195));
            $pdf->Row(array('Desde el '.date("d M Y", strtotime($parameters['start_range'])).'   al  '.date("d M Y", strtotime($parameters['end_range']))), array("C"), "N","Y");

            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            // imprimir las filas de la tabla
            if( ! empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY(42);

                $pdf->SetFont('Arial','B',9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach($rows as $row) {
                    $pdf->SetFont('Arial','',7);
                    $values = array();
                    $bg_row = array();
                    foreach($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    if($row->status == 'Anulado'){
//                        $pdf->SetDrawColor(160, 160, 160);
                        $bg_row = array(246, 222, 222);
                    }

                    $pdf->SetFillColor(246, 222, 222);

                    $total = $total + $row->amount;
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont("Arial", "B", 8);
                $pdf->SetWidths(array(181, 20));
                $pdf->Row(array("TOTAL", number_format($total,2,".","'")), array("R", "R"));
            }

            $pdf->Output();
            exit;


        }
    }


    protected function get_columns_voucher()
    {
        return array(
            "date_movement" => array("col" => "A", "label" => "Fecha", "pos" => "C", "width" => 18)
        , "typevoucher" => array("col" => "B", "label" => "Tipo Comprobante", "pos" => "C", "width" => 35)
        , "nro_voucher" => array("col" => "C", "label" => utf8_decode("N° voucher"), "pos" => "C", "width" => 25)
        , "client_document" => array("col" => "D", "label" => utf8_decode("DNI/RUC"), "pos" => "C", "width" => 25)
        , "client" => array("col" => "E", "label" => "Cliente", "pos" => "L", "width" => 63)
        , "status" => array("col" => "F", "label" => "Estado", "pos" => "C", "width" => 15)
        , "amount" => array("col" => "G", "label" => "Total", "pos" => "R", "width" => 20)
        );
    }

    protected function get_rows_voucher($parameters){
        $rows = $this->rMoneyMovement->rowExportVouchers($parameters);
        return $rows;
    }
}
