<?php

namespace App\Http\Controllers\Api\Report;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Brand\BrandRepository;
use App\Models\Tenant\Catalog\Category\CategoryRepository;
use App\Models\Tenant\Catalog\Line\LineRepository;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Warehouse\Warehouse\WarehouseRepository;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class CatalogReportController extends Controller
{
    protected $tenant;
    protected $rProduct;
    protected $rWarehouse;
    protected $utilHelper;

    protected $rCategory;
    protected $rLine;
    protected $rBrand;

    public function __construct()
    {
        $this->tenant = new TenantCore();
        $this->rProduct = new ProductRepository();
        $this->rWarehouse = new WarehouseRepository();
        $this->utilHelper = new UtilHelper();
        $this->rCategory = new CategoryRepository();
        $this->rLine = new LineRepository();
        $this->rBrand = new BrandRepository();
    }

    public function stockProduct(Request $request){
        $item = $this->rProduct->stockProduct($request);
        return response()->json($item);
    }

    public function stockProductExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "description_product" => array("col" => "A", "label" => utf8_decode("Producto"), "pos" => "L", "width" => 110)
        , "brand" => array("col" => "B", "label" => "Marca", "pos" => "C", "width" => 20)
        , "line" => array("col" => "C", "label" => "Linea", "pos" => "C", "width" => 20)
        , "unitmeasure" => array("col" => "D", "label" => "Medida", "pos" => "C", "width" => 20)
        , "stock" => array("col" => "E", "label" => "Stock", "pos" => "C", "width" => 30)
        );

        $rows = $this->rProduct->stockProduct($request, true);
        $rows = $rows['results'];

        if ($format == config('app.export_format_excel')) {
            $subtitle = "";

            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', "STOCK DE PRODUCTOS - ALMACEN {$this->rWarehouse->find($parameters['warehouse'])['description']}");
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));


            $y = 4;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                foreach ($rows as $row) {
                    $y++;

                    $row['description_product'] = $row['description']."\n".$row['code'];
                    $row['unitmeasure'] = $row['productstock'][0]['unidad_plural'];
                    $row['stock'] = $row['productstock'][0]['stock']." ".$row['productstock'][0]['unitprefix'];

                    foreach ($cols as $key => $val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }
                }
            }

            $filename='stock_productos-'.date("dmYhi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle(utf8_decode("STOCK DE PRODUCTOS"), 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();

            $pdf->SetFont('Arial', '', 11);
            $pdf->SetY(13);
            $pdf->SetWidths(array(195));
            $pdf->Row(array(utf8_decode('Almacén : ').$this->rWarehouse->find($parameters['warehouse'])['description']), array("C"), "N", "Y");

            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            // imprimir las filas de la tabla
            if (!empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N", "Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY(42);

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(4);
                $pdf->SetFillColor(255, 255, 255);
                foreach ($rows as $row) {
                    $pdf->SetFont('Arial', '', 7);
                    $values = array();
                    $bg_row = array();

                    $row['description_product'] = $row['description']."\n".$row['code'];
                    $row['unitmeasure'] = $row['productstock'][0]['unidad_plural'];
                    $row['stock'] = $row['productstock'][0]['stock']." ".$row['productstock'][0]['unitprefix'];

                    foreach ($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }
            }

            $pdf->Output();
            exit;

        }

    }

    public function catalogServices(Request $request){
        $item = $this->rProduct->listServices($request);
        return response()->json($item);
    }

    public function catalogServicesExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "code" => array("col" => "A", "label" => "CODIGO SERVICIO", "pos" => "C", "width" => 40)
        ,"description" => array("col" => "B", "label" =>"DESCRIPCION", "pos" => "C", "width" => 80)
        ,"price_sale" => array("col" => "C", "label" => "PRECIO GENERAL", "pos" => "C", "width" => 40)
        );

        $rows =  $this->rProduct->listServices($request, true);
        $rows =  $rows['results'];


        if ($format == config('app.export_format_excel')) {


            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', "REPORTE CATALOGO DE SERVICIOS");
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));


            $y = 4;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                foreach($rows as $row) {
                    $y ++;
                    foreach($cols as $key=>$val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }
                }
                $y++;
            }

            $filename='catalogo_servicios-'.date("dmYhi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle(utf8_decode("REPORTE CATALOGO DE SERVICIOS"), 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();


            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            if( ! empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode("N° RUC :"), $company->ruc), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetFont('Arial','B',9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach($rows as $row) {
                    $pdf->SetFont('Arial','',7);
                    $values = array();
                    $bg_row = array();

                    foreach($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->SetFillColor(246, 222, 222);
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }
            }

            $pdf->Output();
            exit;

        }

    }

    public function catalogProducts(Request $request){
        $item = $this->rProduct->listBienes($request);
        return response()->json($item);
    }

    public function catalogProductsExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "code" => array("col" => "A", "label" => utf8_decode("Producto"), "pos" => "L", "width" => 20)
        ,"description_product" => array("col" => "B", "label" => utf8_decode("Producto"), "pos" => "L", "width" => 100)
        , "brand" => array("col" => "C", "label" => "Marca", "pos" => "C", "width" => 20)
        , "line" => array("col" => "D", "label" => "Linea", "pos" => "C", "width" => 20)
        , "unitmeasure" => array("col" => "E", "label" => "Medida", "pos" => "C", "width" => 20)
        , "price_sale" => array("col" => "F", "label" => "Precio V.", "pos" => "C", "width" => 20)
        // , "price_purchase" => array("col" => "G", "label" => "P.pro.Com.", "pos" => "C", "width" => 20)
        );

        $rows = $this->rProduct->listBienes($request, true);
        $rows = $rows['results'];

        if ($format == config('app.export_format_excel')) {
            $subtitle = "";

            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', "REPORTE CATALOGO DE BIENES");
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));


            $y = 4;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                foreach ($rows as $row) {
                    $y++;

                    $row['description_product'] = $row['description'];
                    // $row['unitmeasure'] = $row['productstock'][0]['unidad_plural'];

                    if($row['productstockinreport'] != null){
                        // dd($row->toArray());
                        $row['unitmeasure'] = $row['productstockinreport'][0]['unidad_plural'];
                    }else{
                        $row['unitmeasure'] = '';
                    }

                    foreach ($cols as $key => $val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }
                }
            }

            $filename='catalogo_bienes-'.date("dmYhi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle(utf8_decode("REPORTE CATALOGO DE BIENES"), 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();

            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            // imprimir las filas de la tabla
            if (!empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode("N° RUC :"), $company->ruc), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(4);
                $pdf->SetFillColor(255, 255, 255);
                foreach ($rows as $row) {
                    $pdf->SetFont('Arial', '', 7);
                    $values = array();
                    $bg_row = array();

                    // if($row['id'] == 951){
                    //     dd($row['productstock'][0]);
                    // }

                    $row['description_product'] = $row['description'];

                    if($row['productstockinreport'] != null){
                        // dd($row->toArray());
                        $row['unitmeasure'] = $row['productstockinreport'][0]['unidad_plural'];
                    }else{
                        $row['unitmeasure'] = '';
                    }
                    
                    foreach ($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont('Arial','B',8);
                $pdf->SetWidths(array(14, 50));
                $pdf->SetHeight(10);
                $pdf->Row(array(utf8_decode('N° Total:'), count($rows)." registros"), array("L"), "N", "Y");
            }

            $pdf->Output();
            exit;

        }

    }

    public function catalogCategories(Request $request){
        $item = $this->rCategory->listCategories($request);
        return response()->json($item);
    }

    public function catalogCategoriesExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
         "description" => array("col" => "A", "label" =>"NOMBRE CATEGORIA", "pos" => "C", "width" => 80)
         ,"quantity_products" => array("col" => "B", "label" => utf8_decode("# PRODUCTOS ASIGNADOS"), "pos" => "C", "width" => 80)
        );

        $rows =  $this->rCategory->listCategories($request, true);
        $rows =  $rows['results'];


        if ($format == config('app.export_format_excel')) {


            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', "REPORTE CATALOGO DE CATEGORIAS");
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));
            $excel->getActiveSheet()->setCellValue('A3', "# Total: ".count($rows)." registros");

            $y = 5;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                foreach($rows as $row) {
                    $y ++;
                    foreach($cols as $key=>$val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }
                }
                $y++;
            }



            $filename='catalogo_categorias-'.date("dmYhi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle(utf8_decode("REPORTE CATALOGO DE CATEGORIAS"), 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();


            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            if( ! empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode("N° RUC :"), $company->ruc), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetFont('Arial','B',9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach($rows as $row) {
                    $pdf->SetFont('Arial','',7);
                    $values = array();
                    $bg_row = array();

                    foreach($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->SetFillColor(246, 222, 222);
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont('Arial','B',8);
                $pdf->SetWidths(array(14, 50));
                $pdf->SetHeight(10);
                $pdf->Row(array(utf8_decode('N° Total:'), count($rows)." registros"), array("L"), "N", "Y");
            }

            $pdf->Output();
            exit;

        }

    }

    public function catalogLines(Request $request){
        $item = $this->rLine->listLines($request);
        return response()->json($item);
    }

    public function catalogLinesExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "description" => array("col" => "A", "label" => "NOMBRE LINEA", "pos" => "C", "width" => 60)
        , "category_description" => array("col" => "A", "label" => "CATEGORIA", "pos" => "C", "width" => 60)
        , "quantity_products" => array("col" => "B", "label" => utf8_decode("# PRODUCTOS ASIGNADOS"), "pos" => "C", "width" => 80)
        );

        $rows =  $this->rLine->listLines($request, true);
        $rows =  $rows['results'];


        if ($format == config('app.export_format_excel')) {


            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', "REPORTE CATALOGO DE LINEAS");
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));
            $excel->getActiveSheet()->setCellValue('A3', "# Total: ".count($rows)." registros");

            $y = 5;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                foreach($rows as $row) {
                    $y ++;
                    foreach($cols as $key=>$val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }
                }
                $y++;
            }

            $filename='catalogo_lineas-'.date("dmYhi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle(utf8_decode("REPORTE CATALOGO DE LINEAS"), 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();


            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            if( ! empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode("N° RUC :"), $company->ruc), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetFont('Arial','B',9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach($rows as $row) {
                    $pdf->SetFont('Arial','',7);
                    $values = array();
                    $bg_row = array();

                    foreach($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->SetFillColor(246, 222, 222);
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont('Arial','B',8);
                $pdf->SetWidths(array(14, 50));
                $pdf->SetHeight(10);
                $pdf->Row(array(utf8_decode('N° Total:'), count($rows)." registros"), array("L"), "N", "Y");
            }

            $pdf->Output();
            exit;

        }

    }

    public function catalogBrands(Request $request){
        $item = $this->rBrand->listBrands($request);
        return response()->json($item);
    }

    public function catalogBrandsExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "description" => array("col" => "A", "label" =>"NOMBRE MARCA", "pos" => "C", "width" => 80)
        ,"quantity_products" => array("col" => "B", "label" => utf8_decode("# PRODUCTOS ASIGNADOS"), "pos" => "C", "width" => 80)
        );

        $rows =  $this->rBrand->listBrands($request, true);
        $rows =  $rows['results'];


        if ($format == config('app.export_format_excel')) {


            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', "REPORTE CATALOGO DE MARCAS");
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));
            $excel->getActiveSheet()->setCellValue('A3', "# Total: ".count($rows)." registros");

            $y = 5;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                foreach($rows as $row) {
                    $y ++;
                    foreach($cols as $key=>$val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }
                }
                $y++;
            }



            $filename='catalogo_marcas-'.date("dmYhi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle(utf8_decode("REPORTE CATALOGO DE MARCAS"), 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();


            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            if( ! empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode("N° RUC :"), $company->ruc), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetFont('Arial','B',9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach($rows as $row) {
                    $pdf->SetFont('Arial','',7);
                    $values = array();
                    $bg_row = array();

                    foreach($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->SetFillColor(246, 222, 222);
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont('Arial','B',8);
                $pdf->SetWidths(array(14, 50));
                $pdf->SetHeight(10);
                $pdf->Row(array(utf8_decode('N° Total:'), count($rows)." registros"), array("L"), "N", "Y");
            }

            $pdf->Output();
            exit;

        }

    }
}


