<?php

namespace App\Http\Controllers\Api\Report;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Config\TypeVoucher\TypeVoucherRepository;
use App\Models\Tenant\Money\MoneyBox\MoneyBoxRepository;
use App\Models\Tenant\Money\Movement\MovementRepository;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class MoneyReportController extends Controller
{

    protected $tenant;
    protected $rMoneyMovement;
    protected $rMoneyBox;
    protected $rTypeVoucher;

    public function __construct()
    {
        $this->tenant = new TenantCore();
        $this->rMoneyMovement = new MovementRepository();
        $this->rMoneyBox = new MoneyBoxRepository();
        $this->utilHelper = new UtilHelper();
        $this->rTypeVoucher = new TypeVoucherRepository();
    }

    public function arqueo(Request $request, $moneybox_id = null)
    {
        $company = $this->tenant->company();
        $format = $request->get("format");
        $parameters = null;

        if($moneybox_id == null){
            $moneybox = $this->rMoneyBox->getBoxOpening();
        }
        else{
            $moneybox = $this->rMoneyBox->find($moneybox_id);
        }

        // init format impresion
        $cols = $this->get_columns_arqueo();
        $rows = $this->get_rows_arqueo($moneybox);

        if ($format == config('app.impresion_a4')) {

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
//            $pdf->SetTitle("REPORTE DE VENTAS {$subtitle}", 11);
//            $pdf->SetY(20);
            $pdf->SetTitle("ARQUEO DE CAJA CHICA", 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total = 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $separetor_coluns = 5;
            $h_row = 3.5;
            $h_logo = 20;
            $w_logo = 40;

            $pdf->AddPage();

            $pdf->SetFont('Arial', '', 11);
            $pdf->SetY(13);
            $pdf->SetWidths(array(195));
            $pdf->Row(array('Fecha: ' . date("d M Y", strtotime($moneybox->date_opening))), array("C"), "N", "Y");

            $pdf->SetFont('Arial', 'B', 8);
            $pdf->Row(array('Usuario - '.auth()->user()->name), array("C"), "N", "Y");

            // fecha impresión
            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total - 45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el ' . date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total - 40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: ' . date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa != null || $logo_empresa != '') {
                $logo_empresa = "companies/" . $company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            $position_table = 42;

            // imprimir las filas de la tabla
            if (!empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total_income = 0;
                $total_expense = 0;
                $total_credit = 0;

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N", "Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY($position_table);

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(4);
                $pdf->SetFillColor(255, 255, 255);

                foreach ($rows as $row) {

                    $row->concept = $row->concept.', '.$row->gloss;

                    if($row->paymentmethod_id == config("app.paymethod_deposit")){
                        $row->paymentmethod = $row->paymentmethod.' - '.$row->accountbank.' Ope.:'.$row->reference_operation;
                    }

                    $pdf->SetFont('Arial', '', 7);
                    $values = array();
                    $bg_row = array();
                    foreach ($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    if ($row->income != null) {
                        $total_income = $total_income + $row->income;
                    }

                    if ($row->expense != null) {
                        $total_expense = $total_expense + $row->expense;
                    }

                    if ($row->credit != null) {
                        $total_credit = $total_credit + $row->credit;
                    }

                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);

                    $position_table = $position_table + $pdf->GetHeight() + 10;
                }

                $pdf->SetFont("Arial", "B", 8);
                $pdf->SetWidths(array(142, 20, 20, 20));
                $pdf->SetHeight(7);

                $arr_foot = array(
                    "SUMATORIA TOTAL",
                    'S/. '.number_format($total_income, 2, ".", "'"),
                    'S/. '.number_format($total_expense, 2, ".", "'"),
                    'S/. '.number_format($total_credit, 2, ".", "'")

                );

                $pdf->Row($arr_foot,array("R", "R", "R", "R"), "Y");
            }


            // summary by method pay
            $cols_method = $this->get_columns_summary_methodpay();
            $rows_method = $this->rMoneyBox->summaryPayMethodArqueo($moneybox);
            $fields = array_keys($cols_method);
            $pos = array_column($cols_method, "pos");

            $pdf->SetFillColor(245, 245, 245);
            $pdf->SetWidths(array(100));
            $pdf->SetHeight(7);
            $pdf->Row(array(utf8_decode("RESUMEN POR MÉTODOS DE PAGO")),array("C"), "Y", "Y", array(245, 245, 245));

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetFillColor(245, 245, 245);
            $pdf->SetWidths(array_column($cols_method, 'width'));
            $pdf->SetHeight(7);
            $pdf->Row(array_column($cols_method, 'label'), array_fill(0, count($cols_method), "C"), "Y", "Y", array(245, 245, 245));

            $pdf->SetHeight(5);

            $total_transaction = 0;
            $total_income = 0;
            $total_expense = 0;

            foreach ($rows_method as $row) {
                $pdf->SetFont('Arial', '', 7);
                $values = array();
                $bg_row = array();

                foreach ($fields as $field) {
                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                }

                $pdf->Row($values, $pos, "Y", "Y", $bg_row);

                $total_transaction = $total_transaction + $row->transactions;
                $total_income = $total_income + $row->total;
                $total_expense = $total_expense + $row->total_expense;

                $position_table = $position_table + $pdf->GetHeight() + 10;
            }

            $pdf->SetFont("Arial", "B", 8);
            $pdf->SetWidths(array(30, 30, 20, 20));
            $pdf->SetHeight(7);

            $arr_foot = array(
                "TOTAL",
                $total_transaction,
                'S/. '.number_format($total_income, 2, ".", "'"),
                'S/. '.number_format($total_expense, 2, ".", "'")

            );

            $pdf->Row($arr_foot,array("R", "C", "C", "C"), "Y", "N");


            $pdf->SetFont("Arial", "B", 9);
            $pdf->SetX(120);
            $pdf->SetHeight(5);
            $pdf->SetWidths(array(70));

            $pdf->Row(array(utf8_decode("EFECTIVO EN CAJA CHICA: S/ ".$moneybox->balance)),array("L"), "N", "Y");

            $pdf->SetX(120);


            $pdf->SetHeight(30);
            $pdf->SetWidths(array(70));
            $pdf->Row(array(utf8_decode("")),array("L"), "N", "Y");

            $pdf->SetFont("Arial", "B", 10);
            $pdf->SetWidths(array(200));
            $pdf->SetHeight(5);
            $pdf->Row(array(utf8_decode("---------------------------------------------------\nFIRMA RESPONSABLE Y N° DNI")),array("C"), "N", "Y");

            $pdf->Output();
            exit;
        }
        else if($format == config('app.impresion_ticket')){
            $pdf = new \App\Libraries\Pdf();
            $pdf->SetLeftMargin(4);
            $pdf->setFillColor(249, 249, 249);
            $pdf->SetDrawColor(204, 204, 204);

            $ancho_celda_datos = 3.8;
            $h_header = 3;
            $h_logo = 20;
            $h_qr = 35;


//            $alto = $this->getTicketStructure($data, $h_header, $h_logo, $ancho_celda_datos, $h_qr);
            $alto = 210;

            $ancho = 73;
            $espac = 4;

            $margin_side = 2;
            $pdf->SetAutoPageBreak(false);
            $pdf->AddPage('P', array($ancho, $alto));
            $pdf->SetFont('Helvetica', '', 7);
            $pdf->SetFillColor(255, 255, 255);

//            $pdf->SetFont('Helvetica', 'B', 7);
//            $pdf->SetY($espac);
//            $pdf->SetWidths(array(0));
//            $pdf->Row(array('Fecha: ' . date("d M Y", strtotime($moneybox->date_opening))), array("C"), "N", "Y");
//            $espac = $espac +5 ;

            $pdf->SetFont('Helvetica', 'B', 7);

            $pdf->SetY($espac);
            $pdf->SetWidths(array(0));
            $pdf->Row(array('Generado el: ' . date("d M Y")), array("C"), "N", "Y");
            $espac = $espac + 4 ;

            $pdf->SetY($espac);
            $pdf->SetWidths(array(0));
            $pdf->Row(array('Hora: ' . date('H:i:s a ')), array("C"), "N", "Y");

            $espac = $espac + 7 ;

            $pdf->SetY($espac);
            $pdf->SetWidths(array(0));
            $pdf->Row(array('Usuario: '.auth()->user()->name), array("L"), "N", "Y");
            $espac = $espac + 4 ;

//            dd($moneybox->date_opening);

            $pdf->SetY($espac);
            $pdf->SetWidths(array(0));
            $pdf->Row(array('Apertura: '. $moneybox->date_opening), array("L"), "N", "Y");
            $espac = $espac + 4 ;

            $status_box = "ABIERTA";
            if($moneybox->date_closing != null){
                $pdf->SetY($espac);
                $pdf->SetWidths(array(0));
                $pdf->Row(array('Cierre: '.$moneybox->date_closing), array("L"), "N", "Y");
            }
            else{

                $pdf->SetY($espac);
                $pdf->SetWidths(array(0));
                $pdf->Row(array('Estado caja: '.$status_box), array("L"), "N", "Y");
            }


            $espac = $espac + 7;

            $pdf->SetFont('Helvetica', 'B', 9);
            $pdf->SetY($espac);
            $pdf->SetWidths(array(0));
            $pdf->Row(array('MOVIMIENTOS DE CAJA'), array("C"), "N", "Y");

            $position_table = $espac + 7;

            $fields = array_keys($cols);
            $pos = array_column($cols, "pos");
            $total_income = 0;
            $total_expense = 0;
            $total_credit = 0;


            foreach ($rows as $row) {

//                $row->concept = $row->concept.', '.$row->gloss;
//
//                if($row->paymentmethod_id == config("app.paymethod_deposit")){
//                    $row->paymentmethod = $row->paymentmethod.' - '.$row->accountbank.' Ope.:'.$row->reference_operation;
//                }
//
//                $pdf->SetFont('Arial', '', 7);
//                $values = array();
//                $bg_row = array();
//                foreach ($fields as $field) {
//                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
//                }

                if ($row->income != null) {
                    $total_income = $total_income + $row->income;
                }

                if ($row->expense != null) {
                    $total_expense = $total_expense + $row->expense;
                }

                if ($row->credit != null) {
                    $total_credit = $total_credit + $row->credit;
                }

//                $pdf->Row($values, $pos, "Y", "Y", $bg_row);
//
//                $position_table = $position_table + $pdf->GetHeight() + 10;

            }

//            $position_table = $position_table ;

            $pdf->SetFont('Arial', '', 7);

            $pdf->SetY($position_table);
            $pdf->SetWidths(array(30, 35));
            $pdf->Row(array("TOTAL INGRESOS (+):", 'S/. '.number_format($total_income, 2, ".", "'")), array("L","C"), "Y", "Y");
            $position_table = $position_table + 5;
            $pdf->Row(array("TOTAL EGRESOS (-):", 'S/. '.number_format($total_expense, 2, ".", "'")), array("L","C"), "Y", "Y");
            $position_table = $position_table + 5;
            $pdf->Row(array("TOTAL CREDITOS :", 'S/. '.number_format($total_credit, 2, ".", "'")), array("L","C"), "Y", "Y");


            $position_table = $position_table + 10;


            // summary by method pay
            $cols_method = array(
                "description" => array("col" => "A", "label" => utf8_decode("M. de pago"), "pos" => "L", "width" => 25)
            , "total" => array("col" => "C", "label" => "Ingresos", "pos" => "C", "width" => 20)
            , "total_expense" => array("col" => "C", "label" => "Egresos", "pos" => "C", "width" => 20)
            );

            $rows_method = $this->rMoneyBox->summaryPayMethodArqueo($moneybox);
            $fields = array_keys($cols_method);
            $pos = array_column($cols_method, "pos");

            $pdf->SetFont('Helvetica', 'B', 9);
            $pdf->SetY($position_table);
            $pdf->SetWidths(array(0));
            $pdf->Row(array(utf8_decode('RESUMEN POR MÉTODOS DE PAGO')), array("C"), "N", "Y");

            $position_table = $position_table + 8;

            $pdf->SetFont('Helvetica', 'B', 9);
            $pdf->SetY($position_table);
//            $pdf->SetFillColor(245, 245, 245);
            $pdf->SetWidths(array_column($cols_method, 'width'));
            $pdf->SetHeight(7);
            $pdf->Row(array_column($cols_method, 'label'), array_fill(0, count($cols_method), "C"), "Y", "Y", array(245, 245, 245));

            $total_transaction = 0;
            $total_income = 0;
            $total_expense = 0;

            foreach ($rows_method as $row) {
                $pdf->SetFont('Arial', '', 6);
                $values = array();
                $bg_row = array();

                $row->description = strtoupper($row->description)."\n"."N° Transac. ".$row->transactions;

                foreach ($fields as $field) {
                    $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                }

                $pdf->Row($values, $pos, "Y", "Y", $bg_row);

                $total_transaction = $total_transaction + $row->transactions;
                $total_income = $total_income + $row->total;
                $total_expense = $total_expense + $row->total_expense;

                $position_table = $position_table + $pdf->GetHeight() + 10;
            }

            $pdf->SetFont("Arial", "B", 7);
            $pdf->SetWidths(array(25, 20, 20));
            $pdf->SetHeight(7);

            $arr_foot = array(
                "TOTAL"."\n".utf8_decode(" N° Transac. ").$total_transaction,
                'S/. '.number_format($total_income, 2, ".", "'"),
                'S/. '.number_format($total_expense, 2, ".", "'")

            );

            $pdf->Row($arr_foot,array("C", "C", "C", "C"), "Y", "N");


            $position_table = $position_table + 20;

            $pdf->SetFont("Helvetica", "B", 9);
            $pdf->SetY($position_table);
            $pdf->SetX(8);
            $pdf->SetHeight(5);
            $pdf->SetWidths(array(0));

            $pdf->Row(array(utf8_decode("EFECTIVO EN CAJA \n S/ ".$moneybox->balance)),array("C"), "N", "Y");


            $position_table = $position_table + 30;
            $pdf->SetFont("Helvetica", "B", 9);
            $pdf->SetY($position_table);
            $pdf->SetWidths(array(0));
            $pdf->SetHeight(5);
            $pdf->SetX(8);
            $pdf->Row(array(utf8_decode("---------------------------------------------\nFIRMA RESPONSABLE Y N° DNI")),array("C"), "N", "Y");


            $pdf->AutoPrint();
            $pdf->output();
            exit;
        }
        else{
            echo "El formato especificado no existe";
        }

    }

    protected function get_columns_summary_methodpay()
    {
        return array(
            "description" => array("col" => "A", "label" => utf8_decode("Descripción"), "pos" => "L", "width" => 30)
        , "transactions" => array("col" => "B", "label" => utf8_decode("N° transacciones"), "pos" => "C", "width" => 30)
        , "total" => array("col" => "C", "label" => "Ingresos", "pos" => "C", "width" => 20)
        , "total_expense" => array("col" => "C", "label" => "Egresos", "pos" => "C", "width" => 20)
        );
    }


    protected function get_columns_arqueo()
    {
        return array(
            "date_hour" => array("col" => "A", "label" => "Hora", "pos" => "C", "width" => 15)
        , "concept" => array("col" => "B", "label" => "Concepto", "pos" => "L", "width" => 25)
        , "voucher" => array("col" => "C", "label" => "T. Comprobante", "pos" => "L", "width" => 40)
        , "reference_person" => array("col" => "D", "label" => "Cliente o Proveedor", "pos" => "L", "width" => 40)
        , "paymentmethod" => array("col" => "E", "label" => "M. pago", "pos" => "C", "width" => 22)
        , "income" => array("col" => "F", "label" => "Ingresos", "pos" => "R", "width" => 20)
        , "expense" => array("col" => "G", "label" => "Egresos", "pos" => "R", "width" => 20)
        , "credit" => array("col" => "H", "label" => utf8_decode("Créditos"), "pos" => "R", "width" => 20)
        );
    }

    protected function get_rows_arqueo($moneybox)
    {
        $rows = $this->rMoneyMovement->arqueo($moneybox);
        return $rows;
    }



    public function listExpenses(Request $request){
        $item = $this->rMoneyMovement->listExpense($request);
        return response()->json($item);
    }


    public function listExpensesExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "date_movement" => array("col" => "A", "label" => "Fecha", "pos" => "C", "width" => 18)
        , "nro_voucher" => array("col" => "B", "label" => "Voucher", "pos" => "C", "width" => 20)
        , "client" => array("col" => "C", "label" => "Nombre/Razon Social", "pos" => "L", "width" => 55)
        , "client_document" => array("col" => "D", "label" => "DNI/RUC", "pos" => "C", "width" => 25)
        , "total_gravado" => array("col" => "E", "label" => "T. Gravado", "pos" => "R", "width" => 20)
        , "total_igv" => array("col" => "F", "label" => "T. IGV", "pos" => "R", "width" => 20)
        , "total_exonerado" => array("col" => "G", "label" => "T.Exonerado", "pos" => "R", "width" => 22)
        , "total_sale" => array("col" => "H", "label" => "T. Venta", "pos" => "R", "width" => 22)
//        , "status" => array("col" => "H", "label" => "T. Venta", "pos" => "R", "width" => 22)
        );

        $cols_excel = array(
            "username" => array("col" => "A", "label" => "Usuario", "pos" => "C", "width" => 10)
        , "branchbox" => array("col" => "B", "label" => "Caja", "pos" => "C", "width" => 18)
        ,"date_movement" => array("col" => "C", "label" => "Fecha", "pos" => "C", "width" => 18)
        , "nro_voucher" => array("col" => "D", "label" => "Voucher", "pos" => "C", "width" => 20)
        , "receptor_module" => array("col" => "E", "label" => "Receptor", "pos" => "L", "width" => 150)
        , "receptor_fullname" => array("col" => "F", "label" => "Nombre / Razon Social", "pos" => "L", "width" => 150)
        , "receptor_document" => array("col" => "G", "label" => "Nro Documento", "pos" => "L", "width" => 150)
        , "concept" => array("col" => "H", "label" => "Concepto", "pos" => "L", "width" => 20)
        , "gloss" => array("col" => "I", "label" => "Glosa / descripcion", "pos" => "L", "width" => 20)
        , "voucher_external" => array("col" => "J", "label" => "Referencia comprobante", "pos" => "L", "width" => 20)
        , "nro_voucher_external" => array("col" => "K", "label" => "Referencia nro. voucher", "pos" => "L", "width" => 20)
        , "currency" => array("col" => "L", "label" => "Moneda", "pos" => "L", "width" => 20)
        , "paymethod" => array("col" => "M", "label" => "Medio pago", "pos" => "L", "width" => 20)
        , "status" => array("col" => "N", "label" => "Estado", "pos" => "L", "width" => 30)
        , "amount" => array("col" => "O", "label" => "TOTAL", "pos" => "R", "width" => 22)
        );

        $title_document = "REPORTE DE EGRESOS";

        $rows =  $this->rMoneyMovement->listExpense($request, true);
        $rows =  $rows['results'];

        $total_amount = 0;

        if ($format == config('app.export_format_excel')) {

            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', $title_document);
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));


            $y = 4;
            foreach($cols_excel as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {

                foreach($rows as $row) {
                    $y ++;

                    $row['total_gravado'] = $row->no_affect_igv + $row->affect_igv;

                    $row->status = "CONCRETADO";
                    $is_repayment = false;

                    if($row->deleted_at != null ){
                        $row->amount = 0;
                        // set status
                        $row->status = "ANULADO";
                        $is_repayment = true;
                    }

                    if($row->is_voucher_external == true){
                        $ref_voucher = $this->rTypeVoucher->find($row->voucher_external);
                        $row->voucher_external = $ref_voucher->description;
                    }

                    foreach($cols_excel as $key=>$val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true, $is_repayment);
                    }

                    $total_amount= $total_amount + $row->amount;
                }

                $y++;

                $this->utilHelper->row_excel($excel, $cols_excel["amount"]["col"], $y, $total_amount, null, true);
            }

//            $excel->getActiveSheet()->getStyle('A1:A5')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('9A1A1A');


            $filename='Reporte_de_egresos-'.date("dmY-hi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            dd("file is not available");

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle("FACTURACION ELECTRONICA DETALLADA", 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();

            $pdf->SetFont('Arial', '', 11);
            $pdf->SetY(13);
            $pdf->SetWidths(array(195));
            $pdf->Row(array(utf8_decode('Periodo : '.$parameters['start_range'].' - '.$parameters['end_range'])), array("C"), "N", "Y");


            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            if( ! empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY(42);

                $pdf->SetFont('Arial','B',9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach($rows as $row) {
                    $pdf->SetFont('Arial','',7);
                    $values = array();
                    $bg_row = array();

                    // default_columns
                    $row->voucher_external_description = '-';

                    foreach($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    if($row->status == 'Anulado'){
//                        $pdf->SetDrawColor(160, 160, 160);
                        $bg_row = array(246, 222, 222);
                    }

                    dd($row->is_voucher_external);
                    if($row->is_voucher_external == true){
                        $ref_voucher = $this->rTypeVoucher->find($row->voucher_external);
                        $row->voucher_external_description = $ref_voucher->description;
                    }

                    $pdf->SetFillColor(246, 222, 222);

                    $total_gravado = $total_gravado + $row->total_gravado;
                    $total_igv = $total_igv + $row->total_igv;
                    $total_exonerado= $total_exonerado + $row->total_exonerado;
                    $total_sale= $total_sale + $row->total_sale;

                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont("Arial", "B", 8);
                $pdf->SetWidths(array(118,20,20, 22, 22));
                $pdf->Row(array(
                    "",
                    number_format($total_gravado,2,".","'"),
                    number_format($total_igv,2,".","'"),
                    number_format($total_exonerado,2,".","'"),
                    number_format($total_sale,2,".","'")), array("R", "R", "R", "R", "R"));
            }

            $pdf->Output();
            exit;

        }

    }

}
