<?php

namespace App\Http\Controllers\Api\Report;

use App\Core\TenantCore;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Warehouse\Warehouse\WarehouseRepository;
use Illuminate\Http\Request;

class MovementWarehouseReportController extends Controller
{

    protected $rProduct;
    protected $tenant;
    protected $rWarehouse;

    public function __construct()
    {
        $this->tenant = new TenantCore();
        $this->rProduct = new ProductRepository();
        $this->rWarehouse = new WarehouseRepository();
    }

    public function exportStockGeneral(Request $request)
    {
        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        if ($format == config('app.export_format_pdf')) {

            $cols = $this->get_columns_stockgeneral($parameters);
            $rows = $this->get_rows_stockgeneral($parameters);

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
//            $pdf->SetTitle("REPORTE DE VENTAS {$subtitle}", 11);
//            $pdf->SetY(20);
            $pdf->SetTitle("REPORTE DE STOCK DE PRODUCTOS", 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total = 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $separetor_coluns = 5;
            $h_row = 3.5;
            $h_logo = 20;
            $w_logo = 40;

            $pdf->AddPage();

            $pdf->SetFont('Arial', '', 11);
            $pdf->SetY(13);
            $pdf->SetWidths(array(195));
            $pdf->Row(array(utf8_decode('Almacén : ').$this->rWarehouse->find($parameters['warehouse'])['description']), array("C"), "N", "Y");

            // fecha impresión
            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total - 45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el ' . date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total - 40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: ' . date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa != null || $logo_empresa != '') {
                $logo_empresa = "companies/" . $company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            // imprimir las filas de la tabla
            if (!empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N", "Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY(42);

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(4);
                $pdf->SetFillColor(255, 255, 255);
                foreach ($rows as $row) {
                    $pdf->SetFont('Arial', '', 7);
                    $values = array();
                    $bg_row = array();

                    $row['description_product'] = $row['description']."\n".$row['code'];
                    $row['unitmeasure'] = $row['productstock'][0]['unidad_plural'];
                    $row['stock'] = $row['productstock'][0]['stock']." ".$row['productstock'][0]['unitprefix'];


                    $txt_equivalence = '';
                    foreach ($row['unitsmeasure'] as $equivalence) {
                        $divider = number_format($row['productstock'][0]['stock'] / $equivalence['equivalence'],2);
                        $txt_equivalence.=$equivalence['description']."(".$equivalence['equivalence'].")"." => ".$divider."\n";
                    }

                    $row['equivalence'] = $txt_equivalence;

                    foreach ($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }
            }

            $pdf->Output();
            exit;
        }

    }


    protected function get_rows_stockgeneral($parameters)
    {
        $rows = $this->rProduct->rowExportStockGeneral($parameters);
        return $rows;
    }


    protected function get_columns_stockgeneral()
    {
        return array(
            "description_product" => array("col" => "A", "label" => utf8_decode("Producto"), "pos" => "L", "width" => 62)
        , "brand" => array("col" => "B", "label" => "Marca", "pos" => "C", "width" => 20)
        , "line" => array("col" => "C", "label" => utf8_decode("Línea"), "pos" => "C", "width" => 20)
        , "unitmeasure" => array("col" => "D", "label" => "Medida", "pos" => "C", "width" => 20)
        , "stock" => array("col" => "E", "label" => utf8_decode("Stock mínimo"), "pos" => "C", "width" => 30)
        , "equivalence" => array("col" => "F", "label" => "Equivalencias", "pos" => "R", "width" => 50)
        );
    }
}
