<?php

namespace App\Http\Controllers\Api\Report;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Purchase\Purchase\PurchaseRepository;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class PurchaseReportController extends Controller
{
    protected $rPurchase;
    protected $tenant;
    protected $utilHelper;

    public function __construct()
    {
        $this->rPurchase = new PurchaseRepository();
        $this->tenant = new TenantCore();
        $this->utilHelper = new UtilHelper();
    }

    public function listPurchases(Request $request){
        $query = $this->rPurchase->listPurchase($request);
        return response()->json($query);
    }

    public function listPurchasesExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "date_purchase" => array("col" => "A", "label" => "Fecha", "pos" => "C", "width" => 20)
        ,"typevoucher" => array("col" => "B", "label" => "Tipo Comprobante", "pos" => "C", "width" => 35)
        , "nro_voucher" => array("col" => "C", "label" => "# Voucher", "pos" => "C", "width" => 20)
        , "type_transaction" => array("col" => "D", "label" => "T. Compra", "pos" => "C", "width" => 20)
        , "provider_document" => array("col" => "E", "label" => "# RUC", "pos" => "C", "width" => 20)
        , "provider" => array("col" => "F", "label" => "Proveedor", "pos" => "L", "width" => 53)
        , "status" => array("col" => "G", "label" => "Estado", "pos" => "C", "width" => 15)
        , "total" => array("col" => "H", "label" => "Total", "pos" => "R", "width" => 18)
        );

        $title_document = "FACTURACION ELECTRONICA";

        $rows =  $this->rPurchase->listPurchase($request, true);
        $rows =  $rows['results'];

        if ($format == config('app.export_format_excel')) {

            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', $title_document);
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));


            $y = 4;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                $total = 0;

                foreach($rows as $row) {
                    $y ++;
                    foreach($cols as $key=>$val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }

                    $total = $total + $row->total;
                }
                $y++;

                $this->utilHelper->row_excel($excel, $cols["status"]["col"], $y, "TOTAL", null, true);
                $this->utilHelper->row_excel($excel, $cols["total"]["col"], $y, $total, null, true);

            }

            $filename='reporte_compras-'.date("dmY-hi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle($title_document, 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();


            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            // imprimir las filas de la tabla
            if (!empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N", "Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY(42);

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach ($rows as $row) {
                    $pdf->SetFont('Arial', '', 7);
                    $values = array();
                    $bg_row = array();

                    foreach ($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    if ($row->status == 'Anulado') {
//                        $pdf->SetDrawColor(160, 160, 160);
                        $bg_row = array(246, 222, 222);
                    }

                    $pdf->SetFillColor(246, 222, 222);

                    $total = $total + $row->total;
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont("Arial", "B", 9);
                $pdf->SetWidths(array(180, 21));
                $pdf->SetHeight(10);
                $pdf->Row(array("TOTAL", number_format($total, 2, ".", "'")), array("R", "R"), "N");
            }

            $pdf->Output();
            exit;

        }

    }

    public function exportPurchases(Request $request)
    {
        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        if ($format == config('app.export_format_pdf')) {

            $cols = $this->get_columns_purchases($parameters);
            $rows = $this->get_rows_purchases($parameters);

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
//            $pdf->SetTitle("REPORTE DE VENTAS {$subtitle}", 11);
//            $pdf->SetY(20);
            $pdf->SetTitle("REPORTE DE COMPRAS", 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total = 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $separetor_coluns = 5;
            $h_row = 3.5;
            $h_logo = 20;
            $w_logo = 40;

            $pdf->AddPage();

            $pdf->SetFont('Arial', '', 11);
            $pdf->SetY(13);
            $pdf->SetWidths(array(195));
            $pdf->Row(array('Desde el ' . date("d M Y", strtotime($parameters['start_range'])) . '   al  ' . date("d M Y", strtotime($parameters['end_range']))), array("C"), "N", "Y");

            // fecha impresión
            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total - 45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el ' . date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total - 40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: ' . date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa != null || $logo_empresa != '') {
                $logo_empresa = "companies/" . $company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            // imprimir las filas de la tabla
            if (!empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N", "Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY(42);

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach ($rows as $row) {
                    $pdf->SetFont('Arial', '', 7);
                    $values = array();
                    $bg_row = array();

                    foreach ($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    if ($row->status == 'Anulado') {
//                        $pdf->SetDrawColor(160, 160, 160);
                        $bg_row = array(246, 222, 222);
                    }

                    $pdf->SetFillColor(246, 222, 222);

                    $total = $total + $row->total;
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont("Arial", "B", 9);
                $pdf->SetWidths(array(180, 21));
                $pdf->SetHeight(10);
                $pdf->Row(array("TOTAL", number_format($total, 2, ".", "'")), array("R", "R"), "N");
            }

            $pdf->Output();
            exit;
        }

    }

    protected function get_columns_purchases()
    {
        return array(
            "date_purchase" => array("col" => "C", "label" => "Fecha", "pos" => "C", "width" => 20)
        ,"typevoucher" => array("col" => "B", "label" => "Tipo Comprobante", "pos" => "C", "width" => 35)
        , "nro_voucher" => array("col" => "C", "label" => utf8_decode("N° voucher"), "pos" => "C", "width" => 20)
        , "type_transaction" => array("col" => "D", "label" => "T. Compra", "pos" => "C", "width" => 20)
        , "provider_document" => array("col" => "D", "label" => utf8_decode("N° RUC"), "pos" => "C", "width" => 20)
        , "provider" => array("col" => "E", "label" => "Proveedor", "pos" => "L", "width" => 53)
        , "status" => array("col" => "F", "label" => "Estado", "pos" => "C", "width" => 15)
        , "total" => array("col" => "F", "label" => "Total", "pos" => "R", "width" => 18)
        );
    }

    protected function get_rows_purchases($parameters)
    {
        $rows = $this->rPurchase->rowExportPurchases($parameters);
        return $rows;
    }
}
