<?php

namespace App\Http\Controllers\Api\Report;

use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Category\CategoryRepository;
use App\Models\Tenant\Catalog\Line\LineRepository;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class SaleReportController extends Controller
{
    protected $rSale;
    protected $tenant;
    protected $rClient;
    protected $rProduct;
    protected $utilHelper;

    protected $rCategory;
    protected $rLine;

    public function __construct()
    {
        $this->rSale = new SaleRepository();
        $this->tenant = new TenantCore();
        $this->rClient = new ClientRepository();
        $this->utilHelper = new UtilHelper();
        $this->rProduct = new ProductRepository();
        $this->rCategory = new CategoryRepository();
        $this->rLine = new LineRepository();
    }


    public function historySaleByMonth(Request $request)
    {
        $query = $this->rSale->totalSaleMonthByYear($request);

        $response = array(
            'status' => 'success',
            'graph_sale_month' => $query,
        );

        return response()->json($response);
    }

    public function historyClientVip(Request $request){
        $query = $this->rSale->historyClientVip($request);

        $response = array(
            'status' => 'success',
            'results' => $query,
        );

        return response()->json($response);
    }

    public function historyEmployeeSale(Request $request){
        $query = $this->rSale->historyEmployeeSale($request);

        $response = array(
            'status' => 'success',
            'results' => $query,
        );

        return response()->json($response);
    }


    public function exportSales(Request $request)
    {
        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        if ($format == config('app.export_format_pdf')) {

            $cols = $this->get_columns_sales($parameters);
            $rows = $this->get_rows_sales($parameters);

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
//            $pdf->SetTitle("REPORTE DE VENTAS {$subtitle}", 11);
//            $pdf->SetY(20);
            $pdf->SetTitle("REPORTE DE VENTAS", 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total = 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $separetor_coluns = 5;
            $h_row = 3.5;
            $h_logo = 20;
            $w_logo = 40;

            $pdf->AddPage();

            $pdf->SetFont('Arial', '', 11);
            $pdf->SetY(13);
            $pdf->SetWidths(array(195));
            $pdf->Row(array('Desde el ' . date("d M Y", strtotime($parameters['start_range'])) . '   al  ' . date("d M Y", strtotime($parameters['end_range']))), array("C"), "N", "Y");

            // fecha impresión
            $pdf->SetFont('Arial', '', 9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total - 45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el ' . date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total - 40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: ' . date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa != null || $logo_empresa != '') {
                $logo_empresa = "companies/" . $company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            // imprimir las filas de la tabla
            if (!empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N", "Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY(42);

                $pdf->SetFont('Arial', 'B', 9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach ($rows as $row) {
                    $pdf->SetFont('Arial', '', 7);
                    $values = array();
                    $bg_row = array();
                    foreach ($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    if ($row->status == 'Pendiente') {
                        $bg_row = array(255, 255, 60);
                    }

                    $pdf->SetFillColor(255, 255, 60);

                    $total = $total + $row->total;
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont("Arial", "B", 9);
                $pdf->SetWidths(array(180, 21));
                $pdf->SetHeight(10);
                $pdf->Row(array("TOTAL", number_format($total, 2, ".", "'")), array("R", "R"), "N");
            }

            $pdf->Output();
            exit;
        }

    }

    protected function get_columns_sales()
    {
        return array(
            "date_sale" => array("col" => "C", "label" => "Fecha", "pos" => "C", "width" => 20)
        , "date_hour" => array("col" => "C", "label" => "Hora", "pos" => "C", "width" => 20)
        , "code" => array("col" => "C", "label" => utf8_decode("N° venta"), "pos" => "C", "width" => 20)
        , "typetransaction" => array("col" => "D", "label" => "T. Venta", "pos" => "C", "width" => 20)
        , "client_document" => array("col" => "D", "label" => utf8_decode("DNI/RUC"), "pos" => "C", "width" => 20)
        , "client" => array("col" => "E", "label" => "Cliente", "pos" => "L", "width" => 68)
        , "status" => array("col" => "F", "label" => "Pago", "pos" => "C", "width" => 15)
        , "total" => array("col" => "F", "label" => "Total", "pos" => "R", "width" => 18)
        );
    }

    protected function get_rows_sales($parameters)
    {
        $rows = $this->rSale->rowExportSales($parameters);
        return $rows;
    }

    public function saleClients(Request $request){
        $item = $this->rClient->listClients($request);
        return response()->json($item);
    }

    public function saleClientsExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "fullname" => array("col" => "A", "label" => "NOMBRES / RAZON SOCIAL", "pos" => "L", "width" => 85)
        , "typeDocument" => array("col" => "B", "label" => "T. DOC.", "pos" => "C", "width" => 25)
        , "document" => array("col" => "C", "label" => "DOCUMENTO", "pos" => "C", "width" => 25)
        , "cellphone" => array("col" => "D", "label" => "TELEFONO", "pos" => "C", "width" => 25)
        , "email" => array("col" => "E", "label" => "CORREO", "pos" => "C", "width" => 40)
        );

        $rows =  $this->rClient->listClients($request, true);
        $rows =  $rows['results'];

        if ($format == config('app.export_format_excel')) {


            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', "REPORTE DE CLIENTES");
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));
            $excel->getActiveSheet()->setCellValue('A3', "# Total: ".count($rows)." registros");

            $y = 5;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                foreach($rows as $row) {
                    $y ++;
                    foreach($cols as $key=>$val) {
                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }
                }
                $y++;
            }



            $filename='catalogo_marcas-'.date("dmYhi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle(utf8_decode("REPORTE DE CLIENTES"), 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 20;
            $w_logo=40;

            $pdf->AddPage();


            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            if( ! empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array(utf8_decode("N° RUC :"), $company->ruc), array("L"), "N", "Y");
                // $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 200));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetFont('Arial','B',9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach($rows as $row) {
                    $pdf->SetFont('Arial','',7);
                    $values = array();
                    $bg_row = array();

                    foreach($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->SetFillColor(246, 222, 222);
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont('Arial','B',8);
                $pdf->SetWidths(array(14, 50));
                $pdf->SetHeight(10);
                $pdf->Row(array(utf8_decode('N° Total:'), count($rows)." registros"), array("L"), "N", "Y");
            }

            $pdf->Output();
            exit;

        }

    }

    public function saleUtilityProduct(Request $request){
        $item = $this->rProduct->saleUtilityProduct($request);
        return response()->json($item);
    }

    public function saleUtilityProductExport(Request $request){

        $company = $this->tenant->company();
        $format = $request->get('format');
        $parameters = $request->all();

        $cols = array(
            "description" => array("col" => "A", "label" => "PRODUCTO", "pos" => "L", "width" => 62)
        , "quantity_sale" => array("col" => "B", "label" => "CANT.", "pos" => "C", "width" => 20)
        , "average_price_purchase" => array("col" => "C", "label" => "P.Prom.Compra", "pos" => "C", "width" => 30)
        , "average_price_sale" => array("col" => "D", "label" => "P.Prom.Venta", "pos" => "C", "width" => 30)
        , "total_sale" => array("col" => "E", "label" => "T. VENDIDO", "pos" => "C", "width" => 30)
        , "utility" => array("col" => "F", "label" => "UTILIDAD", "pos" => "C", "width" => 30)
        );

        $rows =  $this->rProduct->saleUtilityProduct($request, true);
        $rows =  $rows['results'];

        if ($format == config('app.export_format_excel')) {


            $style_bold = array("font"=>array("bold"=>true));

            $excel = new Spreadsheet();
            $excel->getActiveSheet()->setCellValue('A1', "REPORTE UTILIDAD VENTA DE PRODUCTOS");
            $excel->getActiveSheet()->getStyle('A1')->applyFromArray($style_bold);
            $excel->getActiveSheet()->setCellValue("A2", 'Archivo Generado: '.date('Y-m-d h:i a'));
            $excel->getActiveSheet()->setCellValue('A3', "# Total: ".count($rows)." registros");

            $y = 5;
            foreach($cols as $val) {
                $this->utilHelper->row_excel($excel, $val["col"], $y, $val["label"], null, true, true);
            }

            if( ! empty($rows)) {
                foreach($rows as $row) {
                    $y ++;
                    foreach($cols as $key=>$val) {
                        /*
                        if($row['quantity_sale'] == null){
                            $row['quantity_sale'] = 0;
                        }

                        if($row['average_price_sale'] == null){
                            $row['average_price_sale'] = 0;
                        }

                        if($row['average_price_purchase'] == null){
                            $row['average_price_purchase'] = 0;
                        }

                        $row['total_sale'] = $row['average_price_sale']*$row['quantity_sale'];
                        $diff_utility = ($row['average_price_sale']*$row['quantity_sale']) - ($row['average_price_purchase']*$row['quantity_sale']);
                        $row['utility'] = utf8_decode('S/ '.number_format($diff_utility, 2));
                        $row['quantity_sale'] = $row['quantity_sale']." ".$row['productstock'][0]['unitprefix'];
                        */

                        $this->utilHelper->row_excel($excel, $val["col"], $y, $row->{$key}, null, false, true);
                    }
                }
                $y++;
            }

            $filename='utilidad_productos-'.date("dmYhi").'.xlsx';
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            $objWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($excel);
            $objWriter->save('php://output');
            exit;
        }
        else{

            $pdf = new \App\Libraries\Pdf();
            $pdf->AliasNbPages(); // para el conteo de paginas
            $pdf->SetLeftMargin(4);
            $pdf->SetTopMargin(7);
            $pdf->SetTitle(utf8_decode("REPORTE UTILIDAD VENTA DE PRODUCTOS"), 12);
            $pdf->SetDrawColor(160, 160, 160);

            // espacios iniciales
            $ancho_total= 210;
            $height_total = 297;
            $espac = 5;
            $pos_initial_x = 5;
            $h_logo = 23;
            $w_logo=40;

            $pdf->AddPage();

            $pdf->SetFont('Arial', '', 11);
            $pdf->SetY(13);
            $pdf->SetWidths(array(195));
            $pdf->Row(array(utf8_decode('Periodo : '.$parameters['start_range'].' - '.$parameters['end_range'])), array("C"), "N", "Y");



            // fecha impresión
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(10);
            $pdf->SetX($ancho_total-45);
            $pdf->MultiCell(50, 2.5, utf8_decode('Generado el '.date('Y-m-d')), 0);
            $pdf->SetY(15);
            $pdf->SetX($ancho_total-40);
            $pdf->MultiCell(50, 2.5, utf8_decode('Hora: '.date('H:i:s a ')), 0);

            $logo_empresa = 'default.jpg';

            if ($logo_empresa!=null || $logo_empresa!=''){
                $logo_empresa = "companies/".$company->url_image;
            }

            $pdf->Image($logo_empresa, $pos_initial_x, $espac, $w_logo, $h_logo);

            $pdf->SetY(30);

            if( ! empty($rows)) {
                $pdf->SetFillColor(246, 212, 212);

                $fields = array_keys($cols);
                $pos = array_column($cols, "pos");
                $total = 0;

                $pdf->SetFont('Arial','B',9);
                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array('EMPRESA :', $company->social_reason), array("L"), "N","Y");

                $pdf->SetWidths(array(22, 100));
                $pdf->Row(array( utf8_decode('DIRECCIÓN :'), utf8_decode($company->address)), array("L"), "N","Y");

                $pdf->SetY(30);
                $pdf->SetX(130);
                $pdf->SetWidths(array(12, 100));
                $pdf->Row(array('RUC :', $company->ruc), array("L"), "N", "Y");
                $pdf->Row(array(''), array("L"), "N", "Y");

                $pdf->SetY(42);

                $pdf->SetFont('Arial','B',9);
                $pdf->SetFillColor(245, 245, 245);
                $pdf->SetWidths(array_column($cols, 'width'));
                $pdf->SetHeight(7);
                $pdf->Row(array_column($cols, 'label'), array_fill(0, count($cols), "C"), "Y", "Y", array(245, 245, 245));

                $pdf->SetHeight(6);
                $pdf->SetFillColor(255, 255, 255);
                foreach($rows as $row) {
                    $pdf->SetFont('Arial','',7);
                    $values = array();
                    $bg_row = array();

                    $row['description'] = $row['description']."\n".$row['code'];
                    $row['total_sale'] = utf8_decode('S/ '.number_format($row['average_price_sale']*$row['quantity_sale'], 2));
                    $diff_utility = ($row['average_price_sale']*$row['quantity_sale']) - ($row['average_price_purchase']*$row['quantity_sale']);
                    $row['utility'] = utf8_decode('S/ '.number_format($diff_utility, 2));
                    $row['quantity_sale'] = $row['quantity_sale']." ".$row['productstock'][0]['unitprefix'];


                    foreach($fields as $field) {
                        $values[] = isset($row->{$field}) ? utf8_decode($row->{$field}) : "";
                    }

                    $pdf->SetFillColor(246, 222, 222);
                    $pdf->Row($values, $pos, "Y", "Y", $bg_row);
                }

                $pdf->SetFont('Arial','B',8);
                $pdf->SetWidths(array(14, 50));
                $pdf->SetHeight(10);
                $pdf->Row(array(utf8_decode('N° Total:'), count($rows)." registros"), array("L"), "N", "Y");
            }

            $pdf->Output();
            exit;

        }

    }

    public function saleSummaryLine(Request $request){
        $item = $this->rLine->saleSummaryLine($request);
        return response()->json($item);
    }

}
