<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Tenant\Management\User\UserRepository;
use App\Models\Tenant\Sale\OrderDetail\OrderDetailRepository;
use App\User;
use Illuminate\Http\Request;

class ReportApiController extends Controller
{

    protected $rUserRepository;
    protected $rOrderDetail;

    public function __construct()
    {
        $this->rUserRepository = new UserRepository();
        $this->rOrderDetail = new OrderDetailRepository();

    }


    public function index(Request $request)
    {

        $date_order = $request->get('date_order');
        $shift_txt = "MAÑANA";
        $shift_id = config('app.shift_morning');

        if($request->get('shift')==config('app.shift_afternoon')){
            $shift_txt = "TARDE";
            $shift_id = config('app.shift_afternoon');
        }


        $pdf = new \App\Libraries\Pdf();

        $w_total = 210;
        $h_total = 297;
        $l_height = 3.5;
        $space_y = 10;
        $space_x = 5;


//        $pdf->SetAutoPageBreak(false);
        $pdf->AddPage('P', array($w_total, $h_total));
        $pdf->SetFillColor(255,255,255);

        // HEADERS REQUEST
        $user = auth()->user();
        $users = $this->rUserRepository->allSeller();

        $txt_seller = "VENDEDORES";

        if($user->profile_id == config('app.profile_seller')){
            $users = $this->rUserRepository->getUserById($user->id);
            $txt_seller = "VEND.";
        }


        $pdf->SetFont('Arial', 'B', 10);

        $pdf->SetY($space_y - 2);
        $pdf->SetX($space_x);
        $pdf->Cell(30,$l_height,utf8_decode('FECHA PEDIDO'),0,0,'C',1);

        $pdf->SetFont('Arial', '', 10);
        $pdf->SetY($space_y + 3);
        $pdf->SetX($space_x);
        $pdf->Cell(30,$l_height,utf8_decode($date_order),0,0,'C',1);


        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetY($space_y-1);
        $pdf->SetX($space_x + 70);
        $pdf->Cell(60,$l_height,utf8_decode('REPORTE DE PEDIDOS'),0,0,'C',1);


        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetY($space_y - 2);
        $pdf->SetX($w_total - 35);
        $pdf->Cell(30,$l_height,utf8_decode('TURNO'),0,0,'C',1);

        $pdf->SetFont('Arial', '', 10);
        $pdf->SetY($space_y + 3);
        $pdf->SetX($w_total - 35);
        $pdf->Cell(30,$l_height,utf8_decode($shift_txt),0,0,'C',1);



        $pdf->SetFont('Arial', 'B', 8);
        $space_y = $space_y + 15;

        // head

        $space_x_dinamic = $space_x;
        $w_description = 60;

        $pdf->SetFillColor(232, 236, 241);
        $pdf->SetY(20);
        $pdf->SetX($space_x);
        $pdf->Cell($w_description,$l_height+7.5,utf8_decode('DESCRIPCIÓN PRODUCTO'),0,0,'L',1);


        $pdf->Line($w_description+$space_x, $space_y-5, $w_description+$space_x, $h_total-10);

        $space_x_dinamic = $w_description + $space_x+0.5;
        $w_colunms = 10;

        // ORIENTATION VERTICAL
//        $space_y = $space_y + 5;


        // position vendedores header =

        $pdf->SetY(20);
        $pdf->SetX($space_x_dinamic);
        $pdf->Cell(intval(count($users))*$w_colunms + intval(count($users)), $l_height+2,utf8_decode($txt_seller) , 0, 0, 'C', 1);



        for ($j = 0; $j < count($users); $j++) {

            $pdf->SetFont('Arial', 'B', 6);
            $pdf->SetY($space_y);
            $pdf->SetX($space_x_dinamic);
//            $pdf->Cell($w_colunms, $l_height,utf8_decode('DNI') , 0, 0, 'C', 1);
            $pdf->Cell($w_colunms, $l_height,utf8_decode('Nombre') , 0, 0, 'C', 1);

            $pdf->SetFont('Arial', '', 6.5);
            $pdf->SetY($space_y + 3);
            $pdf->SetX($space_x_dinamic);
//            $pdf->Cell($w_colunms, $l_height,utf8_decode($users[$j]->document) , 0, 0, 'C', 1);
            $pdf->Cell($w_colunms, $l_height,utf8_decode(strtolower($users[$j]->name)) , 0, 0, 'C', 1);


            $space_x_dinamic = $space_x_dinamic + $w_colunms +0.5;
            $pdf->Line($space_x_dinamic, $space_y, $space_x_dinamic, $h_total-10);

            $space_x_dinamic = $space_x_dinamic+0.5;

            // ORIENTATION VERTICAL
//            $pdf->TextWithDirection($space_x_dinamic,$space_y-3,'DNI','U');
//            $space_x_dinamic = $space_x_dinamic + 3;//
//            $pdf->SetFont('Arial', '', 7);
//            $pdf->TextWithDirection($space_x_dinamic,$space_y,'72322246','U');

        }

        $pdf->SetY(20);
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->SetX($w_total-$w_colunms-10);
        $pdf->Cell(15, $l_height+7.5,utf8_decode('TOTAL') , 0, 0, 'C', 1);


        $pdf->SetY($space_y +6);
        $pdf->SetX($space_x);

        $pdf->Line($space_x, $space_y + 3 + $l_height,$w_total-$space_x, $space_y + 3 + $l_height);

        $pdf->SetFillColor(255,255,255);


//        $pdf->Cell($w_total,1,utf8_decode($separetor),0,0,'L',1);


        $pdf->SetFont('Arial', '', 8);
        $space_y = $space_y + 8;
        $model_rows = $this->rOrderDetail->reportByDateGroupByProduct($date_order,$shift_id);

        $space_x_dinamic = $w_description + 10;

//        dd("here");

        for ($j = 0; $j < count($model_rows); $j++) {
            $pdf->SetFont('Arial', '', 7);
            $pdf->SetY($space_y);
            $pdf->SetX($space_x);
            $pdf->Cell($w_description-1, $l_height,utf8_decode($model_rows[$j]->description) , 0, 0, 'L', 1);

            $total_by_product = 0;

            $space_x_column = $w_description + $space_x + 1;
            $w_colunms = 9;

            for ($i = 0; $i < count($users); $i++) {
                $pdf->SetFont('Arial', '', 8);

                $model_column = $this->rOrderDetail->reportByProductByUser($model_rows[$j]->product_id, $users[$i]->id, $shift_id);

                $pdf->SetY($space_y);
                $pdf->SetX($space_x_column);
                $pdf->Cell($w_colunms, $l_height,utf8_decode($model_column[0]->quantity) , 0, 0, 'C', 1);

                $space_x_column = $space_x_column + $w_colunms + 2;

                $total_by_product = $total_by_product + intval($model_column[0]->quantity);
            }

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY($space_y);
            $pdf->SetX($w_total-$w_colunms-10);
            $pdf->Cell(15, $l_height,utf8_decode($total_by_product) , 0, 0, 'C', 1);

            $space_y = $space_y + 4;

            $pdf->SetY($space_y);
            $pdf->SetX($space_x);
            $separetor = '.................................................................................................................................................................................................................................................................';
            $pdf->Cell($w_total-$space_x-4,0,utf8_decode($separetor),0,0,'C',1);

            $space_y = $space_y +2;

        }
//        $pdf->TextWithDirection(20,150,'world!','U');

        $pdf->SetAutoPageBreak(true, 50);

        $pdf->AutoPrint();
        $pdf->output();
        exit;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
