<?php

namespace App\Http\Controllers\Api\Restaurant;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Restaurant\CategoryFood\CategoryFoodRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CategoryFoodController extends Controller
{
    protected $rCategoryFood;

    public function __construct()
    {
        $this->rCategoryFood = new CategoryFoodRepository();
    }

    public function index(Request $request)
    {
        $item = $this->rCategoryFood->list($request);
        return response()->json($item);
    }

    public function all()
    {
        $query = $this->rCategoryFood->all();
        $response = array(
            'results' => $query,
            'total' => count($query)
        );

        return response()->json($response);
    }

    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $data = $request->all();
            $item = $this->rCategoryFood->create($data);
            $response = array(
                'status' => 'success',
                'data' => $item
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $error = array(
                'code' => $e->getCode(),
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }


    public function edit($id)
    {
        $item = $this->rCategoryFood->find($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
