<?php

namespace App\Http\Controllers\Api\Sales;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Catalog\ProductVariant\ProductVariantRepository;
use App\Models\Tenant\Sale\Order\OrderRepository;
use App\Models\Tenant\Sale\OrderDetail\OrderDetailRepository;
use App\Models\Tenant\Sale\SaleDelivery\SaleDeliveryRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OrderApiController extends Controller
{

    protected $utilHelper;
    protected $rOrder;
    protected $rOrderDetail;
    protected $rProduct;
    protected $rProductEquivalence;
    protected $rProductVariant;
    protected $rSaleDelivery;


    public function __construct()
    {
        $this->utilHelper = new UtilHelper();
        $this->rOrder = new OrderRepository();
        $this->rOrderDetail = new OrderDetailRepository();
        $this->rProduct = new ProductRepository();
        $this->rProductEquivalence = new ProductEquivalenceRepository();
        $this->rProductVariant = new ProductVariantRepository();
        $this->rSaleDelivery = new SaleDeliveryRepository();
    }


    public function index(Request $request)
    {
        $query = $this->rOrder->listOrder($request);
        return response()->json($query);
    }

    public function listCommand(Request $request)
    {
        $query = $this->rOrder->listCommand($request);
        return response()->json($query);
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $order_data = $request->get('order');
            $detail_data = $request->get('detail');

            $order = $this->rOrder->create($order_data);

            foreach ($detail_data as $detail) {
                $detail['order_id'] = $order['id'];
                $detail['product_id'] = $detail['id'];
                $detail['equivalence'] = null;

                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $detail['equivalence'] =  $equivalence['equivalence'];
                }

                $this->rOrderDetail->create($detail);
            }

            $response = array(
                'status' => 'success',
                'data' => $order
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function storeCommand(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $order_data = $request->get('order');
            $detail_data = $request->get('detail');

            $order = $this->rOrder->createCommand($order_data);

            foreach ($detail_data as $detail) {
                $detail['order_id'] = $order['id'];
                $detail['product_id'] = $detail['id'];
                $detail['equivalence'] = null;

                $productequivalence_id = null;
                $productvariant_id = null;

                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $detail['equivalence'] =  $equivalence['equivalence'];
                    $productequivalence_id = $equivalence->id;
                }

                if ($detail['typeprice_id'] == config('app.catalog_price_variant')) {
                    $variant = $this->rProductVariant->findByProductAndTypeVariant($detail['product_id'], $detail['variant_id']);
                    $detail['equivalence'] =  $variant['equivalence'];
                    $productvariant_id = $variant->id;
                }

                $obj = $this->rOrderDetail->create($detail);

                $obj->productequivalence_id =$productequivalence_id;
                $obj->productvariant_id =$productvariant_id;
                $obj->save();
            }

            // is delivery in order command
            if($this->utilHelper->strToBooleanValue($order->is_delivered)){
                $delivery = $this->rSaleDelivery->create($request->get('delivery'));
                $order->delivery_id = $delivery->id;
                $order->save();
            }

            $response = array(
                'status' => 'success',
                'data' => $order
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $proforma = $this->rOrder->findJoined($id);
        $order_detail = $this->rProduct->findByJoinedOrderDetail($id);

        $result = array(
            'order' => $proforma,
            'detail' => $order_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }

    public function editCommand($id)
    {
        $proforma = $this->rOrder->findJoined($id);
        $order_detail = $this->rProduct->findByJoinedOrderDetail($id);
        $delivery = $this->rSaleDelivery->find($proforma->delivery_id);

        $result = array(
            'sale' => $proforma,
            'delivery' => $delivery,
            'detail' => $order_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }

    public function detail($id)
    {

        $order = $this->rOrder->findJoined($id);
        $order_detail = $this->rOrderDetail->findByOrderIdJoined($id);

        $result = array(
            'order' => $order,
            'detail' => $order_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }


    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $order_data = $request->get('order');
            $detail_order_data = $request->get('detail');

            $order = $this->rOrder->updated($id, $order_data);

            // delete pass history orderdetail
            $detail_pass = $this->rOrderDetail->findByOrderId($order['id']);

            foreach ($detail_pass as $item) {
                $this->rOrderDetail->deleted($item->id);
            }


            foreach ($detail_order_data as $item) {
                $detail = $this->rOrderDetail->findByOrderIdAndProductId($order['id'], $item['id']);

                $item['equivalence'] = null;

                if ($item['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($item['id'], $item['unit_id']);
                    $item['equivalence'] =  $equivalence['equivalence'];
                }

                if($detail == null){
                    $item['order_id'] = $order['id'];
                    $item['product_id'] = $item['id'];
                    $this->rOrderDetail->create($item);
                } else {
                    $this->rOrderDetail->updated($detail['id'], $item);
//                    $this->rOrderDetail->updated($item['detail_id'], $item);
                }
            }

            $response = array(
                'status' => 'success',
                'data' => $order
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function updateCommand(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $order_data = $request->get('order');
            $detail_order_data = $request->get('detail');
            $delivery_data = $request->get('delivery');

            $order = $this->rOrder->updatedCommand($id, $order_data);

            // delete pass history orderdetail
            $detail_pass = $this->rOrderDetail->findByOrderId($order['id']);

            foreach ($detail_pass as $item) {
                $this->rOrderDetail->deleted($item->id);
            }

            foreach ($detail_order_data as $item) {
                $item['product_id'] = $item['id'];

                if ($item['typeprice_id'] == config('app.catalog_price_variant')) {
                    $detail = $this->rOrderDetail->findByOrderIdAndProductIdAndVariantId($order['id'], $item['product_id'], $item['variant_id']);
                    $variant = $this->rProductVariant->findByProductAndTypeVariant($item['product_id'], $item['variant_id']);

                    $item['equivalence'] = $variant['equivalence'];

                    if($detail == null){
                        $item['order_id'] = $order['id'];
                        $item['product_id'] = $item['id'];

                        $obj = $this->rOrderDetail->create($item);
                        $obj->productvariant_id = $item['variant_id'];
                        $obj->save();
                    }
                    else{
                        $this->rOrderDetail->updated($detail['id'], $item);
                    }

                }
                else if($item['typeprice_id'] == config('app.catalog_price_unit')){

                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($item['product_id'], $item['unit_id']);
                    $detail = $this->rOrderDetail->findByOrderIdAndProductIdAndEquivalenceId($order['id'], $item['product_id'], $equivalence['id']);

                    $item['equivalence'] = $equivalence['equivalence'];
                    if($detail == null){
                        $item['order_id'] = $order['id'];
                        $item['product_id'] = $item['id'];
                        $obj = $this->rOrderDetail->create($item);

                        $obj->productequivalence_id = $equivalence['id'];
                        $obj->save();
                    }
                    else{
                        $this->rOrderDetail->updated($detail['id'], $item);
                    }

                }
                else{
                    $detail = $this->rOrderDetail->findByOrderIdAndProductId($order['id'], $item['product_id']);

                    $item['equivalence'] = null;

                    if($detail == null){
                        $item['order_id'] = $order['id'];
                        $item['product_id'] = $item['id'];
                        $this->rOrderDetail->create($item);
                    } else {
                        $this->rOrderDetail->updated($detail['id'], $item);
                    }
                }
            }

            // delivery data
            if($this->utilHelper->strToBooleanValue($order->is_delivered)){
                if($delivery_data['id'] == 0){
                    $delivery = $this->rSaleDelivery->create($delivery_data);
                    $order->delivery_id = $delivery->id;
                    $order->save();
                }else{
                    $this->rSaleDelivery->updated($delivery_data['id'], $delivery_data);
                }
            }
            else{
               $order->delivery_id = null;
               $order->save();
            }

            $response = array(
                'status' => 'success',
                'data' => $order
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function closeCommand(Request $request, $id)
    {

        $item = $this->rOrder->closeCommand($id);
        $response = array(
            'status' => 'success',
            'data' => $item
        );
        return response()->json($response);
    }


    public function updateDelivered(Request $request, $id){

        $item = $this->rOrder->updatedDelivered($id);
        $response = array(
            'status' => 'success',
            'data'=> $item
        );
        return response()->json($response);
    }


    public function destroy($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $this->rOrder->deleted($id);
            $response = array(
                'status' => 'success'
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function destroyComand($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $this->rOrder->deleted($id);
            $response = array(
                'status' => 'success'
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }
}
