<?php

namespace App\Http\Controllers\Api\Sales;

use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\Proforma\ProformaRepository;
use App\Models\Tenant\Sale\ProformaDetail\ProformaDetailRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProformaApiController extends Controller
{
    protected $utilHelper;
    protected $rClient;
    protected $rProduct;
    protected $rProductEquivalence;
    protected $rProforma;
    protected $rProformaDetail;



    public function __construct()
    {
        $this->rProduct = new ProductRepository();
        $this->rProductEquivalence = new ProductEquivalenceRepository();
        $this->rClient = new ClientRepository();
        $this->rProforma = new ProformaRepository();
        $this->rProformaDetail = new ProformaDetailRepository();
        $this->utilHelper = new UtilHelper();
    }

    public function index(Request $request)
    {
        $query = $this->rProforma->listProforma($request);
        return response()->json($query);
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $proforma_data = $request->get('proforma');
            $detail_data = $request->get('detail');

            $proforma = $this->rProforma->create($proforma_data);

            //update client data
            $this->rClient->updatedFromProforma($proforma_data['client_id'], $proforma_data);

            foreach ($detail_data as $detail) {
                $detail['proforma_id'] = $proforma['id'];
                $detail['product_id'] = $detail['id'];
                $detail['equivalence'] = null;

                if ($detail['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $detail['equivalence'] =  $equivalence['equivalence'];
                }

                $this->rProformaDetail->create($detail);
            }

            $response = array(
                'status' => 'success',
                'data' => $proforma
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }


    public function edit($id)
    {
        $proforma = $this->rProforma->findJoined($id);
        $order_detail = $this->rProduct->findByJoinedProformaDetail($id);

        $result = array(
            'proforma' => $proforma,
            'detail' => $order_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }


    public function update(Request $request, $id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $proforma_data = $request->get('proforma');
            $detail_proforma_data = $request->get('detail');

            $proforma = $this->rProforma->updated($id, $proforma_data);

            //update client data
            $this->rClient->updatedFromProforma($proforma_data['client_id'], $proforma_data);

            // delete pass history orderdetail
            $detail_pass = $this->rProformaDetail->findByProformaId($proforma['id']);

            foreach ($detail_pass as $item) {
                $this->rProformaDetail->deleted($item->id);
            }

            foreach ($detail_proforma_data as $item) {
                $detail = $this->rProformaDetail->findByProformaIdAndProductId($proforma['id'], $item['id']);

                $item['equivalence'] = null;

                if ($item['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($item['id'], $item['unit_id']);
                    $item['equivalence'] =  $equivalence['equivalence'];
                }

                if($detail == null){
                    $item['proforma_id'] = $proforma['id'];
                    $item['product_id'] = $item['id'];
                    $this->rProformaDetail->create($item);
                } else {
                    $this->rProformaDetail->updated($detail['id'], $item);
                }
            }

            $response = array(
                'status' => 'success',
                'data' => $proforma
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }

    public function detail($id)
    {
        $proforma = $this->rProforma->findJoined($id);
        $proforma_detail = $this->rProformaDetail->findByProformaIdJoined($id);

        $result = array(
            'proforma' => $proforma,
            'detail' => $proforma_detail,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }


    public function destroy($id)
    {
        DB::connection('tenant')->beginTransaction();
        try {
            $this->rProforma->deleted($id);
            $response = array(
                'status' => 'success'
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }
}
