<?php

namespace App\Http\Controllers\Api\Sales;

use App\Core\SendBillingDocument;
use App\Core\TenantCore;
use App\Helper\UtilHelper;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Catalog\Product\ProductRepository;
use App\Models\Tenant\Catalog\ProductEquivalence\ProductEquivalenceRepository;
use App\Models\Tenant\Catalog\ProductStock\ProductStockRepository;
use App\Models\Tenant\Catalog\ProductVariant\ProductVariantRepository;
use App\Models\Tenant\Money\MoneyBox\MoneyBoxRepository;
use App\Models\Tenant\Money\Movement\MovementRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\Order\OrderRepository;
use App\Models\Tenant\Sale\Sale\SaleRepository;
use App\Models\Tenant\Sale\SaleAmortization\SaleAmortizationRepository;
use App\Models\Tenant\Sale\SaleDetail\SaleDetailRepository;
use App\Models\Tenant\Sale\SalePaid\SalePaidRepository;
use App\Models\Tenant\Sale\ScheduleSale\ScheduleSaleRepository;
use App\Models\Tenant\Sale\ScheduleSaleDetail\ScheduleSaleDetailRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SalesController extends Controller
{

    protected $utilHelper;
    protected $rClient;
    protected $rSale;
    protected $rSaleDetail;
    protected $rSalePaid;
    protected $rSaleAmortization;
    protected $rProductStock;
    protected $rMoneyMovement;
    protected $sendBilling;
    protected $rMoneyBox;
    protected $rProduct;
    protected $rProductEquivalence;
    protected $rScheduleSale;
    protected $rScheduleSaleDetail;
    protected $rOrder;
    protected $tenant;
    protected $rProductVariant;


    public function __construct()
    {
        $this->rClient = new ClientRepository();
        $this->rSale = new SaleRepository();
        $this->rSaleDetail = new SaleDetailRepository();
        $this->rProductStock = new ProductStockRepository();
        $this->rSalePaid = new SalePaidRepository();
        $this->rSaleAmortization = new SaleAmortizationRepository();
        $this->rMoneyMovement = new MovementRepository();
        $this->utilHelper = new UtilHelper();
        $this->sendBilling = new SendBillingDocument();
        $this->rMoneyBox = new MoneyBoxRepository();
        $this->rProduct = new ProductRepository();
        $this->rProductEquivalence = new ProductEquivalenceRepository();
        $this->rScheduleSale = new ScheduleSaleRepository();
        $this->rScheduleSaleDetail = new ScheduleSaleDetailRepository();
        $this->rOrder = new OrderRepository();
        $this->tenant = new TenantCore();
        $this->rProductVariant = new ProductVariantRepository();
    }


    public function index(Request $request)
    {
        $query = $this->rSale->listSale($request);
        return response()->json($query);
    }


    public function create()
    {
        //
    }


    public function storeToBook(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {

            $sale_data = $request->get('sale');
            $detail_data = $request->get('detail');

            //update client from sale
            // if ($this->utilHelper->strToBooleanValue($sale_data['client_default']) == false) {
            //     $this->rClient->updatedFromSale($sale_data['client_id'], $paid_data);
            // }

            // validate for client default
            // $this->utilHelper->validateAmountSaleByVoucherClientDefault($sale_data["client_id"], $sale_data["total"], $paid_data["typevoucher_id"]);

            // CREATE DATA
            $sale = $this->rSale->create($sale_data);

            // update if info order_id
            if($sale_data['order_id'] != null ){
                $order = $this->rOrder->find($sale_data['order_id']);
                $order->sale_id = $sale->id;
                $order->client_id = $sale->client_id;
               $order->save();
            }


            // verified if is from order

            if($this->utilHelper->strToBooleanValue($sale_data['is_order']) == true){
                $order = $this->rOrder->find($sale_data['order_id']);
                $order->sale_id = $sale['id'];
                $order->save();
            }

            $total_sale = $sale['total'];

            foreach ($detail_data as $detail) {
                $detail['sale_id'] = $sale['id'];
                $detail['product_id'] = $detail['id'];
                $detail_sale = $this->rSaleDetail->create($detail);

                $product = $this->rProduct->find($detail['product_id']);
                $productequivalence_id = null;
                $productvariant_id = null;
                $detail['equivalence'] = null;

                // replace data in sale detail  according type price product

                if ($product['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $detail['equivalence'] = $equivalence['equivalence'];
                    $productequivalence_id = $equivalence->id;
                }

                // ============

                if ($this->utilHelper->strToBooleanValue($detail['is_control_stock']) == true) {
                    // substract stock product

                    $stock = $detail['quantity'];

                    if ($product['typeprice_id'] == config('app.catalog_price_unit')) {
                        $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                        $stock = $equivalence['equivalence'] * $detail['quantity'];

                       //$detail_sale->productequivalence_id = $equivalence['id'];
                       // $detail_sale->equivalence_val = $equivalence['equivalence'];
                       // $detail_sale->save();

                        // set unit in product stock
                        $principal_equivalence = $this->rProductEquivalence->findPrincipalMeasureByProduct($detail['product_id']);
                        $detail['unit_id'] = $principal_equivalence['unit_id'];
                    }

                    $detail['quantity'] = $stock;
                    $detail['stock'] = $stock;

                    $this->rProductStock->substractStockByWarehouseFromSale($detail['product_id'], $detail);
                }

                $detail_sale->productequivalence_id =$productequivalence_id;
                $detail_sale->productvariant_id =$productvariant_id;
                $detail_sale->equivalence_val = $detail['equivalence'];
                $detail_sale->save();
            }

            $response = array(
                'status' => 'success',
                'sale' => $sale,
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $response_error = array(
                'message' => $e->getMessage(),
                'code' => $e->getCode()
            );
            return response()->json($response_error, 400);
        }
    }

    public function store(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {

            $sale_data = $request->get('sale');
            $paid_data = $request->get('paid');
            $detail_data = $request->get('detail');

            //update client from sale
            if ($this->utilHelper->strToBooleanValue($paid_data['client_default']) == false) {
                $this->rClient->updatedFromSale($sale_data['client_id'], $paid_data);
            }

            // validate for client default
            $this->utilHelper->validateAmountSaleByVoucherClientDefault($sale_data["client_id"], $sale_data["total"], $paid_data["typevoucher_id"]);

            // CREATE DATA
            $sale = $this->rSale->create($sale_data);

            // update if info order_id
            if($sale_data['order_id'] != null ){
                $order = $this->rOrder->find($sale_data['order_id']);
                $order->sale_id = $sale->id;
                $order->client_id = $sale->client_id;
               $order->save();
            }


            // verified if is from order

            if($this->utilHelper->strToBooleanValue($sale_data['is_order']) == true){
                $order = $this->rOrder->find($sale_data['order_id']);
                $order->sale_id = $sale['id'];
                $order->save();
            }

            $total_sale = $sale['total'];

            foreach ($detail_data as $detail) {
                $detail['sale_id'] = $sale['id'];
                $detail['product_id'] = $detail['id'];
                $detail_sale = $this->rSaleDetail->create($detail);

                $product = $this->rProduct->find($detail['product_id']);
                $productequivalence_id = null;
                $productvariant_id = null;
                $detail['equivalence'] = null;

                // replace data in sale detail  according type price product

                if ($product['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $detail['equivalence'] = $equivalence['equivalence'];
                    $productequivalence_id = $equivalence->id;
                }

                // ============

                if ($this->utilHelper->strToBooleanValue($detail['is_control_stock']) == true) {
                    // substract stock product

                    $stock = $detail['quantity'];

                    if ($product['typeprice_id'] == config('app.catalog_price_unit')) {
                        $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                        $stock = $equivalence['equivalence'] * $detail['quantity'];

                       //$detail_sale->productequivalence_id = $equivalence['id'];
                       // $detail_sale->equivalence_val = $equivalence['equivalence'];
                       // $detail_sale->save();

                        // set unit in product stock
                        $principal_equivalence = $this->rProductEquivalence->findPrincipalMeasureByProduct($detail['product_id']);
                        $detail['unit_id'] = $principal_equivalence['unit_id'];
                    }

                    $detail['quantity'] = $stock;
                    $detail['stock'] = $stock;

                    $this->rProductStock->substractStockByWarehouseFromSale($detail['product_id'], $detail);
                }

                $detail_sale->productequivalence_id =$productequivalence_id;
                $detail_sale->productvariant_id =$productvariant_id;
                $detail_sale->equivalence_val = $detail['equivalence'];
                $detail_sale->save();
            }

            // sale  paid =======
            $arr_salepaid = array();
            $arr_salepaid['sale_id'] = $sale['id'];
            $arr_salepaid['total_amount'] = $total_sale;
            $arr_salepaid['total_paid'] = $total_sale;

            if ($sale['typetransaction_id'] == config('app.transaction_credit')){
                $schedule_data = $request->get('schedule');
                $schedule_data['sale_id'] = $sale['id'];

                // create schedule
                $schedule = $this->rScheduleSale->create($schedule_data);

                // detail schedule
                $date_assigned = $schedule_data['first_date_schedule'];
//                $amount_assigned = number_format($total_sale/$schedule_data['number_quota'], 2);
                $amount_assigned = round($total_sale/$schedule_data['number_quota'],2);

                for ($i = 1; $i <= (int)$schedule_data['number_quota']; $i++) {
                    $detail_schedule = array();

                    $detail_schedule['date_assigned'] = $date_assigned;
                    $detail_schedule['number_quota'] = $i;
                    $detail_schedule['amount_assigned'] = $amount_assigned;
                    $detail_schedule['schedule_id'] = $schedule['id'];
                    $this->rScheduleSaleDetail->create($detail_schedule);

                    $date_assigned = strtotime('+'.$schedule_data['interval_schedule'].' days', strtotime($date_assigned));
                    $date_assigned = date('Y-m-d', $date_assigned);
                }


                // change payment method
                $paid_data['paymentmethod_id'] = config('app.paymethod_quota');


                $arr_salepaid['total_paid'] = 0;
                $total_sale = 0;
            }

            $salepaid = $this->rSalePaid->create($arr_salepaid);

            // update amount box money

            $billing = false;
            if ($this->utilHelper->strToBooleanValue($paid_data['is_paid']) == true) {

                $moneybox = $this->rMoneyBox->getBoxMoney();

                // create money movement
                $paid_data['client_id'] = $sale['client_id'];
                $paid_data['amount'] = $sale['total'];
                $paid_data['moneybox_id'] = $moneybox->id;
                $moneymovement = $this->rMoneyMovement->create($paid_data);


                if ($moneymovement['paymentmethod_id'] == config('app.paymethod_cash')) {
                    $this->rMoneyBox->sumAmount($moneybox, $moneymovement['amount']);
                }

                // create amortization sale
                $arr_amortization = array();

                $arr_amortization['salepaid_id'] = $salepaid['id'];
                $arr_amortization['moneymovement_id'] = $moneymovement['id'];
                $arr_amortization['total_amount'] = $total_sale;
                $saleamortization = $this->rSaleAmortization->create($arr_amortization);

                // SEND BILLING DOCUMENT TO FACTURADOR
                if($moneymovement['voucher_id'] == config('app.voucher_boleta_id') or $moneymovement['voucher_id'] == config('app.voucher_factura_id')){
                    $company = $this->tenant->company();
                    if($company->send_billing == true){
                        $billing = $this->sendBilling->facturaExonerada($sale, $moneymovement);
                    }
                }
            }

            $response = array(
                'status' => 'success',
                'sale' => $sale,
                'billing' => $billing
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            $response_error = array(
                'message' => $e->getMessage(),
                'code' => $e->getCode()
            );
//            return response()->json($e->getMessage(), 400);
            return response()->json($response_error, 400);
        }
    }


    public function storeCommand(Request $request)
    {
        DB::connection('tenant')->beginTransaction();
        try {

            $sale_data = $request->get('sale');
            $paid_data = $request->get('paid');
            $detail_data = $request->get('detail');

            //update client from sale
            if ($this->utilHelper->strToBooleanValue($paid_data['client_default']) == false) {
                $this->rClient->updatedFromSale($sale_data['client_id'], $paid_data);
            }

            // CREATE DATA
            $sale = $this->rSale->create($sale_data);

            // update if info order_id
            if($sale_data['order_id'] != null ){
                $order = $this->rOrder->find($sale_data['order_id']);
                $order->sale_id = $sale->id;
                $order->client_id = $sale->client_id;
                $order->save();
            }


            // verified if is from order

            if($this->utilHelper->strToBooleanValue($sale_data['is_order']) == true){
                $order = $this->rOrder->find($sale_data['order_id']);
                $order->sale_id = $sale['id'];
                $order->save();
            }


            $total_sale = $sale['total'];

            foreach ($detail_data as $detail) {
                $detail['sale_id'] = $sale['id'];
                $detail['product_id'] = $detail['id'];
                $detail_sale = $this->rSaleDetail->create($detail);

                $product = $this->rProduct->find($detail['product_id']);
                $productequivalence_id = null;
                $productvariant_id = null;
                $detail['equivalence'] = null;


                if ($product['typeprice_id'] == config('app.catalog_price_variant')) {
                    $variant = $this->rProductVariant->findByProductAndTypeVariant($detail['product_id'], $detail['variant_id']);
                    $detail['equivalence'] = $variant['equivalence'];
                    $productvariant_id = $variant->id;
                }

                if ($product['typeprice_id'] == config('app.catalog_price_unit')) {
                    $equivalence = $this->rProductEquivalence->findByProductAndUnit($detail['product_id'], $detail['unit_id']);
                    $detail['equivalence'] = $equivalence['equivalence'];
                    $productequivalence_id = $equivalence->id;
                }


                if ($this->utilHelper->strToBooleanValue($detail['is_control_stock']) == true) {
                    // substract stock product

                    $stock = $detail['quantity'];

                    if ($product['typeprice_id'] == config('app.catalog_price_unit')) {
                        $stock = $equivalence['equivalence'] * $detail['quantity'];
//                        $detail_sale->save();

                        // set unit in product stock
                        $principal_equivalence = $this->rProductEquivalence->findPrincipalMeasureByProduct($detail['product_id']);
                        $detail['unit_id'] = $principal_equivalence['unit_id'];
                    }

                    if ($product['typeprice_id'] == config('app.catalog_price_variant')) {
                        $stock = $variant['equivalence'] * $detail['quantity'];
                        // set unit in product stock
                        $detail['unit_id'] = $variant['unit_id'];
                    }


                    $detail['quantity'] = $stock;
                    $detail['stock'] = $stock;

                    $this->rProductStock->substractStockByWarehouseFromSale($detail['product_id'], $detail);
                }

                $detail_sale->productequivalence_id =$productequivalence_id;
                $detail_sale->productvariant_id =$productvariant_id;
                $detail_sale->equivalence_val = $detail['equivalence'];
                $detail_sale->save();
            }

            // sale  paid =======
            $arr_salepaid = array();
            $arr_salepaid['sale_id'] = $sale['id'];
            $arr_salepaid['total_amount'] = $total_sale;
            $arr_salepaid['total_paid'] = $total_sale;

            if ($sale['typetransaction_id'] == config('app.transaction_credit')){
                $schedule_data = $request->get('schedule');
                $schedule_data['sale_id'] = $sale['id'];

                // create schedule
                $schedule = $this->rScheduleSale->create($schedule_data);

                // detail schedule
                $date_assigned = $schedule_data['first_date_schedule'];
//                $amount_assigned = number_format($total_sale/$schedule_data['number_quota'], 2);
                $amount_assigned = round($total_sale/$schedule_data['number_quota'],2);

                for ($i = 1; $i <= (int)$schedule_data['number_quota']; $i++) {
                    $detail_schedule = array();

                    $detail_schedule['date_assigned'] = $date_assigned;
                    $detail_schedule['number_quota'] = $i;
                    $detail_schedule['amount_assigned'] = $amount_assigned;
                    $detail_schedule['schedule_id'] = $schedule['id'];
                    $this->rScheduleSaleDetail->create($detail_schedule);

                    $date_assigned = strtotime('+'.$schedule_data['interval_schedule'].' days', strtotime($date_assigned));
                    $date_assigned = date('Y-m-d', $date_assigned);
                }


                // change payment method
                $paid_data['paymentmethod_id'] = config('app.paymethod_quota');


                $arr_salepaid['total_paid'] = 0;
                $total_sale = 0;
            }

            $salepaid = $this->rSalePaid->create($arr_salepaid);

            // update amount box money

            $billing = false;
            if ($this->utilHelper->strToBooleanValue($paid_data['is_paid']) == true) {

                $moneybox = $this->rMoneyBox->getBoxMoney();

                // create money movement
                $paid_data['client_id'] = $sale['client_id'];
                $paid_data['amount'] = $sale['total'];
                $paid_data['moneybox_id'] = $moneybox->id;
                $moneymovement = $this->rMoneyMovement->create($paid_data);


                if ($moneymovement['paymentmethod_id'] == config('app.paymethod_cash')) {
                    $this->rMoneyBox->sumAmount($moneybox, $moneymovement['amount']);
                }

                // create amortization sale
                $arr_amortization = array();

                $arr_amortization['salepaid_id'] = $salepaid['id'];
                $arr_amortization['moneymovement_id'] = $moneymovement['id'];
                $arr_amortization['total_amount'] = $total_sale;
                $saleamortization = $this->rSaleAmortization->create($arr_amortization);

                // SEND BILLING DOCUMENT TO FACTURADOR
                if($moneymovement['voucher_id'] == config('app.voucher_boleta_id') or $moneymovement['voucher_id'] == config('app.voucher_factura_id')){
                    $company = $this->tenant->company();
                    if($company->send_billing == true){
                        $billing = $this->sendBilling->facturaExonerada($sale, $moneymovement);
                    }
                }
            }


            $response = array(
                'status' => 'success',
                'sale' => $sale,
                'billing' => $billing
            );

            DB::connection('tenant')->commit();
            return response()->json($response);

        } catch (\Exception $e) {
            DB::connection('tenant')->rollback();
            return response()->json($e->getMessage(), 400);
        }
    }



    public function show($id)
    {
        //
    }

    public function detail($id)
    {
        $sale = $this->rSale->find($id);
        $sale_detail = $this->rSaleDetail->findBySaleJoined($sale['id']);
        $movements = $this->rSalePaid->getMovementBySale($sale['id']);

        $result = array(
            'sale' => $sale,
            'detail' => $sale_detail,
            'movements' => $movements
        );

        $response = array(
            'status' => 'success',
            'data' => $result
        );
        return response()->json($response);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function remakeSale($id)
    {
        $sale = $this->rSale->findJoinedRemake($id);
        $sale_detail = $this->rProduct->findByJoinedSaleDetail($id);

        $result = array(
            'sale' => $sale,
            'detail' => $sale_detail,
            'is_remake' => true,
        );

        $response = array(
            'status' => 'success',
            'data'=> $result
        );
        return response()->json($response);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
