<?php

namespace App\Http\Controllers\Api;

use App\Core\Services\Api\ServiceData;
use App\Core\Services\Dni\Dni;
use App\Core\Services\Ruc\Sunat;
use App\Http\Controllers\Controller;
use App\Models\Tenant\Ubigeo\Department\Department;
use App\Models\Tenant\Ubigeo\Department\DepartmentRepository;
use App\Models\Tenant\Ubigeo\District\District;
use App\Models\Tenant\Ubigeo\District\DistrictRepository;
use App\Models\Tenant\Ubigeo\Province\Province;
use App\Models\Tenant\Ubigeo\Province\ProvinceRepository;
use Illuminate\Http\Request;

class ServiceApiController extends Controller
{
    protected $serviceData;
    protected $rUbigeoDepartment;
    protected $rUbigeoProvince;
    protected $rUbigeoDistrict;

    public function __construct()
    {
        $this->serviceData = new ServiceData();
        $this->rUbigeoDepartment = new DepartmentRepository();
        $this->rUbigeoProvince = new ProvinceRepository();
        $this->rUbigeoDistrict = new DistrictRepository();
    }

    public function index()
    {
        //
    }

    public function dni($number)
    {
        try {
            $status_api_service = config('app.api_service');
            if ($status_api_service) {
                $type = 'dni';
                $alert_status = "success";
                $res = $this->serviceData->service($type, $number);

                if ($res['success']) {
                    $res_data = $res['data'];
                    return [
                        'success' => true,
                        'data' => [
                            // 'verification_code' => $res_data['codigo_verificacion'],
                            'document' => $res_data['numero'],
                            'fullname' => $res_data['nombre_completo'],
                            'name' => $res_data['nombres'],
                            'first_name' => $res_data['apellido_paterno'],
                            'last_name' => $res_data['apellido_materno'],
                            // 'date_of_birthday' => $res_data['fecha_nacimiento'],
                            // 'sex' => $res_data['sexo'],
                            'address' => $res_data['direccion'],
                            'alert_status' => $alert_status
                        ]
                    ];
                } else {
                    return [
                        'success' => false,
                        'message' => $res['message']
                    ];
                }
            } else {
                $res = Dni::search($number);
                return $res;
            }

        } catch (\Exception $e) {
            $error = array(
                'code' => $e->getCode(),
                // 'message' => 'No se puede extraer la información solicitada. Verifique su conexión a internet',
                'message' => $e->getMessage(),
            );
            return response()->json($error, 400);
        }
    }


    public function ruc($number)
    {
        try{
            $status_api_service = config('app.api_service');
            if($status_api_service){
                $type = 'ruc';
                $res = $this->serviceData->service($type, $number);
                if($res['success']){
                    $res_data = $res['data'];
                    $alert_status = "warning";
                    if($res_data['estado'] == 'ACTIVO' and $res_data['condicion']=='HABIDO'){
                        $alert_status = "success";
                    }

                    $ubigeo_arr = false;

                    if($res_data['ubigeo'][0]!=='-'){
                        $ubigeo_arr = array(
                            'department_id' => $res_data['ubigeo'][0],
                            'province_id' => $res_data['ubigeo'][1],
                            'district_id' => $res_data['ubigeo'][2],
                            'departments' => $this->rUbigeoDepartment->all(),
                            'provinces' => $this->rUbigeoProvince->allByDepartment($res_data['ubigeo'][0]),
                            'districts' => $this->rUbigeoDistrict->allByProvince($res_data['ubigeo'][1]),
                        );
                    }

                    $address = "";

                    if(isset($res_data['direccion'])){
                        $address = $res_data['direccion'];
                    }

                    return [
                        'success' => true,
                        'data' => [
                            'document' => $res_data['ruc'],
                            'name' => $res_data['nombre_o_razon_social'],
                            'trade_name' => $res_data['nombre_o_razon_social'],
                            'address' => $address,
                            'phone' => null,
                            'ubigeo'=>$ubigeo_arr,
                            'department_id' => $res_data['ubigeo'][0],
                            'province_id' => $res_data['ubigeo'][1],
                            'district_id' => $res_data['ubigeo'][2],
                            'condition'=> $res_data['condicion'],
                            'status'=> $res_data['estado'],
                            'alert_status'=>$alert_status
                        ]
                    ];
                }else{
                    return [
                        'success' => false,
                        'message' => $res['message']
                    ];
                }

            }
            else{
                $service = new Sunat();
                $res = $service->get($number);

                if ($res) {
                    $province_id = Province::idByDescription($res->provincia);

                    $alert_status = "warning";
                    if($res->estado == 'ACTIVO' and $res->condicion=='HABIDO'){
                        $alert_status = "success";
                    }

                    return [
                        'success' => true,
                        'data' => [
                            'name' => $res->razonSocial,
                            'trade_name' => $res->nombreComercial,
                            'address' => $res->direccion,
                            'phone' => implode(' / ', $res->telefonos),
                            'department' => ($res->departamento)?:'LIMA',
                            'department_id' => Department::idByDescription($res->departamento),
                            'province' => ($res->provincia)?:'LIMA',
                            'province_id' => $province_id,
                            'district' => ($res->distrito)?:'LIMA',
                            'district_id' => District::idByDescription($res->distrito, $province_id),
                            'condition'=> $res->condicion,
                            'status'=> $res->estado,
                            'alert_status'=>$alert_status
                        ]
                    ];
                } else {
                    return [
                        'success' => false,
                        'message' => $service->getError()
                    ];
                }
            }
        } catch (\Exception $e) {
            $error = array(
                'code' => $e->getCode(),
//                'message' => $e->getMessage(),
//                'message' => 'No se puede extraer la información solicitada. Verifique su conexión a internet',
                'message' => 'No se encontraron registros.',
            );
            return response()->json($error, 400);
        }
    }





    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
